<?php
// ISOLATED CERTIFICATE DEBUG SCRIPT
// This script will debug exactly why wrong certificates are showing

error_reporting(E_ALL);
ini_set('display_errors', 1);

if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

require_once '../config/db_connect.php';

$user_id = 15; // Fixed user ID for debugging

echo "<h1>🔍 ISOLATED CERTIFICATE DEBUG SCRIPT</h1>";
echo "<div style='font-family: monospace; background: #f0f0f0; padding: 20px;'>";

echo "<h2>1. USER INFO</h2>";
echo "User ID: $user_id<br>";

// Get user info
$user_stmt = $conn->prepare("SELECT first_name, last_name, email FROM users WHERE user_id = ?");
if ($user_stmt) {
    $user_stmt->bind_param("i", $user_id);
    $user_stmt->execute();
    $user_result = $user_stmt->get_result();
    if ($user_row = $user_result->fetch_assoc()) {
        echo "Name: " . $user_row['first_name'] . " " . $user_row['last_name'] . "<br>";
        echo "Email: " . $user_row['email'] . "<br>";
    }
    $user_stmt->close();
}

echo "<h2>2. ENROLLMENTS</h2>";
$enrollments = $conn->query("SELECT * FROM enrollments WHERE student_id = $user_id");
if ($enrollments) {
    while ($enrollment = $enrollments->fetch_assoc()) {
        echo "- Course ID: " . $enrollment['course_id'] . ", Enrolled: " . $enrollment['enrolled_date'] . "<br>";
    }
}

echo "<h2>3. DETAILED COURSE ANALYSIS</h2>";

// Get courses with enrollments
$courses_stmt = $conn->prepare("
    SELECT c.course_id, c.title, c.description, u.first_name, u.last_name, e.enrolled_date
    FROM courses c
    JOIN enrollments e ON c.course_id = e.course_id
    JOIN users u ON c.teacher_id = u.user_id
    WHERE e.student_id = ?
    ORDER BY c.course_id
");

if ($courses_stmt) {
    $courses_stmt->bind_param("i", $user_id);
    $courses_stmt->execute();
    $courses_result = $courses_stmt->get_result();
    
    while ($course = $courses_result->fetch_assoc()) {
        echo "<h3>📚 COURSE: " . $course['title'] . " (ID: " . $course['course_id'] . ")</h3>";
        echo "Instructor: " . $course['first_name'] . " " . $course['last_name'] . "<br>";
        echo "Enrolled: " . $course['enrolled_date'] . "<br>";
        
        // Check videos in course
        $videos_stmt = $conn->prepare("SELECT video_id, title, is_published FROM videos WHERE course_id = ?");
        if ($videos_stmt) {
            $videos_stmt->bind_param("i", $course['course_id']);
            $videos_stmt->execute();
            $videos_result = $videos_stmt->get_result();
            $videos = $videos_result->fetch_all(MYSQLI_ASSOC);
            
            echo "Total videos: " . count($videos) . "<br>";
            
            if (count($videos) > 0) {
                echo "Videos in course:<br>";
                foreach ($videos as $video) {
                    echo "&nbsp;&nbsp;- " . $video['title'] . " (Published: " . ($video['is_published'] ? 'Yes' : 'No') . ")<br>";
                }
                
                // Check video progress for this student
                $progress_stmt = $conn->prepare("
                    SELECT v.video_id, v.title, vp.completed, vp.watch_time
                    FROM videos v
                    LEFT JOIN video_progress vp ON v.video_id = vp.video_id AND vp.student_id = ?
                    WHERE v.course_id = ? AND v.is_published = 1
                ");
                if ($progress_stmt) {
                    $progress_stmt->bind_param("ii", $user_id, $course['course_id']);
                    $progress_stmt->execute();
                    $progress_result = $progress_stmt->get_result();
                    
                    $total_videos = 0;
                    $completed_videos = 0;
                    
                    echo "Video Progress:<br>";
                    while ($progress = $progress_result->fetch_assoc()) {
                        $total_videos++;
                        $is_completed = $progress['completed'] ? true : false;
                        if ($is_completed) $completed_videos++;
                        
                        echo "&nbsp;&nbsp;- " . $progress['title'] . ": " . 
                             ($is_completed ? "✅ COMPLETED" : "❌ NOT COMPLETED") . 
                             " (Watch time: " . ($progress['watch_time'] ?? 0) . "s)<br>";
                    }
                    
                    $actual_progress = $total_videos > 0 ? round(($completed_videos / $total_videos) * 100, 1) : 0;
                    echo "<strong>ACTUAL PROGRESS: $actual_progress% ($completed_videos/$total_videos)</strong><br>";
                    echo "<strong>QUALIFIES FOR CERTIFICATE (90%+): " . ($actual_progress >= 90 ? "✅ YES" : "❌ NO") . "</strong><br>";
                    
                    $progress_stmt->close();
                }
            } else {
                echo "<strong>⚠️ NO VIDEOS IN COURSE - SHOULD NOT GET CERTIFICATE</strong><br>";
            }
            
            $videos_stmt->close();
        }
        
        echo "<hr>";
    }
    
    $courses_stmt->close();
}

echo "<h2>4. CERTIFICATE GENERATION CHECK</h2>";

// Test the exact same logic used in the main certificates page
$completed_courses_stmt = $conn->prepare("
    SELECT 
        c.course_id,
        c.title,
        c.description,
        c.thumbnail,
        u.first_name,
        u.last_name,
        e.enrolled_date as enrollment_date
    FROM courses c
    JOIN enrollments e ON c.course_id = e.course_id
    JOIN users u ON c.teacher_id = u.user_id
    WHERE e.student_id = ?
    ORDER BY c.course_id DESC
");

if ($completed_courses_stmt) {
    $completed_courses_stmt->bind_param("i", $user_id);
    $completed_courses_stmt->execute();
    $completed_courses_result = $completed_courses_stmt->get_result();
    
    if ($completed_courses_result) {
        $completed_courses = $completed_courses_result->fetch_all(MYSQLI_ASSOC);
        
        echo "Courses from main query: " . count($completed_courses) . "<br>";
        
        // Add progress calculation for each course (same as main logic)
        foreach ($completed_courses as &$course) {
            echo "<h4>Testing progress for: " . $course['title'] . "</h4>";
            
            $progress_stmt = $conn->prepare("
                SELECT 
                    CASE 
                        WHEN COUNT(v.video_id) = 0 THEN 100
                        ELSE ROUND((COUNT(CASE WHEN vp.completed = 1 THEN 1 END) / COUNT(v.video_id)) * 100, 1)
                    END as progress_percentage
                FROM videos v
                LEFT JOIN video_progress vp ON v.video_id = vp.video_id AND vp.student_id = ?
                WHERE v.course_id = ? AND v.is_published = 1
            ");
            
            if ($progress_stmt) {
                $progress_stmt->bind_param("ii", $user_id, $course['course_id']);
                $progress_stmt->execute();
                $progress_result = $progress_stmt->get_result();
                if ($progress_result) {
                    $progress_row = $progress_result->fetch_assoc();
                    $course['progress_percentage'] = $progress_row['progress_percentage'] ?? 0;
                    
                    echo "❌ FAULTY MAIN LOGIC RESULT: " . $course['progress_percentage'] . "%<br>";
                    echo "🔍 ISSUE: This query returns 100% when COUNT(v.video_id) = 0<br>";
                }
                $progress_stmt->close();
            }
            
            // Add instructor name
            $course['instructor_name'] = $course['first_name'] . ' ' . $course['last_name'];
            $course['completion_date'] = $course['enrollment_date'];
        }
        
        // Filter courses with at least 90% progress
        $qualifying_courses = array_filter($completed_courses, function($course) {
            return ($course['progress_percentage'] ?? 0) >= 90;
        });
        
        echo "<h4>🎯 COURSES THAT WILL GET CERTIFICATES:</h4>";
        foreach ($qualifying_courses as $course) {
            echo "- " . $course['title'] . " (" . $course['progress_percentage'] . "%)<br>";
        }
    }
    
    $completed_courses_stmt->close();
}

echo "</div>";
?>
