<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔍 Course Reviews Database Schema Checker</h2>";

// Include session and encryption
require_once '../includes/session_start.php';
require_once '../includes/id_encryption.php';

// Database connection - try multiple methods
$pdo = null;
$connection_method = '';

// Method 1: Try db_connect.php
try {
    require_once '../includes/db_connect.php';
    if (isset($conn) && $conn instanceof mysqli) {
        // Convert mysqli to PDO
        $host = 'localhost';
        $dbname = 'twpurnyc_panadite_DB';
        $username = 'twpurnyc_149586Alain';
        $password = '149586Alain#';
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $connection_method = 'db_connect.php (converted from mysqli)';
    }
} catch (Exception $e) {
    echo "<p>❌ db_connect.php failed: " . $e->getMessage() . "</p>";
}

// Method 2: Direct PDO connection
if (!$pdo) {
    try {
        $host = 'localhost';
        $dbname = 'twpurnyc_panadite_DB';
        $username = 'twpurnyc_149586Alain';
        $password = '149586Alain#';
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $connection_method = 'Direct PDO connection';
    } catch (Exception $e) {
        echo "<p>❌ Direct PDO connection failed: " . $e->getMessage() . "</p>";
        exit;
    }
}

echo "<p>✅ Database connected via: <strong>$connection_method</strong></p>";

// Check if course_reviews table exists
echo "<h3>📋 Table Structure Check</h3>";
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'course_reviews'");
    $table_exists = $stmt->rowCount() > 0;
    
    if ($table_exists) {
        echo "<p>✅ Table 'course_reviews' exists</p>";
        
        // Show table structure
        $stmt = $pdo->query("DESCRIBE course_reviews");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>Column</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        foreach ($columns as $col) {
            echo "<tr>";
            echo "<td>" . $col['Field'] . "</td>";
            echo "<td>" . $col['Type'] . "</td>";
            echo "<td>" . $col['Null'] . "</td>";
            echo "<td>" . $col['Key'] . "</td>";
            echo "<td>" . $col['Default'] . "</td>";
            echo "<td>" . $col['Extra'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Count existing reviews
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM course_reviews");
        $count = $stmt->fetch()['count'];
        echo "<p>📊 Existing reviews: <strong>$count</strong></p>";
        
    } else {
        echo "<p>⚠️ Table 'course_reviews' does NOT exist</p>";
        echo "<p>🔧 Attempting to create table...</p>";
        
        $create_sql = "CREATE TABLE course_reviews (
            review_id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            course_id INT NOT NULL,
            rating INT NOT NULL CHECK (rating >= 1 AND rating <= 5),
            review_title VARCHAR(255) NOT NULL,
            review_text TEXT NOT NULL,
            status ENUM('pending', 'approved', 'rejected') DEFAULT 'approved',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX idx_course_reviews_course (course_id),
            INDEX idx_course_reviews_user (user_id),
            INDEX idx_course_reviews_status (status),
            UNIQUE KEY unique_user_course_review (user_id, course_id)
        )";
        
        try {
            $pdo->exec($create_sql);
            echo "<p>✅ Table created successfully!</p>";
        } catch (Exception $e) {
            echo "<p>❌ Table creation failed: " . $e->getMessage() . "</p>";
        }
    }
} catch (Exception $e) {
    echo "<p>❌ Table check failed: " . $e->getMessage() . "</p>";
}

// Test insert permissions
echo "<h3>🔐 Insert Permission Test</h3>";
try {
    // Test with minimal data
    $test_insert = "INSERT INTO course_reviews (user_id, course_id, rating, review_title, review_text) VALUES (999, 999, 5, 'Test Review', 'Test review text')";
    $stmt = $pdo->prepare($test_insert);
    $result = $stmt->execute();
    
    if ($result) {
        $test_id = $pdo->lastInsertId();
        echo "<p>✅ Test insert successful! Review ID: $test_id</p>";
        
        // Clean up test data
        $pdo->prepare("DELETE FROM course_reviews WHERE review_id = ?")->execute([$test_id]);
        echo "<p>🧹 Test data cleaned up</p>";
    }
} catch (Exception $e) {
    echo "<p>❌ Insert test failed: " . $e->getMessage() . "</p>";
    echo "<p>📋 Error details: " . print_r($e->errorInfo ?? 'No error info', true) . "</p>";
}

// Session check
echo "<h3>👤 Session Check</h3>";
if (isset($_SESSION['user_id'])) {
    echo "<p>✅ User logged in: ID " . $_SESSION['user_id'] . "</p>";
} else {
    echo "<p>⚠️ No user session found</p>";
}

// Course ID test
echo "<h3>🔐 Course ID Encryption Test</h3>";
$test_encrypted = "cTR5c2l6cGROaVQxdjlXUUpHdDB5dz09"; // From your URL
try {
    $decrypted = decryptId($test_encrypted);
    echo "<p>✅ Encryption working: '$test_encrypted' → '$decrypted'</p>";
} catch (Exception $e) {
    echo "<p>❌ Decryption failed: " . $e->getMessage() . "</p>";
}

echo "<h3>🎯 Next Steps</h3>";
echo "<p>1. Check this page for any red ❌ errors</p>";
echo "<p>2. If table exists and insert test passes, the issue is in the review submission logic</p>";
echo "<p>3. If insert test fails, it's a database permission issue</p>";
?>
