<?php
// Modern Student Header - Admin Style Design
// Get current page for dynamic titles and navigation
if (!isset($currentPage)) {
    $currentPage = basename($_SERVER['PHP_SELF'], '.php');
}

// Function to get page title
function getPageTitle() {
    $currentPage = basename($_SERVER['PHP_SELF'], '.php');
    
    $titles = [
        'dashboard' => 'Student Dashboard',
        'courses' => 'My Courses',
        'assignments' => 'Assignments',
        'calendar' => 'Calendar',
        'certificates' => 'Certificates',
        'library' => 'Library',
        'messages' => 'Messages',
        'quiz-results' => 'Quiz Results',
        'profile' => 'My Profile',
        'settings' => 'Settings',
        'help' => 'Help & Support'
    ];
    
    return $titles[$currentPage] ?? ucfirst($currentPage);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= getPageTitle() ?> | Panadite Academy</title>
    
    <!-- Favicon - Comprehensive Fallback Options (Same as Teacher Layout) -->
    <link rel="shortcut icon" href="/assets/images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/assets/images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/logo.jpeg" type="image/jpeg">
    <link rel="icon" href="/assets/images/logo.jpeg" type="image/jpeg">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="/logo.jpeg">
    <link rel="apple-touch-icon" href="/assets/images/logo.jpeg">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Boxicons -->
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Admin Dashboard CSS -->
    <link rel="stylesheet" href="/assets/css/admin-dashboard.css">
    
    <!-- Search Dropdown CSS -->
    <link rel="stylesheet" href="/assets/css/search-dropdown.css">
    
    <style>
        /* Modern Student Layout - Admin Style */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background-color: #E4E9F7;
            color: #5a5c69;
            overflow-x: hidden;
        }
        
        /* Main Layout Container */
        .home-section {
            position: relative;
            background: #E4E9F7;
            min-height: 100vh;
            top: 0;
            left: 240px;
            width: calc(100% - 240px);
            transition: all 0.5s ease;
            z-index: 2;
        }
        
        .sidebar.close ~ .home-section {
            left: 78px;
            width: calc(100% - 78px);
        }
        
        /* Content Area */
        .home-content {
            padding-top: 85px;
            padding-left: 1.5rem;
            padding-right: 1.5rem;
            padding-bottom: 2rem;
            min-height: 100vh;
        }
        
        /* Page Header */
        .page-header {
            background: white;
            padding: 1.5rem 2rem;
            margin-bottom: 2rem;
            border-radius: 0.75rem;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            border-left: 4px solid #4e73df;
        }
        
        .page-title {
            font-size: 1.75rem;
            font-weight: 400;
            color: #5a5c69;
            margin: 0;
        }
        
        /* Content Cards */
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            margin-bottom: 1.5rem;
        }
        
        .card-header {
            background: #f8f9fc;
            border-bottom: 1px solid #e3e6f0;
            border-radius: 0.75rem 0.75rem 0 0;
            padding: 1rem 1.5rem;
        }
        
        .card-body {
            padding: 1.5rem;
        }
        
        /* Dashboard specific adjustments */
        .dashboard-banner {
            margin-top: 0 !important;
            border-radius: 0.75rem;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        }
        
        .modern-courses-section {
            background: white;
            border-radius: 0.75rem;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .home-section {
                left: 0 !important;
                width: 100% !important;
            }
            
            .home-content {
                padding-left: 1rem;
                padding-right: 1rem;
                padding-top: 75px;
            }
            
            .page-header {
                padding: 1rem 1.5rem;
            }
            
            .page-title {
                font-size: 1.5rem;
            }
        }
        
        @media (max-width: 576px) {
            .home-content {
                padding-left: 0.75rem;
                padding-right: 0.75rem;
            }
            
            .page-header {
                padding: 0.75rem 1rem;
            }
        }
        
        /* Button Styles */
        .btn-primary {
            background: #4e73df;
            border-color: #4e73df;
            font-weight: 400;
        }
        
        .btn-primary:hover {
            background: #2e59d9;
            border-color: #2653d4;
        }
        
        /* Alert Styles */
        .alert {
            border: none;
            border-radius: 0.35rem;
            border-left: 4px solid;
        }
        
        .alert-success {
            background-color: #d1eddf;
            color: #155724;
            border-left-color: #1cc88a;
        }
        
        .alert-info {
            background-color: #d6f3f7;
            color: #0c5460;
            border-left-color: #36b9cc;
        }
        
        .alert-warning {
            background-color: #fdf2d0;
            color: #856404;
            border-left-color: #f6c23e;
        }
        
        .alert-danger {
            background-color: #f5c6cb;
            color: #721c24;
            border-left-color: #e74a3b;
        }
        
        /* Table Styles */
        .table {
            color: #5a5c69;
        }
        
        .table thead th {
            background: #f8f9fc;
            border-bottom: 1px solid #e3e6f0;
            color: #5a5c69;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.85rem;
        }
        
        .table tbody tr:hover {
            background-color: #f8f9fc;
        }
        
        /* Form Styles */
        .form-control {
            border: 1px solid #d1d3e2;
            border-radius: 0.35rem;
        }
        
        .form-control:focus {
            border-color: #bac8f3;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }
        
        /* Loading Animation */
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        
        @keyframes fadeIn {
            from { 
                opacity: 0; 
                transform: translateY(10px); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
    </style>
</head>
<body>
    <!-- Include Sidebar -->
    <?php include_once __DIR__ . '/sidebar.php'; ?>
    
    <!-- Main Content Area -->
    <section class="home-section">
        <!-- Include Navbar -->
        <?php include_once __DIR__ . '/navbar.php'; ?>
        
        <!-- Home Content -->
        <div class="home-content fade-in">
            <!-- Content will be inserted here by each page -->
