<?php
$current_page = basename($_SERVER['PHP_SELF']);

// Get user information for profile section
$studentName = 'Student';
$userInitials = 'ST';
$profileImage = null;
$userId = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;

if ($userId && isset($conn) && $conn) {
    $query = "SELECT first_name, last_name, username, email FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $userData = $result->fetch_assoc();
        $studentName = $userData['first_name'] . ' ' . $userData['last_name'];
        $userInitials = strtoupper(substr($userData['first_name'], 0, 1) . substr($userData['last_name'], 0, 1));
    }
}
?>

<div class="sidebar">
    <div class="logo-details">
        <a href="/index.php">
            <img src="/assets/images/logo.jpeg" alt="Panadite Academy" class="logo-img">
        </a>
        <span class="logo-name">Panadite</span>
        <button class="sidebar-close-btn" id="sidebar-close-btn">
            <i class='bx bx-x'></i>
        </button>
    </div>
    
    <ul class="nav-links">
        <!-- Main Navigation -->
        <li class="<?= $current_page == 'dashboard.php' ? 'active' : '' ?>">
            <a href="dashboard.php">
                <i class='bx bxs-dashboard'></i>
                <span class="link_name">Dashboard</span>
            </a>
        </li>
        
        <li class="<?= $current_page == 'courses.php' ? 'active' : '' ?>">
            <a href="courses.php">
                <i class='bx bxs-graduation'></i>
                <span class="link_name">My Courses</span>
            </a>
        </li>
        
        <li class="<?= $current_page == 'course-catalog.php' ? 'active' : '' ?>">
            <a href="course-catalog.php">
                <i class='bx bx-book-open'></i>
                <span class="link_name">Course Catalog</span>
            </a>
        </li>
        

        
        <!-- Learning Resources -->
        <li class="<?= $current_page == 'library.php' ? 'active' : '' ?>">
            <a href="library.php">
                <i class='bx bx-library'></i>
                <span class="link_name">Library</span>
            </a>
        </li>
        
        <li class="<?= $current_page == 'referrals.php' ? 'active' : '' ?>">
            <a href="referrals.php">
                <i class='bx bx-share-alt'></i>
                <span class="link_name">Referrals</span>
            </a>
        </li>
        
        <!-- Account Settings -->
        <li class="<?= $current_page == 'profile.php' ? 'active' : '' ?>">
            <a href="profile.php">
                <i class='bx bx-user'></i>
                <span class="link_name">My Profile</span>
            </a>
        </li>
        
        <li class="<?= $current_page == 'settings.php' ? 'active' : '' ?>">
            <a href="settings.php">
                <i class='bx bx-cog'></i>
                <span class="link_name">Settings</span>
            </a>
        </li>
        
        <li class="<?= $current_page == 'help.php' ? 'active' : '' ?>">
            <a href="help.php">
                <i class='bx bx-help-circle'></i>
                <span class="link_name">Help & Support</span>
            </a>
        </li>
        
        <!-- Logout -->
        <li>
            <a href="/auth/logout.php">
                <i class='bx bx-log-out'></i>
                <span class="link_name">Logout</span>
            </a>
        </li>
    </ul>
</div>

<!-- Include Admin-Style CSS -->
<link rel="stylesheet" href="/assets/css/admin-dashboard.css">

<style>
/* Student Sidebar - Admin Style Design */
.sidebar {
    position: fixed;
    left: 0;
    top: 0;
    height: 100vh;
    width: 240px;
    background: #fff;
    z-index: 100;
    transition: all 0.5s ease;
    box-shadow: 0 5px 10px rgba(0,0,0,0.1);
}

.sidebar.close {
    width: 78px;
}

.sidebar .logo-details {
    height: 60px;
    display: flex;
    align-items: center;
    position: relative;
    padding: 0 14px;
    background: #4a90e2;
}

.sidebar .logo-details .logo-img {
    height: 35px;
    width: auto;
}

.sidebar .logo-details .logo-name {
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    opacity: 1;
    transition: all 0.5s ease;
    margin-left: 10px;
}

.sidebar.close .logo-details .logo-name {
    opacity: 0;
    pointer-events: none;
}

/* Close Button Styling */
.sidebar-close-btn {
    position: absolute;
    right: 14px;
    background: none;
    border: none;
    color: #fff;
    font-size: 20px;
    cursor: pointer;
    padding: 5px;
    border-radius: 4px;
    transition: all 0.3s ease;
    display: none; /* Hidden by default */
    opacity: 0;
    transform: scale(0.8);
}

.sidebar-close-btn:hover {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    transform: scale(1);
}

.sidebar-close-btn.show {
    display: block;
    opacity: 1;
    transform: scale(1);
}

/* Show close button only when sidebar is open on mobile */
@media (max-width: 768px) {
    .sidebar.open .sidebar-close-btn {
        display: block;
        opacity: 1;
        transform: scale(1);
    }
}

.sidebar .logo-details .sidebar-toggle {
    position: absolute;
    right: 14px;
    color: #fff;
    font-size: 22px;
    cursor: pointer;
    transition: all 0.4s ease;
}

.sidebar .logo-details .sidebar-toggle:hover {
    color: #1d39c4;
}

.sidebar .nav-links {
    margin-top: 10px;
    height: calc(100% - 60px);
    overflow: auto;
    scrollbar-width: none;
}

.sidebar .nav-links::-webkit-scrollbar {
    display: none;
}

.sidebar .nav-links li {
    position: relative;
    margin: 0 5px;
    list-style: none;
}

.sidebar .nav-links li a {
    display: flex;
    height: 100%;
    width: 100%;
    border-radius: 12px;
    align-items: center;
    text-decoration: none;
    transition: all 0.4s ease;
    background: #fff;
}

.sidebar .nav-links li a:hover {
    background: #4a90e2;
}

.sidebar .nav-links li a .link_name {
    color: #11101D;
    font-size: 15px;
    font-weight: 400;
    white-space: nowrap;
    opacity: 1;
    transition: all 0.4s ease;
}

.sidebar .nav-links li a:hover .link_name {
    color: #fff;
}

.sidebar.close .nav-links li a .link_name {
    opacity: 0;
    pointer-events: none;
}

.sidebar .nav-links li i {
    min-width: 50px;
    text-align: center;
    font-size: 18px;
    color: #696969;
    height: 50px;
    line-height: 50px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.sidebar .nav-links li a:hover i {
    color: #fff;
}

.sidebar .nav-links li.active a i,
.sidebar .nav-links li.active a .link_name {
    color: #4a90e2;
}

.sidebar .nav-links li.active a {
    background: rgba(74, 144, 226, 0.1);
}

.sidebar .nav-links li.active a:hover {
    background: #4a90e2;
}

.sidebar .nav-links li.active a:hover i,
.sidebar .nav-links li.active a:hover .link_name {
    color: #fff;
}

/* Content wrapper adjustments */
.content-wrapper {
    position: relative;
    background: #E4E9F7;
    min-height: 100vh;
    top: 0;
    left: 240px;
    width: calc(100% - 240px);
    transition: all 0.5s ease;
    z-index: 2;
}

.sidebar.close ~ .content-wrapper {
    left: 78px;
    width: calc(100% - 78px);
}

/* Responsive Design */
@media (max-width: 420px) {
    .sidebar li .tooltip {
        display: none;
    }
}

@media (max-width: 768px) {
    .sidebar {
        position: fixed;
        left: -240px;
        width: 240px;
        transform: none;
        z-index: 1050;
        transition: left 0.3s ease;
        box-shadow: 2px 0 10px rgba(0,0,0,0.1);
    }
    
    .sidebar.open {
        left: 0;
    }
    
    .content-wrapper {
        left: 0 !important;
        width: 100% !important;
        margin-left: 0 !important;
    }
    
    /* Overlay for mobile when sidebar is open */
    .sidebar-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1049;
    }
    
    .sidebar-overlay.show {
        display: block;
    }
}
</style>

<script>
// Enhanced sidebar functionality - Always open, closes only on navigation
document.addEventListener('DOMContentLoaded', function() {
    let sidebar = document.querySelector(".sidebar");
    let closeBtn = document.querySelector(".sidebar-toggle");
    let sidebarCloseBtn = document.getElementById("sidebar-close-btn");
    let searchBtn = document.querySelector(".bx-search");
    let navLinks = document.querySelectorAll(".nav-links li a");
    
    // Create overlay for mobile
    let overlay = document.createElement('div');
    overlay.className = 'sidebar-overlay';
    document.body.appendChild(overlay);
    
    // Function to check if we're on mobile
    function isMobile() {
        return window.innerWidth <= 768;
    }
    
    // Set initial sidebar state
    function setInitialSidebarState() {
        if (isMobile()) {
            // Mobile: sidebar starts hidden
            sidebar.classList.remove("close", "open");
            overlay.classList.remove("show");
        } else {
            // Desktop: sidebar starts collapsed (icons only)
            sidebar.classList.add("close");
            sidebar.classList.remove("open");
            overlay.classList.remove("show");
        }
    }
    
    // Set initial state
    setInitialSidebarState();
    
    // Toggle button functionality
    function toggleSidebar() {
        if (isMobile()) {
            // Mobile: toggle between hidden and fully open
            sidebar.classList.toggle("open");
            overlay.classList.toggle("show");
        } else {
            // Desktop: toggle between full and collapsed (icons)
            sidebar.classList.toggle("close");
        }
    }
    
    // Close sidebar when clicking overlay (mobile only)
    overlay.addEventListener('click', function() {
        if (isMobile()) {
            sidebar.classList.remove("open");
            overlay.classList.remove("show");
        }
    });
    
    // Close button functionality
    if (sidebarCloseBtn) {
        sidebarCloseBtn.addEventListener('click', function() {
            if (isMobile()) {
                // Mobile: close sidebar completely
                sidebar.classList.remove("open");
                overlay.classList.remove("show");
            } else {
                // Desktop: collapse to icons only
                sidebar.classList.add("close");
            }
        });
    }
    
    // Toggle button functionality (for manual control)
    if (closeBtn) {
        closeBtn.addEventListener("click", toggleSidebar);
    }
    
    if (searchBtn) {
        searchBtn.addEventListener("click", () => {
            if (isMobile()) {
                toggleSidebar();
            } else {
                sidebar.classList.toggle("close");
            }
        });
    }
    
    // Handle navigation clicks
    navLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            const href = this.getAttribute('href');
            if (href && !href.includes('logout.php')) {
                if (isMobile()) {
                    // Close sidebar on mobile after navigation
                    setTimeout(() => {
                        sidebar.classList.remove("open");
                        overlay.classList.remove("show");
                    }, 150);
                } else {
                    // Expand sidebar on desktop when navigation is clicked
                    sidebar.classList.remove("close");
                }
            }
        });
    });
    
    // Handle window resize
    window.addEventListener('resize', function() {
        // Reset sidebar to initial state on resize
        setInitialSidebarState();
    });
});
</script>
