<?php
// Session is started in header.php
require_once '../auth/functions.php';

// Require student role authentication - no exceptions
requireRole('student');

// Get user info
$userId = $_SESSION['user_id'] ?? null;
$firstName = $_SESSION['user_first_name'] ?? $_SESSION['first_name'] ?? '';
$lastName = $_SESSION['user_last_name'] ?? $_SESSION['last_name'] ?? '';
$email = $_SESSION['email'] ?? '';

if (!$userId) {
    // If no user ID, set error message and redirect to login
    $_SESSION['flash_message'] = 'User ID not found in session. Please login again.';
    $_SESSION['flash_type'] = 'danger';
    header('Location: ../auth/login.php');
    exit;
}

try {
    require_once '../config/db_connect.php';
    
    if ($conn) {
        // Check if student record exists
        if (tableExists($conn, 'students')) {
            $stmt = $conn->prepare("SELECT student_id FROM students WHERE user_id = ?");
            
            if ($stmt) {
                $stmt->bind_param("i", $userId);
                $stmt->execute();
                $checkResult = $stmt->get_result();
                
                if ($checkResult->num_rows == 0) {
                    // No record exists, create one
                    $stmt = $conn->prepare("
                        INSERT INTO students (user_id, first_name, last_name)
                        VALUES (?, ?, ?)
                    ");
                    
                    if ($stmt) {
                        $stmt->bind_param("iss", $userId, $firstName, $lastName);
                        $stmt->execute();
                        
                        // Set success message
                        $_SESSION['flash_message'] = 'Welcome! Your student account has been set up successfully.';
                        $_SESSION['flash_type'] = 'success';
                    } else {
                        error_log("Failed to prepare student record insertion: " . $conn->error);
                    }
                }
            } else {
                error_log("Failed to prepare student lookup statement: " . $conn->error);
            }
        } else {
            error_log("Students table does not exist");
        }
    } else {
        error_log("Database connection failed in create_student_record.php");
    }
} catch (Exception $e) {
    error_log("Exception in create_student_record.php: " . $e->getMessage());
}

// Always redirect to dashboard
header('Location: dashboard.php');
exit;
?>
