<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Certificate Page Debug</h1>";

// Test 1: Check session
echo "<h2>1. Session Check:</h2>";
session_start();
if (isset($_SESSION['user_id'])) {
    echo "✓ Session active - User ID: " . $_SESSION['user_id'] . "<br>";
} else {
    echo "✗ No session found<br>";
}

// Test 2: Check includes
echo "<h2>2. File Includes Check:</h2>";
$includes = [
    '../includes/session_start.php',
    '../auth/functions.php', 
    '../config/db_connect.php'
];

foreach ($includes as $file) {
    if (file_exists($file)) {
        echo "✓ File exists: $file<br>";
        try {
            require_once $file;
            echo "✓ Successfully included: $file<br>";
        } catch (Exception $e) {
            echo "✗ Error including $file: " . $e->getMessage() . "<br>";
        }
    } else {
        echo "✗ File missing: $file<br>";
    }
}

// Test 3: Database connection
echo "<h2>3. Database Connection:</h2>";
if (isset($conn) && $conn) {
    echo "✓ Database connected successfully<br>";
    
    // Test 4: Check tables
    echo "<h2>4. Database Tables Check:</h2>";
    $tables = ['courses', 'enrollments', 'certificates', 'users'];
    
    foreach ($tables as $table) {
        $result = $conn->query("SHOW TABLES LIKE '$table'");
        if ($result && $result->num_rows > 0) {
            echo "✓ Table '$table' exists<br>";
        } else {
            echo "✗ Table '$table' missing<br>";
        }
    }
    
    // Test 5: Check user's completed courses
    echo "<h2>5. User's Completed Courses:</h2>";
    if (isset($_SESSION['user_id'])) {
        $user_id = $_SESSION['user_id'];
        $stmt = $conn->prepare("
            SELECT c.course_id, c.title, e.enrolled_date
            FROM courses c
            JOIN enrollments e ON c.course_id = e.course_id
            WHERE e.student_id = ?
        ");
        
        if ($stmt) {
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                echo "Found " . $result->num_rows . " enrolled courses:<br>";
                while ($row = $result->fetch_assoc()) {
                    echo "- " . $row['title'] . " (ID: " . $row['course_id'] . ")<br>";
                }
            } else {
                echo "No enrolled courses found<br>";
            }
            $stmt->close();
        } else {
            echo "✗ Failed to prepare query<br>";
        }
    }
    
} else {
    echo "✗ Database connection failed<br>";
}

// Test 6: Try to load original certificates.php
echo "<h2>6. Original Certificate Page Load Test:</h2>";
echo "<p><a href='certificates.php' target='_blank'>Click here to test certificates.php</a></p>";

echo "<h2>Debug Complete</h2>";
?>
