<?php
// Start session if not already started
require_once '../includes/session_start.php';

// Include authentication functions
require_once '../auth/functions.php';

// Require student role to access this page
requireRole('student');

// Include database connection
require_once '../config/db_connect.php';

// Get student ID
$student_id = $_SESSION['user_id'];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Structure Debug - Panadite Academy</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .debug-section { background: white; padding: 20px; margin: 20px 0; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .debug-section h2 { color: #2563eb; border-bottom: 2px solid #2563eb; padding-bottom: 10px; }
        .success { color: #059669; font-weight: bold; }
        .error { color: #dc2626; font-weight: bold; }
        .warning { color: #d97706; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; font-weight: bold; }
        .highlight { background-color: #fef3c7; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 5px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>🔍 Database Structure & Enrollment Debug</h1>
    <p><strong>Current Student ID:</strong> <?= $student_id ?></p>
    
    <div class="debug-section">
        <h2>1. Enrollments Table Structure</h2>
        <?php
        $structure_query = "DESCRIBE enrollments";
        $result = $conn->query($structure_query);
        
        if ($result) {
            echo "<p class='success'>✅ Enrollments table structure:</p>";
            echo "<table>";
            echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
            while($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $row['Field'] . "</td>";
                echo "<td>" . $row['Type'] . "</td>";
                echo "<td>" . $row['Null'] . "</td>";
                echo "<td>" . $row['Key'] . "</td>";
                echo "<td>" . $row['Default'] . "</td>";
                echo "<td>" . $row['Extra'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p class='error'>❌ Failed to get table structure: " . $conn->error . "</p>";
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>2. All Enrollments in Database</h2>
        <?php
        $all_enrollments_query = "SELECT * FROM enrollments";
        $result = $conn->query($all_enrollments_query);
        
        if ($result) {
            echo "<p class='success'>✅ Found " . $result->num_rows . " total enrollment(s):</p>";
            if ($result->num_rows > 0) {
                echo "<table>";
                echo "<tr><th>Enrollment ID</th><th>Student ID</th><th>Course ID</th><th>Status</th><th>Other Columns</th></tr>";
                while($row = $result->fetch_assoc()) {
                    $highlight_class = ($row['student_id'] == $student_id) ? 'highlight' : '';
                    echo "<tr class='$highlight_class'>";
                    echo "<td>" . ($row['enrollment_id'] ?? 'N/A') . "</td>";
                    echo "<td>" . ($row['student_id'] ?? 'N/A') . "</td>";
                    echo "<td>" . ($row['course_id'] ?? 'N/A') . "</td>";
                    echo "<td>" . ($row['status'] ?? 'N/A') . "</td>";
                    echo "<td>";
                    foreach($row as $key => $value) {
                        if (!in_array($key, ['enrollment_id', 'student_id', 'course_id', 'status'])) {
                            echo "$key: $value<br>";
                        }
                    }
                    echo "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p class='error'>❌ No enrollments found in database!</p>";
            }
        } else {
            echo "<p class='error'>❌ Failed to query enrollments: " . $conn->error . "</p>";
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>3. All Courses Available</h2>
        <?php
        $courses_query = "SELECT course_id, title, description, teacher_id FROM courses ORDER BY course_id";
        $result = $conn->query($courses_query);
        
        if ($result) {
            echo "<p class='success'>✅ Found " . $result->num_rows . " course(s):</p>";
            echo "<table>";
            echo "<tr><th>Course ID</th><th>Course Title</th><th>Description</th><th>Teacher ID</th></tr>";
            while($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $row['course_id'] . "</td>";
                echo "<td>" . $row['title'] . "</td>";
                echo "<td>" . substr($row['description'], 0, 100) . "...</td>";
                echo "<td>" . $row['teacher_id'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p class='error'>❌ Failed to query courses: " . $conn->error . "</p>";
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>4. Student User Info</h2>
        <?php
        $user_query = "SELECT user_id, first_name, last_name, email, role FROM users WHERE user_id = $student_id";
        $result = $conn->query($user_query);
        
        if ($result && $result->num_rows > 0) {
            $user = $result->fetch_assoc();
            echo "<p class='success'>✅ Student information:</p>";
            echo "<table>";
            echo "<tr><th>Field</th><th>Value</th></tr>";
            foreach($user as $key => $value) {
                echo "<tr>";
                echo "<td>$key</td>";
                echo "<td>$value</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p class='error'>❌ Student user not found!</p>";
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>5. Fix Enrollment Issue</h2>
        <?php
        // Check if "Computer science" course exists
        $cs_course_query = "SELECT course_id, title FROM courses WHERE title LIKE '%Computer science%' OR title LIKE '%computer%'";
        $cs_result = $conn->query($cs_course_query);
        
        if ($cs_result && $cs_result->num_rows > 0) {
            $cs_course = $cs_result->fetch_assoc();
            echo "<p class='success'>✅ Found Computer Science course:</p>";
            echo "<p><strong>Course ID:</strong> " . $cs_course['course_id'] . "</p>";
            echo "<p><strong>Title:</strong> " . $cs_course['title'] . "</p>";
            
            // Check if student is enrolled in this course
            $enrollment_check = "SELECT * FROM enrollments WHERE student_id = $student_id AND course_id = " . $cs_course['course_id'];
            $enroll_result = $conn->query($enrollment_check);
            
            if ($enroll_result && $enroll_result->num_rows > 0) {
                echo "<p class='success'>✅ Student is enrolled in Computer Science!</p>";
            } else {
                echo "<p class='error'>❌ Student is NOT enrolled in Computer Science course!</p>";
                echo "<p class='warning'>⚠️ This explains why you see the course on UI but can't access quizzes.</p>";
                
                // Show enrollment fix option
                echo "<p><strong>To fix this, we need to enroll Student ID $student_id in Course ID " . $cs_course['course_id'] . "</strong></p>";
            }
        } else {
            echo "<p class='error'>❌ Computer Science course not found!</p>";
        }
        ?>
    </div>

    <p><a href="all_quizzes.php" style="background: #2563eb; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">← Back to Quiz Page</a></p>
</body>
</html>
