<?php
require_once '../config/db_connect.php';

$attempt_id = 1; // Your attempt ID from the URL
$student_id = 15; // Your student ID

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quiz Answer Debug - Panadite Academy</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .debug-section { background: white; padding: 20px; margin: 20px 0; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .debug-section h2 { color: #2563eb; border-bottom: 2px solid #2563eb; padding-bottom: 10px; }
        .success { color: #059669; font-weight: bold; }
        .error { color: #dc2626; font-weight: bold; }
        .warning { color: #d97706; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; font-weight: bold; }
        .highlight { background-color: #fef3c7; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 5px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>🔍 Quiz Answer Debug Analysis</h1>
    <p><strong>Attempt ID:</strong> <?= $attempt_id ?></p>
    <p><strong>Student ID:</strong> <?= $student_id ?></p>
    
    <div class="debug-section">
        <h2>1. Quiz Attempt Data</h2>
        <?php
        $attempt_query = "SELECT qa.*, q.title as quiz_title FROM quiz_attempts qa JOIN quizzes q ON qa.quiz_id = q.quiz_id WHERE qa.attempt_id = $attempt_id AND qa.student_id = $student_id";
        $attempt_result = $conn->query($attempt_query);
        
        if ($attempt_result && $attempt_result->num_rows > 0) {
            $attempt = $attempt_result->fetch_assoc();
            echo "<p class='success'>✅ Found attempt data:</p>";
            echo "<table>";
            foreach($attempt as $key => $value) {
                echo "<tr><td><strong>$key</strong></td><td>$value</td></tr>";
            }
            echo "</table>";
            $quiz_id = $attempt['quiz_id'];
        } else {
            echo "<p class='error'>❌ No attempt data found!</p>";
            $quiz_id = null;
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>2. Quiz Questions & Options</h2>
        <?php
        if ($quiz_id) {
            $questions_query = "SELECT qq.*, qo.option_id, qo.option_text, qo.is_correct 
                               FROM quiz_questions qq 
                               LEFT JOIN quiz_question_options qo ON qq.question_id = qo.question_id 
                               WHERE qq.quiz_id = $quiz_id 
                               ORDER BY qq.question_id, qo.option_id";
            $questions_result = $conn->query($questions_query);
            
            if ($questions_result && $questions_result->num_rows > 0) {
                echo "<p class='success'>✅ Quiz questions and options:</p>";
                echo "<table>";
                echo "<tr><th>Question ID</th><th>Question Text</th><th>Type</th><th>Points</th><th>Option ID</th><th>Option Text</th><th>Is Correct</th></tr>";
                
                while($row = $questions_result->fetch_assoc()) {
                    $correct_class = $row['is_correct'] ? 'highlight' : '';
                    echo "<tr class='$correct_class'>";
                    echo "<td>" . $row['question_id'] . "</td>";
                    echo "<td>" . $row['question_text'] . "</td>";
                    echo "<td>" . $row['question_type'] . "</td>";
                    echo "<td>" . $row['points'] . "</td>";
                    echo "<td>" . $row['option_id'] . "</td>";
                    echo "<td>" . $row['option_text'] . "</td>";
                    echo "<td>" . ($row['is_correct'] ? '✅ YES' : '❌ No') . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p class='error'>❌ No questions found for this quiz!</p>";
            }
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>3. Student's Submitted Responses</h2>
        <?php
        $responses_query = "SELECT * FROM quiz_responses WHERE attempt_id = $attempt_id ORDER BY question_id";
        $responses_result = $conn->query($responses_query);
        
        if ($responses_result && $responses_result->num_rows > 0) {
            echo "<p class='success'>✅ Found " . $responses_result->num_rows . " response(s):</p>";
            echo "<table>";
            echo "<tr><th>Response ID</th><th>Question ID</th><th>Answer ID</th><th>Text Response</th><th>Is Correct</th><th>Points Earned</th></tr>";
            
            while($response = $responses_result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $response['response_id'] . "</td>";
                echo "<td>" . $response['question_id'] . "</td>";
                echo "<td>" . $response['answer_id'] . "</td>";
                echo "<td>" . $response['text_response'] . "</td>";
                echo "<td>" . ($response['is_correct'] ? '✅ Correct' : '❌ Incorrect') . "</td>";
                echo "<td>" . $response['points_earned'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p class='error'>❌ No responses found for this attempt!</p>";
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>4. Answer Mapping Analysis</h2>
        <?php
        if ($quiz_id) {
            echo "<p><strong>For each question, let's see what should be displayed:</strong></p>";
            
            // Get questions for this quiz
            $questions_query = "SELECT * FROM quiz_questions WHERE quiz_id = $quiz_id ORDER BY question_id";
            $questions_result = $conn->query($questions_query);
            
            while($question = $questions_result->fetch_assoc()) {
                $question_id = $question['question_id'];
                echo "<h3>Question " . $question_id . ": " . $question['question_text'] . "</h3>";
                
                // Get student's response
                $response_query = "SELECT * FROM quiz_responses WHERE attempt_id = $attempt_id AND question_id = $question_id";
                $response_result = $conn->query($response_query);
                $response = $response_result->fetch_assoc();
                
                echo "<p><strong>Student's Response:</strong></p>";
                if ($response) {
                    echo "<ul>";
                    echo "<li><strong>Answer ID:</strong> " . $response['answer_id'] . "</li>";
                    echo "<li><strong>Text Response:</strong> " . $response['text_response'] . "</li>";
                    echo "<li><strong>Is Correct:</strong> " . ($response['is_correct'] ? 'Yes' : 'No') . "</li>";
                    echo "<li><strong>Points Earned:</strong> " . $response['points_earned'] . "</li>";
                    echo "</ul>";
                } else {
                    echo "<p class='warning'>No response recorded</p>";
                }
                
                // Get correct answer(s)
                $correct_query = "SELECT * FROM quiz_question_options WHERE question_id = $question_id AND is_correct = 1";
                $correct_result = $conn->query($correct_query);
                
                echo "<p><strong>Correct Answer(s):</strong></p>";
                if ($correct_result && $correct_result->num_rows > 0) {
                    echo "<ul>";
                    while($correct = $correct_result->fetch_assoc()) {
                        echo "<li><strong>Option ID:</strong> " . $correct['option_id'] . " - <strong>Text:</strong> " . $correct['option_text'] . "</li>";
                    }
                    echo "</ul>";
                } else {
                    echo "<p class='error'>❌ No correct answers found!</p>";
                }
                
                // Get student's selected answer text
                if ($response && $response['answer_id']) {
                    $selected_query = "SELECT option_text FROM quiz_question_options WHERE option_id = " . $response['answer_id'];
                    $selected_result = $conn->query($selected_query);
                    $selected = $selected_result->fetch_assoc();
                    echo "<p><strong>Student Selected:</strong> " . ($selected ? $selected['option_text'] : 'Option not found') . "</p>";
                }
                
                echo "<hr>";
            }
        }
        ?>
    </div>

    <div class="debug-section">
        <h2>5. Quiz Results Display Issues</h2>
        <?php
        echo "<h3>Problems Identified:</h3>";
        echo "<ul>";
        echo "<li><strong>Score 0/0:</strong> Points calculation issue - check if question points are set</li>";
        echo "<li><strong>Date 1970:</strong> Timestamp format issue in attempt date</li>";
        echo "<li><strong>Missing correct answers:</strong> Quiz results page not properly fetching correct options</li>";
        echo "</ul>";
        
        echo "<h3>Score Calculation Debug:</h3>";
        if ($quiz_id) {
            $total_points_query = "SELECT SUM(points) as total_points FROM quiz_questions WHERE quiz_id = $quiz_id";
            $total_points_result = $conn->query($total_points_query);
            $total_points = $total_points_result->fetch_assoc()['total_points'];
            
            $earned_points_query = "SELECT SUM(points_earned) as earned_points FROM quiz_responses WHERE attempt_id = $attempt_id";
            $earned_points_result = $conn->query($earned_points_query);
            $earned_points = $earned_points_result->fetch_assoc()['earned_points'];
            
            echo "<p><strong>Total Possible Points:</strong> $total_points</p>";
            echo "<p><strong>Points Earned:</strong> $earned_points</p>";
            echo "<p><strong>Percentage:</strong> " . ($total_points > 0 ? round(($earned_points / $total_points) * 100, 2) : 0) . "%</p>";
        }
        ?>
    </div>

    <p><a href="quiz_results.php?attempt_id=<?= $attempt_id ?>" style="background: #2563eb; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">← Back to Quiz Results</a></p>
</body>
</html>
