<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 Quiz Debug Script</h1>";

try {
    require_once '../includes/session_start.php';
    require_once '../auth/functions.php';
    requireRole('student');
    require_once '../config/db_connect.php';
    
    $user_id = $_SESSION['user_id'] ?? 'NOT_SET';
    $course_id = 1;
    
    echo "<p><strong>User ID:</strong> $user_id</p>";
    echo "<p><strong>Course ID:</strong> $course_id</p>";
    echo "<hr>";

    // 1. Show total attempts in database first
    echo "<h2>📊 Total Quiz Attempts in Database</h2>";
    $total_query = "SELECT COUNT(*) as total FROM quiz_attempts";
    if ($result = $conn->query($total_query)) {
        $row = $result->fetch_assoc();
        echo "<p><strong>Total attempts in database:</strong> {$row['total']}</p>";
    }

    // Show attempts for your user specifically
    echo "<h2>🎯 Your Quiz Attempts (User ID: $user_id)</h2>";
    $attempts_query = "SELECT * FROM quiz_attempts WHERE student_id = ? ORDER BY created_at DESC";
    if ($stmt = $conn->prepare($attempts_query)) {
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        echo "<table border='1' style='border-collapse:collapse; width:100%;'>";
        echo "<tr><th>Attempt ID</th><th>Quiz ID</th><th>Score</th><th>Pass Status</th><th>Passed</th><th>Created At</th></tr>";
        $attempts_found = false;
        while ($row = $result->fetch_assoc()) {
            $attempts_found = true;
            echo "<tr>";
            echo "<td>{$row['attempt_id']}</td>";
            echo "<td>{$row['quiz_id']}</td>";
            echo "<td>{$row['score']}%</td>";
            echo "<td>" . ($row['pass_status'] ?? 'NULL') . "</td>";
            echo "<td>" . ($row['passed'] ?? 'NULL') . "</td>";
            echo "<td>{$row['created_at']}</td>";
            echo "</tr>";
        }
        if (!$attempts_found) {
            echo "<tr><td colspan='6' style='color:red; text-align:center;'>❌ NO ATTEMPTS FOUND FOR USER $user_id</td></tr>";
        }
        echo "</table>";
        $stmt->close();
    }

    // 2. Show all quizzes with video_id mapping
    echo "<h2>📝 All Quizzes</h2>";
    $quiz_query = "SELECT quiz_id, title, video_id, is_published FROM quizzes ORDER BY quiz_id";
    if ($stmt = $conn->prepare($quiz_query)) {
        $stmt->execute();
        $result = $stmt->get_result();
        echo "<table border='1' style='border-collapse:collapse; width:100%;'>";
        echo "<tr><th>Quiz ID</th><th>Title</th><th>Video ID</th><th>Published</th></tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>{$row['quiz_id']}</td>";
            echo "<td>{$row['title']}</td>";
            echo "<td>{$row['video_id']}</td>";
            echo "<td>" . ($row['is_published'] ? 'YES' : 'NO') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        $stmt->close();
    }

    // 3. Test ALL "Web development HTML" quizzes
    echo "<h2>🎯 Test ALL 'Web development HTML' Quizzes</h2>";
    $find_quizzes = "SELECT quiz_id, title, video_id FROM quizzes WHERE title LIKE '%Web development HTML%' ORDER BY quiz_id";
    if ($stmt = $conn->prepare($find_quizzes)) {
        $stmt->execute();
        $result = $stmt->get_result();
        
        while ($quiz = $result->fetch_assoc()) {
            $target_quiz_id = $quiz['quiz_id'];
            echo "<h3>Quiz: {$quiz['title']} (ID: $target_quiz_id, Video ID: {$quiz['video_id']})</h3>";
            echo "<p>🔍 Searching attempts for quiz_id=$target_quiz_id, user_id=$user_id</p>";
            
            // Test direct attempt query with both field names
            $direct_attempt = "SELECT attempt_id, score, pass_status, passed, start_time, end_time, created_at FROM quiz_attempts WHERE quiz_id = ? AND student_id = ?";
            if ($stmt2 = $conn->prepare($direct_attempt)) {
                echo "<p>✅ Query prepared successfully</p>";
                $stmt2->bind_param("ii", $target_quiz_id, $user_id);
                echo "<p>✅ Parameters bound: quiz_id=$target_quiz_id, user_id=$user_id</p>";
                $stmt2->execute();
                echo "<p>✅ Query executed</p>";
                $result2 = $stmt2->get_result();
                echo "<p>✅ Result obtained</p>";
                
                if ($attempt = $result2->fetch_assoc()) {
                    echo "<p>✅ Attempt data fetched</p>";
                    echo "<div style='background:green; color:white; padding:10px; margin:10px 0;'>";
                    echo "✅ ATTEMPT FOUND!<br>";
                    echo "Attempt ID: {$attempt['attempt_id']}<br>";
                    echo "Score: {$attempt['score']}%<br>";
                    echo "Pass Status: " . ($attempt['pass_status'] ?? 'NULL') . "<br>";
                    echo "Passed Field: " . ($attempt['passed'] ?? 'NULL') . "<br>";
                    echo "Created: {$attempt['created_at']}<br>";
                    echo "Start: {$attempt['start_time']}<br>";
                    echo "End: {$attempt['end_time']}<br>";
                    echo "</div>";
                } else {
                    echo "<div style='background:red; color:white; padding:10px; margin:10px 0;'>";
                    echo "❌ NO ATTEMPT FOUND for quiz_id=$target_quiz_id, user_id=$user_id";
                    echo "</div>";
                }
                $stmt2->close();
            }
        }
        $stmt->close();
    }

} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>
