<!DOCTYPE html>
<html>
<head>
    <title>Debug Accreditation API</title>
    <style>
        body{font-family:Arial;max-width:1000px;margin:20px auto;padding:20px;background:#f8f9fa;}
        .container{background:white;padding:30px;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,0.1);}
        .success{color:#28a745;background:#d4edda;padding:15px;border-radius:5px;margin:15px 0;}
        .error{color:#dc3545;background:#f8d7da;padding:15px;border-radius:5px;margin:15px 0;}
        .debug-item{background:#f8f9fa;padding:10px;margin:5px 0;border-left:3px solid #007bff;font-family:monospace;}
        .btn{padding:12px 24px;background:#007bff;color:white;border:none;border-radius:5px;cursor:pointer;margin:10px 5px;}
        .btn:hover{background:#0056b3;}
        pre{background:#f8f9fa;padding:15px;border-radius:5px;overflow:auto;max-height:400px;}
        h1{color:#343a40;border-bottom:3px solid #007bff;padding-bottom:10px;}
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Debug Accreditation Payment API</h1>
        
        <div id="debugForm">
            <p>Test the accreditation API to identify the JSON parsing error:</p>
            
            <form id="testForm">
                <input type="hidden" name="course_id" value="<?= $_GET['course_id'] ?? '1' ?>">
                <input type="hidden" name="student_id" value="<?= $_GET['student_id'] ?? '1' ?>">
                <input type="hidden" name="motivation" value="Debug test for SITA accreditation">
                
                <div style="margin:20px 0;">
                    <label>Course ID: <input type="number" name="course_id" value="<?= $_GET['course_id'] ?? '1' ?>" style="padding:8px;margin-left:10px;"></label><br><br>
                    <label>Student ID: <input type="number" name="student_id" value="<?= $_GET['student_id'] ?? '1' ?>" style="padding:8px;margin-left:10px;"></label>
                </div>
                
                <button type="submit" class="btn">🔍 Run Debug Test</button>
            </form>
        </div>
        
        <div id="results" style="margin-top:30px;"></div>
    </div>

    <script>
    document.getElementById('testForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const resultsDiv = document.getElementById('results');
        
        resultsDiv.innerHTML = '<div style="color:#666;">🔄 Testing API...</div>';
        
        fetch('api/debug_accreditation.php', {
            method: 'POST',
            body: formData
        })
        .then(response => {
            console.log('Response status:', response.status);
            console.log('Response headers:', response.headers);
            return response.text(); // Get as text first to see what we're receiving
        })
        .then(text => {
            console.log('Raw response:', text);
            
            try {
                const data = JSON.parse(text);
                displayResults(data);
            } catch (error) {
                // JSON parse failed - show the raw response
                resultsDiv.innerHTML = `
                    <div class="error">
                        <h3>❌ JSON Parse Error (This is the problem!)</h3>
                        <p><strong>Error:</strong> ${error.message}</p>
                        <h4>Raw Response Received:</h4>
                        <pre>${text}</pre>
                    </div>
                `;
            }
        })
        .catch(error => {
            resultsDiv.innerHTML = `<div class="error"><h3>❌ Network Error</h3><p>${error.message}</p></div>`;
        });
    });
    
    function displayResults(data) {
        const resultsDiv = document.getElementById('results');
        let html = '';
        
        if (data.success) {
            html += '<div class="success"><h3>✅ Debug Test Successful!</h3><p>' + data.message + '</p></div>';
        } else {
            html += '<div class="error"><h3>❌ Debug Test Failed</h3><p>' + data.message + '</p></div>';
        }
        
        if (data.debug && data.debug.length > 0) {
            html += '<h3>🔍 Debug Information:</h3>';
            data.debug.forEach(item => {
                html += '<div class="debug-item">' + item + '</div>';
            });
        }
        
        html += '<h3>📄 Full Response:</h3><pre>' + JSON.stringify(data, null, 2) + '</pre>';
        
        resultsDiv.innerHTML = html;
    }
    </script>
</body>
</html>
