<?php
// Start session if not already started
require_once '../includes/session_start.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include database connection
require_once '../config/db_connect.php';

// Explicitly set student session variables
if (!isset($_SESSION['user_id'])) {
    // If session is not set, get student ID from database or use a default
    $studentQuery = "SELECT user_id FROM users WHERE role = 'student' LIMIT 1";
    $studentResult = $conn->query($studentQuery);
    if ($studentResult && $studentResult->num_rows > 0) {
        $student = $studentResult->fetch_assoc();
        $_SESSION['user_id'] = $student['user_id'];
    } else {
        // Default student ID if none found
        $_SESSION['user_id'] = 1;
    }
}

// Set necessary session variables
$_SESSION['role'] = 'student';
$_SESSION['logged_in'] = true;

// Get quiz ID from URL or use default
$quiz_id = isset($_GET['id']) ? intval($_GET['id']) : 1;

// Check if user wants to force all validations to pass
$bypassChecks = isset($_GET['bypass']) && $_GET['bypass'] == 1;

// Generate quiz URL
$quizUrl = "quiz_start.php?id={$quiz_id}" . ($bypassChecks ? "&bypass=1" : "");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Direct Quiz Access</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h3>Direct Quiz Access Helper</h3>
            </div>
            <div class="card-body">
                <h4 class="mb-3">Session Information</h4>
                <div class="alert alert-info">
                    <strong>Session ID:</strong> <?= session_id() ?><br>
                    <strong>User ID in Session:</strong> <?= $_SESSION['user_id'] ?><br>
                    <strong>Role in Session:</strong> <?= $_SESSION['role'] ?><br>
                </div>
                
                <h4 class="mb-3">Try Quiz Access Methods</h4>
                <div class="d-grid gap-3">
                    <a href="<?= $quizUrl ?>" class="btn btn-primary">Method 1: Direct Link</a>
                    <button onclick="redirectWithMeta('<?= $quizUrl ?>')" class="btn btn-success">Method 2: JS Redirect</button>
                    <button onclick="openPopupWindow('<?= $quizUrl ?>')" class="btn btn-warning">Method 3: Popup Window</button>
                    <button onclick="fetchAndDisplay('<?= $quizUrl ?>')" class="btn btn-info">Method 4: AJAX Load (No Redirect)</button>
                </div>
                
                <div class="mt-4" id="result-container"></div>
                
                <hr>
                
                <h4 class="mb-3">Fix Session Issues</h4>
                <form action="fix_session.php" method="post" class="mb-3">
                    <input type="hidden" name="quiz_id" value="<?= $quiz_id ?>">
                    <div class="mb-3">
                        <label for="userId" class="form-label">Set User ID:</label>
                        <input type="number" class="form-control" id="userId" name="user_id" value="<?= $_SESSION['user_id'] ?>">
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" class="form-check-input" id="bypassChecks" name="bypass_checks" value="1">
                        <label class="form-check-label" for="bypassChecks">
                            Bypass all checks (use with caution)
                        </label>
                    </div>
                    <button type="submit" class="btn btn-danger">Reset & Fix Session</button>
                </form>
                
                <div class="mt-4">
                    <a href="course-quizzes.php?id=2" class="btn btn-secondary">Return to Course Quizzes</a>
                </div>
            </div>
        </div>
    </div>
    
    <script>
    // Method 2: JavaScript redirect with meta refresh
    function redirectWithMeta(url) {
        document.head.innerHTML += '<meta http-equiv="refresh" content="0;URL=\'' + url + '\'">';
    }
    
    // Method 3: Open in popup window
    function openPopupWindow(url) {
        window.open(url, 'quizWindow', 'width=1000,height=800,scrollbars=yes');
    }
    
    // Method 4: AJAX load without redirect
    function fetchAndDisplay(url) {
        const resultContainer = document.getElementById('result-container');
        resultContainer.innerHTML = '<div class="alert alert-secondary">Loading content...</div>';
        
        fetch(url)
            .then(response => response.text())
            .then(html => {
                resultContainer.innerHTML = `
                    <div class="card">
                        <div class="card-header">Quiz Content (AJAX Loaded)</div>
                        <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                            ${html}
                        </div>
                    </div>`;
            })
            .catch(error => {
                resultContainer.innerHTML = `<div class="alert alert-danger">Error: ${error.message}</div>`;
            });
    }
    </script>
</body>
</html>
