<?php
// Session is started in header.php
require_once '../auth/functions.php';

// Require student role authentication - no exceptions
requireRole('student');

// Check if download ID is provided
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    // Redirect to downloads page if no valid download ID provided
    header('Location: downloads.php');
    exit;
}

$downloadId = (int)$_GET['id'];
$filePath = '';
$fileName = '';
$downloadTitle = '';

// Get the download information from the database
require_once '../config/db_connect.php';

if ($conn) {
    $query = "SELECT download_id, title, file_path, file_type FROM downloads WHERE download_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $downloadId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $download = $result->fetch_assoc();
        $filePath = $download['file_path'];
        $downloadTitle = $download['title'];
        
        // Generate a clean filename
        $fileExt = strtolower($download['file_type']);
        $fileName = str_replace(' ', '_', strtolower($downloadTitle)) . '.' . strtolower($fileExt);
        
        // Increment the download counter
        $updateQuery = "UPDATE downloads SET download_count = download_count + 1 WHERE download_id = ?";
        $updateStmt = $conn->prepare($updateQuery);
        $updateStmt->bind_param("i", $downloadId);
        $updateStmt->execute();
        
        // Since there's no actual file yet (database is empty), just redirect back to downloads page
        // In a real implementation, we would serve the actual file here
        header('Location: downloads.php?download=success&id=' . $downloadId);
        exit;
        
    } else {
        // Download not found in database
        header('Location: downloads.php?error=download_not_found');
        exit;
    }
} else {
    // Database connection error
    header('Location: downloads.php?error=db_error');
    exit;
}

// If we get here, something went wrong
header('Location: downloads.php');
exit;
?>
