<?php
// Start session if not already started
require_once '../includes/session_start.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include database connection
require_once '../config/db_connect.php';

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Clear the current session
    session_unset();
    
    // Set the user ID from the form
    if (isset($_POST['user_id']) && !empty($_POST['user_id'])) {
        $_SESSION['user_id'] = intval($_POST['user_id']);
    } else {
        // Default to user ID 1 if none provided
        $_SESSION['user_id'] = 1;
    }
    
    // Set required session variables
    $_SESSION['role'] = 'student';
    $_SESSION['logged_in'] = true;
    
    // Check if we should bypass validation checks
    if (isset($_POST['bypass_checks']) && $_POST['bypass_checks'] == 1) {
        $_SESSION['bypass_quiz_checks'] = true;
    }
    
    // Store the user ID in a cookie as well (as backup)
    setcookie('user_id', $_SESSION['user_id'], time() + 3600, '/');
    
    // Get the quiz ID to redirect back to
    $quiz_id = isset($_POST['quiz_id']) ? intval($_POST['quiz_id']) : 1;
    
    // Set a success message
    $_SESSION['success'] = "Session has been reset and fixed with User ID: {$_SESSION['user_id']}";
    
    // Redirect back to the direct access page
    header("Location: direct_quiz_access.php?id={$quiz_id}");
    exit();
}
?>
