<?php
require_once '../includes/session_start.php';
require_once '../auth/functions.php';
requireRole('student');
require_once '../includes/id_encryption.php';

header('Content-Type: application/json');

$encrypted_id = $_GET['id'] ?? '';
$user_id = $_SESSION['user_id'] ?? null;

$response = [];

if ($encrypted_id) {
    try {
        $decrypted_course_id = IdEncryption::decrypt($encrypted_id);
        $response['encrypted_id'] = $encrypted_id;
        $response['decrypted_course_id'] = $decrypted_course_id;
        $response['user_id'] = $user_id;
        $response['success'] = true;
    } catch (Exception $e) {
        $response['error'] = 'Failed to decrypt course ID: ' . $e->getMessage();
        $response['success'] = false;
    }
} else {
    $response['error'] = 'No course ID provided';
    $response['success'] = false;
}

echo json_encode($response);
?>
