// Student Courses Page JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Course filtering functionality
    const filterButtons = document.querySelectorAll('.course-filters .btn');
    const courseCards = document.querySelectorAll('.enrolled-courses .course-card');
    
    // Initialize Intersection Observer for animations
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('show');
            }
        });
    }, { threshold: 0.1 });
    
    // Observe all cards for animation
    document.querySelectorAll('.course-card, .stat-card').forEach(card => {
        observer.observe(card);
    });
    
    // Handle course filtering
    filterButtons.forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all buttons
            filterButtons.forEach(btn => btn.classList.remove('active'));
            
            // Add active class to clicked button
            this.classList.add('active');
            
            // Get filter value
            const filter = this.getAttribute('data-filter');
            
            // Filter courses
            courseCards.forEach(card => {
                const status = card.querySelector('.badge').textContent.trim().toLowerCase().replace(' ', '_');
                
                if (filter === 'all' || status === filter) {
                    card.closest('.col-lg-4').style.display = 'block';
                } else {
                    card.closest('.col-lg-4').style.display = 'none';
                }
            });
        });
    });
    
    // Add hover effects
    document.querySelectorAll('.course-card').forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.classList.add('hover');
        });
        
        card.addEventListener('mouseleave', function() {
            this.classList.remove('hover');
        });
    });
});
