<?php
require_once '../config/db_connect.php';

echo "<h2>🚀 Publishing Quiz Fix</h2>";

// Find the unpublished quiz in Computer science course
$find_quiz = "SELECT quiz_id, title, course_id, is_published FROM quizzes WHERE course_id = 12 AND title = 'My name'";
$result = $conn->query($find_quiz);

if ($result && $result->num_rows > 0) {
    $quiz = $result->fetch_assoc();
    echo "<p>✅ Found quiz:</p>";
    echo "<ul>";
    echo "<li><strong>Quiz ID:</strong> " . $quiz['quiz_id'] . "</li>";
    echo "<li><strong>Title:</strong> " . $quiz['title'] . "</li>";
    echo "<li><strong>Course ID:</strong> " . $quiz['course_id'] . "</li>";
    echo "<li><strong>Currently Published:</strong> " . ($quiz['is_published'] ? 'Yes' : 'No') . "</li>";
    echo "</ul>";
    
    if (!$quiz['is_published']) {
        // Publish the quiz
        $publish_query = "UPDATE quizzes SET is_published = 1 WHERE quiz_id = " . $quiz['quiz_id'];
        
        if ($conn->query($publish_query)) {
            echo "<p style='color: green; font-size: 18px; font-weight: bold;'>🎉 SUCCESS! Quiz 'My name' has been PUBLISHED!</p>";
            echo "<p>✅ Quiz ID " . $quiz['quiz_id'] . " is now published and visible to students.</p>";
            
            // Verify the change
            $verify_query = "SELECT is_published FROM quizzes WHERE quiz_id = " . $quiz['quiz_id'];
            $verify_result = $conn->query($verify_query);
            $verify = $verify_result->fetch_assoc();
            
            if ($verify['is_published'] == 1) {
                echo "<p style='color: green;'>✅ <strong>VERIFIED:</strong> Quiz is now published!</p>";
            } else {
                echo "<p style='color: red;'>❌ Verification failed - quiz may not be published.</p>";
            }
        } else {
            echo "<p style='color: red;'>❌ Failed to publish quiz: " . $conn->error . "</p>";
        }
    } else {
        echo "<p style='color: blue;'>ℹ️ Quiz is already published!</p>";
    }
} else {
    echo "<p style='color: red;'>❌ Quiz 'My name' not found in Computer science course.</p>";
}

// Test the quiz query again
echo "<hr>";
echo "<h3>🧪 Testing Quiz Visibility After Publishing</h3>";

$student_id = 15;
$test_query = "
    SELECT q.quiz_id, q.title, q.course_id, c.title as course_title, q.is_published
    FROM quizzes q
    JOIN courses c ON q.course_id = c.course_id
    JOIN users u ON c.teacher_id = u.user_id
    JOIN enrollments e ON c.course_id = e.course_id AND e.student_id = $student_id
    WHERE q.is_published = 1
    ORDER BY q.created_at DESC
";

$test_result = $conn->query($test_query);

echo "<p><strong>Quizzes visible to Student ID $student_id:</strong> " . $test_result->num_rows . " quiz(es)</p>";

if ($test_result && $test_result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #d4edda;'>";
    echo "<th>Quiz ID</th><th>Quiz Title</th><th>Course</th><th>Published</th>";
    echo "</tr>";
    
    while($quiz = $test_result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $quiz['quiz_id'] . "</td>";
        echo "<td>" . $quiz['title'] . "</td>";
        echo "<td>" . $quiz['course_title'] . " (ID: " . $quiz['course_id'] . ")</td>";
        echo "<td>✅ Yes</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<p style='color: green; font-size: 16px; font-weight: bold;'>🎉 SUCCESS! Student can now see quiz(es) on the quiz page!</p>";
} else {
    echo "<p style='color: orange;'>⚠️ Still no quizzes visible. There may be another issue.</p>";
}

echo "<hr>";
echo "<h3>🎯 Next Steps:</h3>";
echo "<ol>";
echo "<li><strong>Go to the Quiz Page:</strong> <a href='all_quizzes.php' style='background: #007bff; color: white; padding: 8px 16px; text-decoration: none; border-radius: 4px;'>View Quiz Page</a></li>";
echo "<li><strong>Refresh the page</strong> to see the published quiz</li>";
echo "<li><strong>Click 'Take Quiz'</strong> to start the quiz</li>";
echo "</ol>";

echo "<p style='margin-top: 30px;'>";
echo "<a href='all_quizzes.php' style='background: #28a745; color: white; padding: 12px 24px; text-decoration: none; border-radius: 6px; font-size: 16px;'>🚀 Go to Quiz Page Now!</a>";
echo "</p>";
?>
