<?php
// Start session if not already started
require_once '../includes/session_start.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include authentication functions
require_once '../auth/functions.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Session Debug</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h3>Session Debug Information</h3>
            </div>
            <div class="card-body">
                <h4>Session Status</h4>
                <ul>
                    <li>PHP Session ID: <?= session_id() ?></li>
                    <li>Session Status: <?= session_status() == PHP_SESSION_ACTIVE ? 'Active' : 'Not Active' ?></li>
                    <li>Session Save Path: <?= session_save_path() ?></li>
                </ul>

                <h4>Session Variables</h4>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Variable</th>
                            <th>Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($_SESSION as $key => $value): ?>
                        <tr>
                            <td><?= htmlspecialchars($key) ?></td>
                            <td>
                                <?php 
                                if (is_array($value)) {
                                    echo '<pre>' . htmlspecialchars(print_r($value, true)) . '</pre>';
                                } else {
                                    echo htmlspecialchars($value);
                                }
                                ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($_SESSION)): ?>
                        <tr>
                            <td colspan="2" class="text-center">No session variables found</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                <h4>Authentication Status</h4>
                <ul>
                    <li>Is Logged In: <?= isLoggedIn() ? 'Yes' : 'No' ?></li>
                    <?php if (isLoggedIn()): ?>
                    <li>User ID: <?= $_SESSION['user_id'] ?? 'Not set' ?></li>
                    <li>Username: <?= $_SESSION['username'] ?? 'Not set' ?></li>
                    <li>User Role: <?= $_SESSION['role'] ?? 'Not set' ?></li>
                    <li>Has Student Permission: <?= hasPermission('student') ? 'Yes' : 'No' ?></li>
                    <?php endif; ?>
                </ul>

                <div class="mt-4">
                    <a href="course-quizzes.php?id=2" class="btn btn-primary">Return to Course Quizzes</a>
                    <a href="quiz_start.php?id=1" class="btn btn-success ms-2">Try Access Quiz</a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
