<?php
session_start();
require_once '../includes/config.php';

// Check if user is logged in and is a student
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'student') {
    header('Location: ../login.php');
    exit();
}

echo "SUCCESS: Page loaded without redirect!<br>";
echo "User ID: " . $_SESSION['user_id'] . "<br>";
echo "User Role: " . $_SESSION['user_role'] . "<br>";

// Test database connection
if ($conn) {
    echo "Database connection: SUCCESS<br>";
    
    // Test query
    $result = $conn->query("SELECT COUNT(*) as count FROM courses WHERE is_published = 1");
    if ($result) {
        $row = $result->fetch_assoc();
        echo "Published courses found: " . $row['count'] . "<br>";
    }
} else {
    echo "Database connection: FAILED<br>";
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Test Catalog</title>
</head>
<body>
    <h1>Test Course Catalog Page</h1>
    <p>If you can see this, the basic page structure works!</p>
    <a href="dashboard.php">Back to Dashboard</a>
</body>
</html>
