<?php
/**
 * Test Certificate - Simple PDF Generation
 * For testing the certificate design and PDF functionality
 */

session_start();

// Simple authentication check - more flexible
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Debug session info (remove in production)
// echo "<!-- Session Debug: " . print_r($_SESSION, true) . " -->";

$student_id = $_SESSION['user_id'];
$student_name = isset($_SESSION['first_name']) && isset($_SESSION['last_name']) ? 
    $_SESSION['first_name'] . ' ' . $_SESSION['last_name'] : 'Student Name';
$course_title = "Computer Science";
$instructor_name = "Course Instructor";
$certificate_id = 'PA-TEST-' . $student_id . '-' . date('Y');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Certificate - <?= htmlspecialchars($student_name) ?></title>
    <style>
        /* Print-specific styles */
        @page {
            size: A4 landscape;
            margin: 0;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
                print-color-adjust: exact !important;
                margin: 0 !important;
                padding: 0 !important;
                background: white !important;
            }
            
            .no-print {
                display: none !important;
            }
            
            .certificate-container {
                width: 100% !important;
                height: 100vh !important;
                max-width: none !important;
                margin: 0 !important;
                border-radius: 0 !important;
                box-shadow: none !important;
                border: none !important;
                page-break-inside: avoid !important;
            }
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: "Inter", "Segoe UI", Roboto, sans-serif;
            background: #f8fafc;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        
        @media print {
            body {
                padding: 0;
                min-height: 100vh;
                display: block;
            }
        }
        
        /* Certificate Container - Exact Match */
        .certificate-container {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
            margin: 0 auto;
            max-width: 800px;
            width: 100%;
            height: auto;
            overflow: hidden;
            border: 2px solid #E5E7EB;
            position: relative;
        }

        .certificate-container::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 15% 85%, rgba(79, 130, 244, 0.04) 0%, transparent 40%),
                radial-gradient(circle at 85% 15%, rgba(245, 158, 11, 0.04) 0%, transparent 40%),
                radial-gradient(circle at 50% 20%, rgba(79, 130, 244, 0.02) 0%, transparent 30%),
                radial-gradient(circle at 20% 50%, rgba(245, 158, 11, 0.02) 0%, transparent 35%);
            pointer-events: none;
            z-index: 1;
        }

        .certificate-wrapper {
            background: #ffffff;
            position: relative;
            width: 100%;
            min-height: 500px;
            padding: 0;
            z-index: 2;
            display: flex;
            flex-direction: column;
            height: 100%;
        }

        /* Amber Header Banner */
        .cert-header-section {
            background: linear-gradient(135deg, #F59E0B 0%, #F97316 100%);
            color: white;
            text-align: center;
            padding: 1.5rem 2rem 1rem;
            position: relative;
            flex-shrink: 0;
        }

        .cert-header-section::after {
            content: "";
            position: absolute;
            bottom: -10px;
            left: 0;
            right: 0;
            height: 20px;
            background: linear-gradient(135deg, #F59E0B 0%, #F97316 100%);
            clip-path: polygon(0 0, 100% 0, 95% 100%, 5% 100%);
        }

        .cert-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            margin-bottom: 1rem;
            border: 3px solid white;
            background: white;
            padding: 2px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }

        .cert-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: white;
            margin: 0;
            letter-spacing: 3px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
            line-height: 1.1;
        }

        .cert-badge {
            display: inline-block;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            padding: 0.5rem 1.2rem;
            border-radius: 20px;
            font-size: 1rem;
            font-weight: 600;
            letter-spacing: 2px;
            margin-top: 0.8rem;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        /* Certificate Main Content */
        .cert-main-content {
            text-align: center;
            padding: 2rem 2rem 1.5rem;
            background: #ffffff;
            position: relative;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .cert-main-content::before {
            content: "🎓";
            position: absolute;
            top: 30px;
            left: 40px;
            font-size: 2.5rem;
            opacity: 0.08;
            pointer-events: none;
            z-index: 1;
        }

        .cert-main-content::after {
            content: "⭐";
            position: absolute;
            bottom: 40px;
            right: 50px;
            font-size: 2rem;
            opacity: 0.06;
            pointer-events: none;
            z-index: 1;
        }

        .cert-declaration-text {
            font-size: 1.2rem;
            color: #4b5563;
            margin: 1rem 0;
            font-weight: 400;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .cert-student-name {
            font-size: 2.2rem;
            font-weight: 700;
            color: #1f2937;
            margin: 1.2rem 0;
            position: relative;
            display: inline-block;
            font-family: "Brush Script MT", cursive, "Georgia", serif;
            font-style: italic;
        }

        .cert-student-name::after {
            content: "";
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 80%;
            height: 2px;
            background: #d1d5db;
            border-radius: 1px;
        }

        .cert-course-name {
            font-size: 1.5rem;
            font-weight: 600;
            color: #1f2937;
            margin: 1rem 0 0.8rem;
            font-style: italic;
        }

        .cert-certified-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
            padding: 0.5rem 1.2rem;
            border-radius: 25px;
            font-size: 0.9rem;
            font-weight: 600;
            letter-spacing: 1px;
            margin-top: 1rem;
            box-shadow: 0 3px 10px rgba(245, 158, 11, 0.3);
        }

        /* Certificate Footer */
        .cert-footer-section {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 1rem 2rem;
            background: #f9fafb;
            border-top: 1px solid #e5e7eb;
            gap: 1rem;
            flex-shrink: 0;
        }

        .cert-info-item {
            text-align: center;
            flex: 1;
        }

        .cert-info-icon {
            font-size: 1.5rem;
            color: #6b7280;
            margin-bottom: 0.5rem;
        }

        .cert-info-label {
            font-size: 0.8rem;
            color: #6b7280;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 0.3rem;
        }

        .cert-info-value {
            font-size: 0.9rem;
            color: #374151;
            font-weight: 500;
        }
        
        /* Control buttons */
        .print-controls {
            text-align: center;
            margin: 20px 0;
            padding: 20px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .btn {
            display: inline-block;
            padding: 12px 24px;
            margin: 0 10px;
            border: none;
            border-radius: 6px;
            font-weight: 600;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn-print {
            background: linear-gradient(135deg, #F59E0B, #F97316);
            color: white;
        }
        
        .btn-back {
            background: linear-gradient(135deg, #4F82F4, #6366f1);
            color: white;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }
    </style>
</head>
<body>
    <!-- Print Controls (hidden during print) -->
    <div class="print-controls no-print">
        <h3>🎓 Test Certificate Ready!</h3>
        <p>This is a test certificate. Click "Print/Save as PDF" to download it!</p>
        <button class="btn btn-print" onclick="window.print()">🖨️ Print/Save as PDF</button>
        <a href="certificates.php" class="btn btn-back">← Back to Certificates</a>
    </div>

    <!-- Certificate Content -->
    <div class="certificate-container">
        <div class="certificate-wrapper">
            <!-- Certificate Header -->
            <div class="cert-header-section">
                <img src="../assets/images/logo.jpeg" alt="Panadite Academy" class="cert-logo">
                <h1 class="cert-title">PANADITE ACADEMY</h1>
                <span class="cert-badge">
                    🏆 CERTIFICATE OF COMPLETION
                </span>
            </div>

            <!-- Certificate Content -->
            <div class="cert-main-content">
                <p class="cert-declaration-text">This is to certify that</p>
                <h2 class="cert-student-name"><?= htmlspecialchars($student_name) ?></h2>
                <p class="cert-declaration-text">has successfully completed the course</p>
                <h3 class="cert-course-name"><?= htmlspecialchars($course_title) ?></h3>
                <span class="cert-certified-badge">
                    ✅ CERTIFIED
                </span>
            </div>

            <!-- Certificate Footer -->
            <div class="cert-footer-section">
                <div class="cert-info-item">
                    <div class="cert-info-icon">📅</div>
                    <div class="cert-info-label">Completed</div>
                    <div class="cert-info-value"><?= date('F d, Y') ?></div>
                </div>
                <div class="cert-info-item">
                    <div class="cert-info-icon">👨‍🏫</div>
                    <div class="cert-info-label">Instructor</div>
                    <div class="cert-info-value"><?= htmlspecialchars($instructor_name) ?></div>
                </div>
                <div class="cert-info-item">
                    <div class="cert-info-icon">🆔</div>
                    <div class="cert-info-label">Certificate ID</div>
                    <div class="cert-info-value"><?= $certificate_id ?></div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Auto-focus for print dialog
        window.addEventListener('load', function() {
            document.body.style.visibility = 'visible';
        });
        
        // Handle keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            if ((e.ctrlKey || e.metaKey) && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
        });
    </script>
</body>
</html>
