<?php
/**
 * Direct Certificate API Test
 * Test the certificate generation API directly
 */

require_once '../auth/functions.php';
require_once '../config/db_connect.php';

echo "<h2>🎯 Direct Certificate API Test</h2>";
echo "<div style='font-family: Arial, sans-serif; max-width: 800px; margin: 20px;'>";

try {
    // Show current session info
    echo "<div style='background: #f8f9fa; border: 1px solid #dee2e6; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>📊 Current Session</h3>";
    echo "<pre>" . print_r($_SESSION, true) . "</pre>";
    echo "</div>";
    
    // Test authentication
    $user_id = $_SESSION['user_id'] ?? null;
    $user_role = $_SESSION['user_role'] ?? null;
    $course_id = 13; // Computer science course
    
    echo "<div style='background: #d1ecf1; border: 1px solid #bee5eb; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>🔧 API Test Parameters</h3>";
    echo "<ul>";
    echo "<li><strong>User ID:</strong> " . ($user_id ?: 'MISSING') . "</li>";
    echo "<li><strong>User Role:</strong> " . ($user_role ?: 'MISSING') . "</li>";
    echo "<li><strong>Course ID:</strong> $course_id</li>";
    echo "</ul>";
    echo "</div>";
    
    if (!$user_id || $user_role !== 'student') {
        throw new Exception("Authentication failed - User ID: $user_id, Role: $user_role");
    }
    
    // Test certificate eligibility first
    require_once '../includes/course_progress_service_quiz_only.php';
    $progressService = new QuizOnlyProgressService($conn);
    $eligibility = $progressService->isCertificateEligible($user_id, $course_id);
    
    echo "<div style='background: #e8f5e8; border: 1px solid #28a745; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>🎓 Certificate Eligibility Check</h3>";
    echo "<ul>";
    echo "<li><strong>Eligible:</strong> " . ($eligibility['eligible'] ? 'YES ✅' : 'NO ❌') . "</li>";
    echo "<li><strong>Current %:</strong> " . $eligibility['current_percentage'] . "%</li>";
    echo "<li><strong>Required %:</strong> " . $eligibility['minimum_required'] . "%</li>";
    echo "</ul>";
    echo "</div>";
    
    if (!$eligibility['eligible']) {
        echo "<div style='background: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
        echo "<h3>⚠️ Student Not Eligible</h3>";
        echo "<p>Student needs " . $eligibility['minimum_required'] . "% but only has " . $eligibility['current_percentage'] . "%</p>";
        echo "</div>";
    } else {
        // Try to generate certificate
        require_once '../includes/certificate_automation.php';
        
        echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
        echo "<h3>🚀 Attempting Certificate Generation</h3>";
        
        $certResult = onCourseCompletion($user_id, $course_id);
        
        if ($certResult['success']) {
            echo "<p><strong>✅ SUCCESS!</strong> Certificate generated successfully!</p>";
            echo "<pre>" . print_r($certResult, true) . "</pre>";
        } else {
            echo "<p><strong>❌ FAILED!</strong> " . $certResult['message'] . "</p>";
            echo "<pre>" . print_r($certResult, true) . "</pre>";
        }
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>❌ Error</h3>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}

echo "</div>";
?>

<div style="margin: 20px;">
    <a href="debug_certificate_progress.php?course_id=13" class="btn btn-primary" style="background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">
        ← Back to Debug Page
    </a>
</div>
