<?php
// 🧪 SIMPLE DECRYPTION TEST
header('Content-Type: application/json');

try {
    // Test basic includes
    require_once '../includes/id_encryption.php';
    
    // Test if function exists
    if (!function_exists('decryptId')) {
        echo json_encode(['success' => false, 'error' => 'decryptId function not found']);
        exit;
    }
    
    // Test with the actual encrypted ID
    $encrypted_id = $_GET['test_id'] ?? 'akJKZEZteGNEVmFNSnZNcFdhV1g3Zz09';
    
    // Attempt decryption
    $decrypted = decryptId($encrypted_id);
    
    echo json_encode([
        'success' => true,
        'input' => $encrypted_id,
        'output' => $decrypted,
        'output_type' => gettype($decrypted),
        'is_numeric' => is_numeric($decrypted),
        'function_exists' => function_exists('decryptId')
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
}
?>
