<?php
/**
 * 📊 UPDATE VIDEO PROGRESS ENDPOINT
 * Updates video progress in user_video_completions table
 */

require_once '../includes/config.php';
require_once '../includes/session.php';

header('Content-Type: application/json');

try {
    // Check if user is logged in
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['success' => false, 'message' => 'User not logged in']);
        exit;
    }
    
    $user_id = $_SESSION['user_id'];
    $video_id = (int)$_POST['video_id'];
    $completion_percentage = (float)$_POST['completion_percentage'];
    $watch_time = (float)$_POST['watch_time'];
    
    // Validate input
    if (!$video_id || $completion_percentage < 0 || $completion_percentage > 100) {
        echo json_encode(['success' => false, 'message' => 'Invalid input data']);
        exit;
    }
    
    // Insert or update progress record
    $stmt = $conn->prepare("
        INSERT INTO user_video_completions 
        (user_id, video_id, completion_percentage, watch_time, updated_at) 
        VALUES (?, ?, ?, ?, NOW())
        ON DUPLICATE KEY UPDATE 
        completion_percentage = GREATEST(completion_percentage, VALUES(completion_percentage)),
        watch_time = GREATEST(watch_time, VALUES(watch_time)),
        updated_at = NOW()
    ");
    
    $stmt->bind_param("iidd", $user_id, $video_id, $completion_percentage, $watch_time);
    
    if ($stmt->execute()) {
        echo json_encode([
            'success' => true,
            'message' => 'Progress updated successfully',
            'video_id' => $video_id,
            'completion_percentage' => $completion_percentage,
            'watch_time' => $watch_time
        ]);
    } else {
        throw new Exception('Failed to update progress: ' . $stmt->error);
    }
    
    $stmt->close();
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
