# Teacher Pages Layout Implementation Guide

This guide explains how to update all teacher role pages to include the redesigned navbar and sidebar.

## Structure Overview

We've created a standardized layout system using these components:

1. `components/teacher_layout.php` - Includes the header, sidebar, and navbar
2. `components/teacher_layout_end.php` - Includes closing tags and common scripts
3. `components/sidebar.php` - The redesigned sidebar with all navigation items
4. `components/navbar.php` - The redesigned navbar with profile dropdown

## How to Update Existing Pages

For each teacher role page, follow these steps:

### 1. Remove existing header/navbar/sidebar includes

Remove any of these lines if they exist:
```php
include_once 'components/header.php';
include_once 'components/header_content.php';
include_once 'components/sidebar.php';
include_once 'components/navbar.php';
```

Also remove any manual `<!DOCTYPE html>`, `<html>`, `<head>`, `<body>` tags and their closing counterparts.

### 2. Add the standard layout includes

At the top of your file (after any session or initial PHP code):
```php
// Include the centralized teacher layout
require_once __DIR__ . '/components/teacher_layout.php';

// Your page-specific PHP code here
```

At the bottom of your file (before any page-specific scripts):
```php
// Include the centralized teacher layout end
require_once __DIR__ . '/components/teacher_layout_end.php';

// Your page-specific scripts here
```

### 3. Keep your page content between the includes

All your page-specific HTML content should go between these two include statements.

## Template Example

We've created a template file at `template-page.php` that demonstrates the correct structure. Use this as a reference when updating existing pages or creating new ones.

## Verification

After updating each page:
1. Check that the redesigned navbar appears with the profile avatar properly visible
2. Verify that the sidebar includes all menu items and navigation works correctly
3. Test that the page content displays correctly

## Pages to Update

Update these key pages first:
- ✅ dashboard.php (already updated as an example)
- courses.php
- videos.php
- enrolled_students.php
- analytics.php
- quizzes.php
- assignments.php
- profile.php
- settings.php

Then update any additional pages used in the teacher role.
