<?php
/**
 * Teacher Authentication Fix Utility
 * This page helps resolve redirect loop issues
 */

// Include session start script
include_once "../includes/session_start.php";

// Immediately clear all session data to start fresh
$_SESSION = array();
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(), 
        '', 
        time() - 42000,
        $params["path"], 
        $params["domain"],
        $params["secure"], 
        $params["httponly"]
    );
}
session_destroy();

// Start a new session
session_start();

// Set a flag indicating we just cleared the session
$_SESSION['session_cleared'] = true;
$_SESSION['session_cleared_time'] = time();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Authentication Fix | Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .fix-container {
            max-width: 800px;
            margin: 100px auto;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            overflow: hidden;
        }
        .header {
            background-color: #4e73df;
            color: white;
            padding: 20px;
            text-align: center;
        }
        .content {
            padding: 30px;
        }
        .logo {
            max-width: 180px;
            margin-bottom: 15px;
        }
        .btn-fix {
            background-color: #4e73df;
            border-color: #4e73df;
            padding: 10px 25px;
            font-weight: 500;
        }
        .btn-fix:hover {
            background-color: #2e59d9;
            border-color: #2653d4;
        }
        .btn-login {
            background-color: #1cc88a;
            border-color: #1cc88a;
            padding: 10px 25px;
            font-weight: 500;
        }
        .btn-login:hover {
            background-color: #17a673;
            border-color: #169b6b;
        }
        .step {
            border-left: 3px solid #4e73df;
            padding-left: 20px;
            margin-bottom: 20px;
        }
        .step h4 {
            color: #4e73df;
            margin-bottom: 10px;
        }
        .flash-message {
            animation: flash 2s infinite;
        }
        @keyframes flash {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }
    </style>
</head>
<body>
    <div class="fix-container">
        <div class="header">
            <img src="../assets/img/logo.png" alt="Panadite Academy" class="logo">
            <h2><i class='bx bx-shield-quarter'></i> Authentication Fix Utility</h2>
        </div>
        
        <div class="content">
            <div class="alert alert-info">
                <p><strong><i class='bx bx-info-circle'></i> Your session has been cleared.</strong> This helps resolve login redirect loops.</p>
            </div>
            
            <h3 class="mb-4">Authentication Issue Solutions</h3>
            
            <div class="steps mb-4">
                <div class="step">
                    <h4>Step 1: Clear Browser Cache & Cookies</h4>
                    <p>Your session data is now cleared on the server. For best results, also clear your browser cookies:</p>
                    <ul>
                        <li>Chrome: Settings → Privacy and Security → Clear browsing data</li>
                        <li>Firefox: Options → Privacy & Security → Cookies and Site Data → Clear Data</li>
                        <li>Edge: Settings → Privacy, search, and services → Clear browsing data</li>
                    </ul>
                    <button class="btn btn-sm btn-secondary" onclick="clearLocalCookies()">Clear Local Cookies</button>
                </div>
                
                <div class="step">
                    <h4>Step 2: Login Again</h4>
                    <p>After clearing cookies, try logging in again with your teacher credentials.</p>
                    <a href="../auth/login.php?clear_session=true" class="btn btn-login">
                        <i class='bx bx-log-in'></i> Go to Login
                    </a>
                </div>
                
                <div class="step">
                    <h4>Step 3: Use Emergency Login (if needed)</h4>
                    <p>If you're still experiencing issues, try the emergency teacher login:</p>
                    <ul>
                        <li>Username: <code>teacher</code></li>
                        <li>Password: <code>teacher123</code></li>
                    </ul>
                </div>
            </div>
            
            <div class="d-flex justify-content-between mt-5">
                <a href="../index.php" class="btn btn-outline-secondary">
                    <i class='bx bx-home'></i> Home Page
                </a>
                <a href="dashboard.php" class="btn btn-fix">
                    <i class='bx bx-dashboard'></i> Try Teacher Dashboard
                </a>
            </div>
        </div>
    </div>

    <script>
    function clearLocalCookies() {
        // Clear all cookies
        document.cookie.split(";").forEach(function(c) {
            document.cookie = c.trim().split("=")[0] + "=;" + "expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
        });
        
        // Show success message
        alert("Local cookies cleared successfully! You can now try logging in again.");
    }
    </script>
</body>
</html>
