<?php
// Check PHP upload settings
echo "<h2>PHP Upload Settings</h2>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Setting</th><th>Value</th></tr>";

$settings = [
    'upload_max_filesize' => ini_get('upload_max_filesize'),
    'post_max_size' => ini_get('post_max_size'),
    'memory_limit' => ini_get('memory_limit'),
    'max_execution_time' => ini_get('max_execution_time'),
    'max_input_time' => ini_get('max_input_time'),
    'max_file_uploads' => ini_get('max_file_uploads'),
    'file_uploads' => ini_get('file_uploads') ? 'On' : 'Off',
    'upload_tmp_dir' => ini_get('upload_tmp_dir') ?: 'System default',
];

foreach ($settings as $key => $value) {
    echo "<tr><td>$key</td><td>$value</td></tr>";
}
echo "</table>";

echo "<h3>Calculated Sizes in Bytes:</h3>";
function parseSize($size) {
    $unit = preg_replace('/[^bkmgtpezy]/i', '', $size);
    $size = preg_replace('/[^0-9\.]/', '', $size);
    if ($unit) {
        return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
    } else {
        return round($size);
    }
}

echo "<p>upload_max_filesize: " . parseSize(ini_get('upload_max_filesize')) . " bytes</p>";
echo "<p>post_max_size: " . parseSize(ini_get('post_max_size')) . " bytes</p>";
echo "<p>memory_limit: " . parseSize(ini_get('memory_limit')) . " bytes</p>";

echo "<h3>Temp Directory Check:</h3>";
$temp_dir = sys_get_temp_dir();
echo "<p>Temp directory: $temp_dir</p>";
echo "<p>Temp directory writable: " . (is_writable($temp_dir) ? 'Yes' : 'No') . "</p>";

echo "<h3>Upload Directories Check:</h3>";
$uploads_dir = '../uploads';
$videos_dir = $uploads_dir . '/videos';
$thumbnails_dir = $uploads_dir . '/thumbnails';

echo "<p>Uploads directory exists: " . (file_exists($uploads_dir) ? 'Yes' : 'No') . "</p>";
echo "<p>Uploads directory writable: " . (is_writable($uploads_dir) ? 'Yes' : 'No') . "</p>";
echo "<p>Videos directory exists: " . (file_exists($videos_dir) ? 'Yes' : 'No') . "</p>";
echo "<p>Videos directory writable: " . (is_writable($videos_dir) ? 'Yes' : 'No') . "</p>";
echo "<p>Thumbnails directory exists: " . (file_exists($thumbnails_dir) ? 'Yes' : 'No') . "</p>";
echo "<p>Thumbnails directory writable: " . (is_writable($thumbnails_dir) ? 'Yes' : 'No') . "</p>";

echo "<h3>Session Check:</h3>";
session_start();
echo "<p>Session user_id: " . ($_SESSION['user_id'] ?? 'not set') . "</p>";
echo "<p>Session user_role: " . ($_SESSION['user_role'] ?? 'not set') . "</p>";
?>
