<?php
/**
 * 👥 USER ACCOUNTS CHECK SCRIPT
 */

require_once __DIR__ . '/../includes/config.php';

echo "<html><head><title>👥 User Accounts Check</title></head><body style='font-family: monospace; padding: 20px;'>";
echo "<h1>👥 USER ACCOUNTS CHECK</h1>";
echo "<hr>";

// Check database connection
if (!isset($conn) || $conn->connect_error) {
    echo "<p style='color: red;'>❌ Database connection failed!</p>";
    exit();
}

echo "<h2>🔍 AVAILABLE TEACHER ACCOUNTS</h2>";

// Query for teacher accounts
$sql = "SELECT user_id, username, email, first_name, last_name, user_role FROM users WHERE user_role = 'teacher' ORDER BY user_id";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr style='background: #f0f0f0;'>";
    echo "<th>User ID</th><th>Username</th><th>Email</th><th>First Name</th><th>Last Name</th><th>Role</th>";
    echo "</tr>";
    
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['user_id']) . "</td>";
        echo "<td><strong>" . htmlspecialchars($row['username']) . "</strong></td>";
        echo "<td>" . htmlspecialchars($row['email']) . "</td>";
        echo "<td>" . htmlspecialchars($row['first_name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['last_name']) . "</td>";
        echo "<td><span style='color: green; font-weight: bold;'>" . htmlspecialchars($row['user_role']) . "</span></td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<p style='color: green; font-weight: bold;'>✅ Found " . $result->num_rows . " teacher account(s)</p>";
    
} else {
    echo "<p style='color: red;'>❌ No teacher accounts found in the database!</p>";
    
    echo "<h3>🔍 ALL USER ACCOUNTS:</h3>";
    $sql_all = "SELECT user_id, username, email, first_name, last_name, user_role FROM users ORDER BY user_role, user_id";
    $result_all = $conn->query($sql_all);
    
    if ($result_all && $result_all->num_rows > 0) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
        echo "<tr style='background: #f0f0f0;'>";
        echo "<th>User ID</th><th>Username</th><th>Email</th><th>First Name</th><th>Last Name</th><th>Role</th>";
        echo "</tr>";
        
        while ($row = $result_all->fetch_assoc()) {
            $role_color = $row['user_role'] === 'admin' ? 'blue' : ($row['user_role'] === 'teacher' ? 'green' : 'orange');
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['user_id']) . "</td>";
            echo "<td><strong>" . htmlspecialchars($row['username']) . "</strong></td>";
            echo "<td>" . htmlspecialchars($row['email']) . "</td>";
            echo "<td>" . htmlspecialchars($row['first_name']) . "</td>";
            echo "<td>" . htmlspecialchars($row['last_name']) . "</td>";
            echo "<td><span style='color: $role_color; font-weight: bold;'>" . htmlspecialchars($row['user_role']) . "</span></td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>❌ No users found in database at all!</p>";
    }
}

echo "<hr>";

echo "<h2>📋 NEXT STEPS</h2>";
echo "<ol>";
echo "<li><strong>Use one of the teacher accounts above</strong> to log in</li>";
echo "<li><strong>Go to:</strong> <a href='../auth/login.php'>Login Page</a></li>";
echo "<li><strong>Enter the username/email and password</strong></li>";
echo "<li><strong>After login, try video upload again</strong></li>";
echo "</ol>";

echo "<div style='margin: 20px 0;'>";
echo "<a href='../auth/login.php' style='display: inline-block; padding: 10px 20px; background: #007bff; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px;'>🔐 Go to Login</a>";
echo "<a href='check-session.php' style='display: inline-block; padding: 10px 20px; background: #17a2b8; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px;'>🔍 Check Session</a>";
echo "<a href='upload-video.php' style='display: inline-block; padding: 10px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 3px;'>🎬 Try Upload</a>";
echo "</div>";

echo "</body></html>";

$conn->close();
?>
