<?php
require_once '../config/db_connect.php';

echo "<h1>🔍 Thumbnail Status After Repair</h1>";

// Check what's actually in the database now
$query = "SELECT video_id, title, thumbnail, video_type, platform, video_id_external, created_at 
          FROM videos 
          ORDER BY created_at DESC";

$result = $conn->query($query);

if (!$result) {
    echo "<p style='color: red;'>Error: " . $conn->error . "</p>";
    exit;
}

echo "<h2>📊 Current Database State</h2>";
echo "<table border='1' cellpadding='8' style='border-collapse: collapse; width: 100%;'>";
echo "<tr style='background: #f0f0f0;'>
        <th>ID</th>
        <th>Title</th>
        <th>Type</th>
        <th>Platform</th>
        <th>Video ID</th>
        <th>Thumbnail Value</th>
        <th>Thumbnail Status</th>
        <th>Preview</th>
      </tr>";

while ($video = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . $video['video_id'] . "</td>";
    echo "<td>" . htmlspecialchars(substr($video['title'], 0, 30)) . "...</td>";
    echo "<td><span style='color: " . ($video['video_type'] == 'url' ? 'blue' : 'green') . ";'>" . $video['video_type'] . "</span></td>";
    echo "<td>" . ($video['platform'] ?: 'NULL') . "</td>";
    echo "<td>" . ($video['video_id_external'] ?: 'NULL') . "</td>";
    
    // Thumbnail value analysis
    if ($video['thumbnail']) {
        $isExternal = (strpos($video['thumbnail'], 'http') === 0);
        $color = $isExternal ? 'blue' : 'orange';
        $type = $isExternal ? 'External URL' : 'Local Path';
        echo "<td style='color: $color; font-size: 12px;'>" . htmlspecialchars($video['thumbnail']) . "</td>";
        echo "<td style='color: green;'>✅ HAS THUMBNAIL ($type)</td>";
        
        // Show preview
        if ($isExternal) {
            echo "<td><img src='" . htmlspecialchars($video['thumbnail']) . "' style='max-width: 80px; height: auto;' alt='Preview' onload=\"this.style.border='2px solid green'\" onerror=\"this.style.border='2px solid red'; this.alt='❌ Failed'\"></td>";
        } else {
            $localPath = '../' . ltrim($video['thumbnail'], '/');
            echo "<td><img src='" . htmlspecialchars($localPath) . "' style='max-width: 80px; height: auto;' alt='Preview' onload=\"this.style.border='2px solid green'\" onerror=\"this.style.border='2px solid red'; this.alt='❌ Failed'\"></td>";
        }
    } else {
        echo "<td style='color: red;'>NULL</td>";
        echo "<td style='color: red;'>❌ NO THUMBNAIL</td>";
        echo "<td style='color: #ccc;'>No preview</td>";
    }
    
    echo "</tr>";
}

echo "</table>";

// Check specific YouTube videos
echo "<h2>🔍 YouTube Videos Detailed Check</h2>";
$youtubeQuery = "SELECT video_id, title, thumbnail, video_id_external 
                 FROM videos 
                 WHERE platform = 'youtube' 
                 ORDER BY created_at DESC";

$youtubeResult = $conn->query($youtubeQuery);

if ($youtubeResult && $youtubeResult->num_rows > 0) {
    while ($video = $youtubeResult->fetch_assoc()) {
        echo "<div style='border: 1px solid #ddd; padding: 15px; margin: 10px 0; border-radius: 5px;'>";
        echo "<h4>Video ID: " . $video['video_id'] . " - " . htmlspecialchars($video['title']) . "</h4>";
        echo "<p><strong>YouTube ID:</strong> " . $video['video_id_external'] . "</p>";
        echo "<p><strong>Thumbnail in DB:</strong> " . ($video['thumbnail'] ?: '<span style="color: red;">NULL</span>') . "</p>";
        
        if ($video['video_id_external']) {
            $expectedUrl = "https://img.youtube.com/vi/{$video['video_id_external']}/maxresdefault.jpg";
            echo "<p><strong>Expected URL:</strong> " . $expectedUrl . "</p>";
            
            if ($video['thumbnail'] === $expectedUrl) {
                echo "<p style='color: green;'>✅ Thumbnail matches expected URL</p>";
            } else {
                echo "<p style='color: red;'>❌ Thumbnail does NOT match expected URL</p>";
            }
            
            echo "<p><strong>Preview:</strong></p>";
            echo "<img src='" . $expectedUrl . "' style='max-width: 300px; height: auto; border: 1px solid #ccc;' alt='YouTube Thumbnail' onload=\"this.style.border='2px solid green'\" onerror=\"this.style.border='2px solid red'; this.alt='❌ Failed to load'\">";
        }
        echo "</div>";
    }
} else {
    echo "<p>No YouTube videos found.</p>";
}

// Test the videos.php thumbnail logic
echo "<h2>🧪 Simulate videos.php Thumbnail Logic</h2>";
echo "<p>Testing the exact same logic used in videos.php:</p>";

$testQuery = "SELECT video_id, title, thumbnail FROM videos WHERE platform = 'youtube' LIMIT 3";
$testResult = $conn->query($testQuery);

if ($testResult && $testResult->num_rows > 0) {
    while ($video = $testResult->fetch_assoc()) {
        echo "<div style='background: #f9f9f9; padding: 10px; margin: 5px 0; border-radius: 3px;'>";
        echo "<strong>Video " . $video['video_id'] . ":</strong> " . htmlspecialchars($video['title']) . "<br>";
        echo "<strong>Raw thumbnail value:</strong> " . ($video['thumbnail'] ?: 'NULL') . "<br>";
        
        // Simulate the exact logic from videos.php
        echo "<strong>videos.php logic result:</strong> ";
        
        if (isset($video['thumbnail']) && !empty($video['thumbnail'])) {
            $thumb = $video['thumbnail'];
            if (strpos($thumb, 'http://') === 0 || strpos($thumb, 'https://') === 0) {
                $finalUrl = $thumb; // External URL, use as is
                echo "External URL: " . $finalUrl;
            } else {
                $finalUrl = '../' . ltrim($thumb, '/'); // Local path
                echo "Local path: " . $finalUrl;
            }
        } else {
            $finalUrl = 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="40" height="30" viewBox="0 0 40 30"%3E%3Crect width="40" height="30" fill="%23f3f4f6"/%3E%3Cpath d="M15 10l8 5-8 5z" fill="%236b7280"/%3E%3C/svg%3E';
            echo "Placeholder SVG (no thumbnail)";
        }
        
        echo "<br><strong>Final result:</strong> <code>" . htmlspecialchars($finalUrl) . "</code>";
        echo "</div>";
    }
}

echo "<hr>";
echo "<p><strong>Debug completed:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
