<?php
/**
 * Centralized teacher layout component
 * This file should be included at the top of all teacher role pages
 */

// Start session first with proper configuration
require_once __DIR__ . '/../../includes/session_start.php';

// Include the centralized authentication system
// This will handle session verification, redirect to login if needed,
// and detect/prevent redirect loops
require_once __DIR__ . '/teacher_auth.php';

// If we're here, authentication was successful (or bypassed)

// Get current page name for navigation highlighting
if (!isset($current_page)) {
    $current_page = basename($_SERVER['PHP_SELF']);
}
$page_title = ucfirst(str_replace(['-', '.php'], [' ', ''], $current_page));

// Connect to database
require_once __DIR__ . '/../../includes/db_connection.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?> - Panadite Academy Teacher Portal</title>
    
    <!-- Favicon - Multiple Fallback Options -->
    <link rel="shortcut icon" href="/assets/images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/assets/images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/logo.jpeg" type="image/jpeg">
    <link rel="icon" href="/assets/images/logo.jpeg" type="image/jpeg">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="/logo.jpeg">
    <link rel="apple-touch-icon" href="/assets/images/logo.jpeg">
    
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Boxicons -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    
    <!-- FontAwesome 6 for better icon support -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/js/all.min.js"></script>
    
    <!-- Core CSS - Keep only essential ones -->
    <link rel="stylesheet" href="../assets/css/style.css">
    
    <!-- Page-specific CSS and JS - Only Chart.js for dashboard -->
    <?php if ($current_page === 'dashboard.php'): ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
    <?php elseif ($current_page === 'analytics.php'): ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.35.0/dist/apexcharts.css">
    <?php endif; ?>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- ADMIN SIDEBAR STYLING - Load AFTER page-specific CSS to override conflicts -->
    <style>
        /* CSS Variables - Override modern-dashboard.css */
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4caf50;
            --info-color: #2196f3;
            --warning-color: #ff9800;
            --danger-color: #f44336;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --grey-color: #adb5bd;
            --sidebar-width: 250px !important;
            --sidebar-collapsed-width: 2.5rem !important;
            --transition-speed: 0.3s;
        }

        /* Modern Sidebar Design - Compatible with Airbnb Navbar */
        .modern-dashboard .sidebar,
        body .sidebar,
        html .sidebar,
        .sidebar {
            position: fixed !important;
            left: 0 !important;
            top: 80px !important;
            height: calc(100vh - 80px) !important;
            width: 250px !important;
            background: #ffffff !important;
            z-index: 99 !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08) !important;
            font-family: 'Poppins', sans-serif !important;
            border-right: 1px solid #e5e7eb !important;
        }

        .sidebar.close {
            width: 70px !important;
        }

        /* Collapsed Sidebar Navigation */
        .sidebar.close .nav-links {
            padding: 0 8px !important;
        }

        .sidebar.close .nav-links li a {
            padding: 0 !important;
            justify-content: center !important;
            width: 54px !important;
            height: 54px !important;
            border-radius: 12px !important;
            margin: 0 auto !important;
            transform: translateX(0) !important;
        }

        .sidebar.close .nav-links li a:hover {
            transform: translateY(-2px) !important;
        }

        .sidebar.close .nav-links li a i {
            margin-right: 0 !important;
            font-size: 22px !important;
        }

        .sidebar.close .nav-links li a .link_name {
            display: none !important;
        }

        /* Tooltip for collapsed sidebar */
        .sidebar.close .nav-links li {
            position: relative !important;
        }

        .sidebar.close .nav-links li:hover::after {
            content: attr(data-tooltip) !important;
            position: absolute !important;
            left: 65px !important;
            top: 50% !important;
            transform: translateY(-50%) !important;
            background: #1f2937 !important;
            color: white !important;
            padding: 8px 12px !important;
            border-radius: 6px !important;
            font-size: 12px !important;
            white-space: nowrap !important;
            z-index: 1000 !important;
            opacity: 0 !important;
            animation: fadeInTooltip 0.2s ease forwards !important;
        }

        @keyframes fadeInTooltip {
            to {
                opacity: 1 !important;
            }
        }

        /* Mobile sidebar positioning */
        @media (max-width: 768px) {
            .sidebar {
                top: 70px !important;
                height: calc(100vh - 70px) !important;
                left: -250px !important;
                z-index: 1001 !important;
            }
            
            .sidebar.close {
                left: 0 !important;
                width: 250px !important;
            }

            .sidebar.close .nav-links {
                padding: 0 16px !important;
            }

            .sidebar.close .nav-links li a {
                padding: 0 16px !important;
                justify-content: flex-start !important;
                width: 100% !important;
                height: 48px !important;
            }

            .sidebar.close .nav-links li a i {
                margin-right: 12px !important;
                font-size: 20px !important;
            }

            .sidebar.close .nav-links li a .link_name {
                display: block !important;
            }

            .sidebar-toggle-btn {
                display: block !important;
            }
        }

        /* Ensure Boxicons load properly */
        .sidebar i[class^='bx'], 
        .sidebar i[class*=' bx'] {
            font-family: 'boxicons' !important;
            font-style: normal !important;
            font-variant: normal !important;
            font-weight: normal !important;
            line-height: 1 !important;
            text-transform: none !important;
            speak: none !important;
            -webkit-font-smoothing: antialiased !important;
            -moz-osx-font-smoothing: grayscale !important;
        }

        /* Logo section */
        .sidebar .logo-details {
            height: 60px !important;
            display: flex !important;
            align-items: center !important;
            padding: 0 20px !important;
            border-bottom: 1px solid #f0f0f0 !important;
        }

        .sidebar .logo-details .logo-img {
            width: 40px !important;
            height: 40px !important;
            border-radius: 8px !important;
            margin-right: 12px !important;
        }

        .sidebar .logo-details .logo_name {
            color: var(--dark-color) !important;
            font-size: 20px !important;
            font-weight: 600 !important;
        }

        /* Navigation links */
        .sidebar .nav-links {
            margin-top: 20px !important;
            height: calc(100vh - 100px) !important;
            overflow-y: auto !important;
            padding: 0 16px !important;
            list-style: none !important;
        }

        .sidebar .nav-links::-webkit-scrollbar {
            width: 4px !important;
        }

        .sidebar .nav-links::-webkit-scrollbar-track {
            background: transparent !important;
        }

        .sidebar .nav-links::-webkit-scrollbar-thumb {
            background: #e5e7eb !important;
            border-radius: 2px !important;
        }

        .sidebar .nav-links li {
            position: relative !important;
            margin: 0 0 8px 0 !important;
            list-style: none !important;
        }

        .sidebar .nav-links li a {
            display: flex !important;
            height: 48px !important;
            width: 100% !important;
            align-items: center !important;
            text-decoration: none !important;
            padding: 0 16px !important;
            border-radius: 12px !important;
            color: #6b7280 !important;
            font-size: 14px !important;
            font-weight: 500 !important;
            white-space: nowrap !important;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1) !important;
            border: 1px solid transparent !important;
        }

        .sidebar .nav-links li a:hover {
            color: #4361ee !important;
            background: #f8faff !important;
            border-color: #e1e8ff !important;
            transform: translateX(4px) !important;
        }

        .sidebar .nav-links li a:hover i,
        .sidebar .nav-links li a:hover .link_name {
            color: #4361ee !important;
        }

        .sidebar .nav-links li.active a,
        .sidebar .nav-links li.active a:hover {
            background: linear-gradient(135deg, #4361ee, #5a72f0) !important;
            color: white !important;
            border-color: transparent !important;
            box-shadow: 0 4px 12px rgba(67, 97, 238, 0.3) !important;
            transform: translateX(0) !important;
        }

        .sidebar .nav-links li.active a i,
        .sidebar .nav-links li.active a .link_name {
            color: white !important;
        }

        /* Sidebar collapsed state - Testing with larger width to confirm CSS works */
        .dashboard-wrapper .sidebar.close,
        body .sidebar.close,
        html .sidebar.close,
        .sidebar.close,
        div.sidebar.close {
            width: 80px !important;
            min-width: 80px !important;
            max-width: 80px !important;
            overflow-x: hidden !important;
            overflow-y: auto !important;
            flex-shrink: 0 !important;
        }

        /* Force nav-links container to not exceed sidebar width */
        .sidebar.close .nav-links,
        .sidebar.close ul.nav-links {
            width: 80px !important;
            max-width: 80px !important;
            overflow-x: hidden !important;
            padding: 10px 0 !important;
            margin: 0 !important;
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
            list-style: none !important;
        }

        /* Logo section when collapsed - Perfect alignment with specific width */
        .dashboard-wrapper .sidebar.close .logo-details,
        body .sidebar.close .logo-details,
        .sidebar.close .logo-details {
            padding: 10px 0 !important;
            justify-content: center !important;
            align-items: center !important;
            width: 80px !important;
            height: 60px !important;
        }

        .sidebar.close .logo-details .logo-name {
            opacity: 0 !important;
            pointer-events: none !important;
            display: none !important;
        }

        .sidebar.close .logo-details .logo-img {
            width: 32px !important;
            height: 32px !important;
            margin: 0 auto !important;
            display: block !important;
            border-radius: 6px !important;
        }

        /* Navigation links when collapsed - Perfect icon centering with specific width */
        .dashboard-wrapper .sidebar.close .nav-links li,
        body .sidebar.close .nav-links li,
        .sidebar.close .nav-links li {
            position: relative !important;
            margin: 3px 0 !important;
            width: 80px !important;
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
            list-style: none !important;
        }

        .dashboard-wrapper .sidebar.close .nav-links li a,
        body .sidebar.close .nav-links li a,
        .sidebar.close .nav-links li a {
            padding: 15px 0 !important;
            justify-content: center !important;
            align-items: center !important;
            width: 80px !important;
            height: 50px !important;
            border-radius: 0 !important;
            margin: 2px 0 !important;
            display: flex !important;
            background: transparent !important;
            text-decoration: none !important;
            position: static !important;
            z-index: auto !important;
            transform: none !important;
            pointer-events: auto !important;
            cursor: pointer !important;
            transition: none !important;
        }

        .sidebar.close .nav-links li a i {
            min-width: auto !important;
            font-size: 22px !important;
            margin: 0 auto !important;
            text-align: center !important;
            width: 22px !important;
            height: 22px !important;
            display: block !important;
            color: #555 !important;
            position: static !important;
            z-index: auto !important;
            transform: none !important;
            transition: none !important;
            float: none !important;
        }

        .sidebar.close .nav-links li a .link_name {
            display: none !important;
        }

        /* Completely disable ALL hover effects for collapsed sidebar */
        .sidebar.close .nav-links li:hover a,
        .sidebar.close .nav-links li a:hover {
            background: transparent !important;
            transform: none !important;
            transition: none !important;
            border-radius: 0 !important;
            box-shadow: none !important;
            scale: none !important;
        }

        .sidebar.close .nav-links li.active a {
            background: transparent !important;
            border-radius: 0 !important;
            box-shadow: none !important;
        }

        /* Force icon visibility in collapsed state */
        .sidebar.close .nav-links li a i {
            visibility: visible !important;
            opacity: 1 !important;
            display: flex !important;
        }

        /* Ensure nav-links are properly stacked and visible */
        .sidebar.close .nav-links {
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        .sidebar.close .nav-links li.active a i {
            color: var(--primary-color) !important;
        }

        /* Hide sidebar toggle button in sidebar */
        .sidebar .logo-details .sidebar-toggle {
            display: none !important;
        }

        /* Main Content Area - Starts with collapsed sidebar like Image 3 */
        .main-content {
            position: relative !important;
            min-height: 100vh !important;
            width: calc(100% - 70px) !important;
            left: 70px !important;
            transition: all 0.3s ease !important;
            padding-top: 90px !important;
        }

        /* Main content when sidebar is expanded */
        .sidebar:not(.close) ~ .main-content {
            width: calc(100% - 250px) !important;
            left: 250px !important;
        }

        /* Mobile Responsiveness for Airbnb Navbar */
        @media (max-width: 950px) {
            .airbnb-search-container {
                display: none !important;
            }
        }

        @media (max-width: 768px) {
            .airbnb-style-navbar {
                padding: 0 20px !important;
                height: 70px !important;
            }

            .panadite-logo-text {
                display: none !important;
            }

            .create-course-link {
                display: none !important;
            }

            .main-content {
                width: 100% !important;
                left: 0 !important;
                padding-top: 80px !important;
            }
        }

        @media (max-width: 480px) {
            .airbnb-style-navbar {
                padding: 0 16px !important;
            }
        }

        /* Navbar Styling - Complete Override */
        .airbnb-style-navbar {
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            height: 80px !important;
            background: #ffffff !important;
            border-bottom: 1px solid #dddddd !important;
            display: flex !important;
            align-items: center !important;
            justify-content: space-between !important;
            padding: 0 40px !important;
            z-index: 1000 !important;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.08) !important;
        }

        /* Left Section - Logo */
        .airbnb-nav-left {
            display: flex !important;
            align-items: center !important;
            flex: 0 0 auto !important;
            gap: 16px !important;
        }

        /* Sidebar Toggle Button */
        .sidebar-toggle-btn {
            width: 40px !important;
            height: 40px !important;
            border: 1px solid #e1e8ff !important;
            background: white !important;
            border-radius: 8px !important;
            cursor: pointer !important;
            color: #4361ee !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            transition: all 0.2s ease !important;
            font-size: 18px !important;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
        }

        .sidebar-toggle-btn:hover {
            background: #f8faff !important;
            border-color: #4361ee !important;
            color: #4361ee !important;
            box-shadow: 0 2px 6px rgba(67, 97, 238, 0.2) !important;
            transform: translateY(-1px) !important;
        }

        .sidebar-toggle-btn:active {
            transform: translateY(0) !important;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
        }

        .panadite-logo {
            display: flex !important;
            align-items: center !important;
            gap: 8px !important;
            text-decoration: none !important;
            color: #4361ee !important;
        }

        .panadite-logo-image {
            height: 45px !important;
            width: auto !important;
            object-fit: contain !important;
            transition: all 0.2s ease !important;
        }

        .panadite-logo:hover .panadite-logo-image {
            transform: scale(1.05) !important;
        }

        /* Center Section - Multi-part Search */
        .airbnb-search-container {
            flex: 1 !important;
            display: flex !important;
            justify-content: center !important;
            max-width: 850px !important;
            margin: 0 auto !important;
        }

        .airbnb-search-bar {
            display: flex !important;
            align-items: center !important;
            background: #ffffff !important;
            border: 1px solid #dddddd !important;
            border-radius: 40px !important;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08) !important;
            transition: all 0.2s ease !important;
            overflow: hidden !important;
        }

        .airbnb-search-bar:hover {
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.12) !important;
        }

        .search-section {
            padding: 14px 24px !important;
            cursor: pointer !important;
            transition: background-color 0.2s ease !important;
            position: relative !important;
            flex: 1 !important;
        }

        .search-section:hover {
            background: #f7f7f7 !important;
        }

        .search-section:first-child {
            border-radius: 40px 0 0 40px !important;
        }

        .search-section:last-of-type {
            border-radius: 0 !important;
            flex: 0.8 !important;
        }

        .search-label {
            font-size: 12px !important;
            font-weight: 600 !important;
            color: #222222 !important;
            margin-bottom: 2px !important;
            text-transform: uppercase !important;
            letter-spacing: 0.04em !important;
        }

        .search-input {
            border: none !important;
            outline: none !important;
            background: transparent !important;
            font-size: 14px !important;
            color: #717171 !important;
            width: 100% !important;
            font-weight: 400 !important;
        }

        .search-input::placeholder {
            color: #717171 !important;
        }

        .search-divider {
            width: 1px !important;
            height: 32px !important;
            background: #dddddd !important;
        }

        .airbnb-search-btn {
            width: 48px !important;
            height: 48px !important;
            background: #ff385c !important;
            border: none !important;
            border-radius: 50% !important;
            color: white !important;
            cursor: pointer !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            margin: 7px !important;
            transition: all 0.2s ease !important;
        }

        .airbnb-search-btn:hover {
            background: #e31c5f !important;
            transform: scale(1.04) !important;
        }

        .airbnb-search-btn i {
            font-size: 16px !important;
        }

        /* Right Section - Menu */
        .airbnb-nav-right {
            display: flex !important;
            align-items: center !important;
            gap: 16px !important;
            flex: 0 0 auto !important;
        }

        .create-course-link {
            font-size: 14px !important;
            font-weight: 600 !important;
            color: #222222 !important;
            text-decoration: none !important;
            padding: 12px 16px !important;
            border-radius: 22px !important;
            transition: all 0.2s ease !important;
        }

        .create-course-link:hover {
            background: #f7f7f7 !important;
            color: #222222 !important;
        }

        .airbnb-icon-btn {
            width: 40px !important;
            height: 40px !important;
            border: none !important;
            background: transparent !important;
            border-radius: 50% !important;
            cursor: pointer !important;
            color: #717171 !important;
            position: relative !important;
            transition: all 0.2s ease !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
        }

        .airbnb-icon-btn:hover {
            background: #f7f7f7 !important;
        }

        .notification-dot {
            position: absolute !important;
            top: 8px !important;
            right: 8px !important;
            background: #ff385c !important;
            color: white !important;
            font-size: 10px !important;
            font-weight: 600 !important;
            min-width: 16px !important;
            height: 16px !important;
            border-radius: 8px !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
        }

        .airbnb-user-menu {
            display: flex !important;
            align-items: center !important;
            gap: 12px !important;
            padding: 6px 6px 6px 12px !important;
            border: 1px solid #dddddd !important;
            border-radius: 21px !important;
            cursor: pointer !important;
            transition: all 0.2s ease !important;
            background: white !important;
        }

        .airbnb-user-menu:hover {
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.18) !important;
        }

        .airbnb-user-menu i {
            color: #717171 !important;
            font-size: 16px !important;
        }

        .user-avatar {
            width: 30px !important;
            height: 30px !important;
            background: #4361ee !important;
            color: white !important;
            border-radius: 50% !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            font-size: 12px !important;
            font-weight: 600 !important;
        }

        /* Dropdown */
        .airbnb-dropdown {
            border: none !important;
            border-radius: 12px !important;
            box-shadow: 0 2px 16px rgba(0, 0, 0, 0.12) !important;
            padding: 8px 0 !important;
            margin-top: 8px !important;
            min-width: 240px !important;
            background: white !important;
        }

        .airbnb-dropdown .dropdown-header {
            padding: 16px !important;
            border-bottom: 1px solid #ebebeb !important;
        }

        .user-info strong {
            display: block !important;
            font-size: 14px !important;
            font-weight: 600 !important;
            color: #222222 !important;
            margin-bottom: 2px !important;
        }

        .user-info span {
            font-size: 14px !important;
            color: #717171 !important;
        }

        .airbnb-dropdown .dropdown-item {
            padding: 12px 16px !important;
            font-size: 14px !important;
            color: #222222 !important;
            text-decoration: none !important;
            transition: background-color 0.2s ease !important;
        }
/* o
        .airbnb-dropdown .dropdown-item:hover {
            background: #f7f7f7 !important;
            color: #222222 !important;
        }

        .airbnb-dropdown .dropdown-divider {
            border-color: #ebebeb !important;
            margin: 8px 0 !important;
        }

        /* Mobile backdrop when sidebar is open */
        .mobile-backdrop {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0,0,0,0.5);
            z-index: 1040;
            }
            
            .mobile-backdrop.show {
                display: block;
            }
            
            /* ULTIMATE MOBILE OVERRIDE - Strongest possible selectors */
            body.mobile-sidebar-overlay .sidebar,
            body.mobile-sidebar-overlay .dashboard-wrapper .sidebar,
            html body.mobile-sidebar-overlay .sidebar {
                position: fixed !important;
                left: 0 !important;
                top: 0 !important;
                transform: translateX(-100%) !important;
                z-index: 1050 !important;
                width: 250px !important;
                margin: 0 !important;
            }
            
            body.mobile-sidebar-overlay .sidebar:not(.close),
            body.mobile-sidebar-overlay .dashboard-wrapper .sidebar:not(.close),
            html body.mobile-sidebar-overlay .sidebar:not(.close) {
                transform: translateX(0) !important;
            }
            
            /* NUCLEAR OVERRIDE: Completely block ALL sidebar effects on main content */
            body.mobile-sidebar-overlay .main-content,
            body.mobile-sidebar-overlay .dashboard-wrapper .main-content,
            body.mobile-sidebar-overlay .home-section,
            html body.mobile-sidebar-overlay .main-content,
            html body.mobile-sidebar-overlay .home-section,
            .mobile-sidebar-overlay .main-content,
            .mobile-sidebar-overlay .dashboard-wrapper .main-content,
            .mobile-sidebar-overlay .home-section {
                margin-left: 0px !important;
                margin-right: 0px !important;
                padding-left: 0px !important;
                padding-right: 0px !important;
                width: 100vw !important;
                max-width: 100vw !important;
                transform: none !important;
                left: 0px !important;
                right: auto !important;
                position: relative !important;
                transition: none !important;
            }
            
            /* NUCLEAR: Override any sidebar state effects */
            body.mobile-sidebar-overlay .sidebar.close ~ .main-content,
            body.mobile-sidebar-overlay .sidebar:not(.close) ~ .main-content,
            body.mobile-sidebar-overlay .sidebar.close ~ .home-section,
            body.mobile-sidebar-overlay .sidebar:not(.close) ~ .home-section,
            .mobile-sidebar-overlay .sidebar.close ~ .main-content,
            .mobile-sidebar-overlay .sidebar:not(.close) ~ .main-content,
            .mobile-sidebar-overlay .sidebar.close ~ .home-section,
            .mobile-sidebar-overlay .sidebar:not(.close) ~ .home-section {
                margin-left: 0px !important;
                width: 100vw !important;
                transform: none !important;
                left: 0px !important;
                transition: none !important;
            }
            
            /* NUCLEAR: Block any dashboard wrapper adjustments */
            body.mobile-sidebar-overlay .dashboard-wrapper,
            .mobile-sidebar-overlay .dashboard-wrapper {
                margin-left: 0px !important;
                padding-left: 0px !important;
                width: 100% !important;
                transform: none !important;
                transition: none !important;
            }
        }

        /* MOBILE ONLY: Prevent main content from being pushed when sidebar opens */
        @media screen and (max-width: 768px) {
            /* CRITICAL: Dashboard wrapper should NEVER change when sidebar opens */
            .dashboard-wrapper:has(.sidebar:not(.close)),
            .dashboard-wrapper {
                margin-left: 0 !important;
                width: 100% !important;
                transform: none !important;
                left: 0 !important;
            }
            
            /* CRITICAL: Main content should NEVER move regardless of sidebar state */
            .dashboard-wrapper:has(.sidebar:not(.close)) .main-content,
            .dashboard-wrapper:has(.sidebar.close) .main-content,
            .dashboard-wrapper .main-content {
                margin-left: 0 !important;
                width: 100% !important;
                transform: none !important;
                left: 0 !important;
                position: relative !important;
            }
        }
        
        /* MOBILE ONLY: NUCLEAR OVERRIDE for sidebar overlay behavior */
        @media screen and (max-width: 768px) {
            /* STRONGEST: Mobile sidebar as fixed overlay with maximum specificity */
            html body .dashboard-wrapper .sidebar,
            html body div.dashboard-wrapper .sidebar,
            body .dashboard-wrapper .sidebar,
            .dashboard-wrapper .sidebar,
            body .sidebar,
            .sidebar {
                position: fixed !important;
                left: 0 !important;
                top: 0 !important;
                height: 100vh !important;
                width: 250px !important;
                z-index: 1050 !important;
                transform: translateX(-100%) !important;
                transition: transform 0.3s ease !important;
                box-shadow: 2px 0 15px rgba(0,0,0,0.2) !important;
                margin-left: 0 !important;
                margin-right: 0 !important;
            }
            
            /* STRONGEST: When sidebar is open on mobile */
            html body .dashboard-wrapper .sidebar:not(.close),
            html body div.dashboard-wrapper .sidebar:not(.close),
            body .dashboard-wrapper .sidebar:not(.close),
            .dashboard-wrapper .sidebar:not(.close),
            body .sidebar:not(.close),
            .sidebar:not(.close) {
                transform: translateX(0) !important;
                left: 0 !important;
            }
            
            /* NUCLEAR: Main content NEVER moves on mobile */
            html body .dashboard-wrapper .main-content,
            html body div.dashboard-wrapper .main-content,
            body .dashboard-wrapper .main-content,
            .dashboard-wrapper .main-content,
            body .main-content,
            .main-content,
            .home-section {
                margin-left: 0 !important;
                width: 100% !important;
                transform: none !important;
                left: 0 !important;
                padding-left: 15px !important;
                position: relative !important;
            }
            
            /* MOBILE ONLY: Close button for sidebar */
            .mobile-sidebar-close {
                position: absolute;
                top: 15px;
                right: 15px;
                width: 32px;
                height: 32px;
                background: rgba(255, 255, 255, 0.9);
                border: none;
                border-radius: 50%;
                cursor: pointer;
                z-index: 1060;
                font-size: 20px;
                color: #333;
                box-shadow: 0 2px 8px rgba(0,0,0,0.15);
                transition: all 0.2s ease;
                display: none;
                align-items: center;
                justify-content: center;
                line-height: 1;
            }
            
            .mobile-sidebar-close:hover {
                background: rgba(255, 255, 255, 1);
                transform: scale(1.1);
            }
            
            /* Show close button when sidebar is open on mobile */
            .sidebar:not(.close) .mobile-sidebar-close {
                display: flex !important;
            }
            
            /* Force visibility on mobile when sidebar is active */
            @media (max-width: 768px) {
                .sidebar:not(.close) .mobile-sidebar-close {
                    display: flex !important;
                    visibility: visible !important;
                    opacity: 1 !important;
                }
            }
            
            /* MOBILE ONLY: Force dashboard cards to stack vertically - NO side-by-side */
            .row,
            .row-cols-1,
            .row-cols-md-2,
            .cards-row,
            .dashboard-cards-row,
            .activity-wallet-row,
            div[class*="row"] {
                flex-direction: column !important;
                display: block !important;
                gap: 20px !important;
            }
            
            /* Force all card columns to full width on mobile */
            .col,
            .col-6,
            .col-md-6,
            .col-lg-6,
            .cards-row .col-md-6,
            .row .col-md-6,
            .dashboard-cards-row .col-md-6,
            .activity-wallet-row .col-md-6,
            div[class*="col-"] {
                width: 100% !important;
                max-width: 100% !important;
                flex: none !important;
                margin-bottom: 20px !important;
                margin-right: 0 !important;
                margin-left: 0 !important;
                padding-left: 15px !important;
                padding-right: 15px !important;
            }
            
            /* Target specific cards by content */
            .card:has(.card-title),
            .card:has([class*="activity"]),
            .card:has([class*="wallet"]),
            .card {
                margin-bottom: 20px !important;
                width: 100% !important;
                display: block !important;
            }
            
            /* Force any flex containers to block on mobile */
            .d-flex,
            .d-md-flex,
            [style*="display: flex"],
            [style*="display:flex"] {
                display: block !important;
            }
        }
    </style>

    <!-- Sidebar Toggle JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOM loaded - initializing sidebar toggle');
            
            const sidebar = document.querySelector('.sidebar');
            const sidebarToggle = document.querySelector('.sidebar-toggle-btn');
            const mainContent = document.querySelector('.main-content');
            
            console.log('Elements found:', {
                sidebar: !!sidebar,
                sidebarToggle: !!sidebarToggle,
                mainContent: !!mainContent
            });
            
            // Function to toggle sidebar
            function toggleSidebar(e) {
                e.preventDefault();
                e.stopPropagation();
                
                console.log('Sidebar toggle triggered');
                
                if (sidebar) {
                    const isCurrentlyClosed = sidebar.classList.contains('close');
                    console.log('Current state - is closed:', isCurrentlyClosed);
                    
                    // Enhanced toggle with JavaScript enforcement for mobile
                    if (isMobileDevice()) {
                        console.log('Mobile: Overlay toggle with enforcement');
                        
                        // FORCE: Set mobile overlay styles via JavaScript
                        forceMobileOverlayStyles();
                        
                        if (isCurrentlyClosed) {
                            sidebar.classList.remove('close');
                            // FORCE: Inline styles to override any CSS
                            sidebar.style.transform = 'translateX(0)';
                            addMobileBackdrop();
                            console.log('Mobile: Sidebar opened as overlay with JS enforcement');
                        } else {
                            sidebar.classList.add('close');
                            // FORCE: Inline styles to hide
                            sidebar.style.transform = 'translateX(-100%)';
                            removeMobileBackdrop();
                            console.log('Mobile: Sidebar closed with JS enforcement');
                        }
                        
                        // FORCE: Ensure main content stays put
                        forceMobileMainContentPosition();
                        
                        // NUCLEAR: Start continuous monitoring to prevent any movement
                        startContentLockMonitoring();
                        
                        // Add mobile close button when sidebar opens
                        addMobileCloseButton();
                        
                    } else {
                        console.log('Desktop: Normal toggle');
                        
                        // Desktop: Clear any mobile inline styles and toggle normally
                        sidebar.style.transform = '';
                        sidebar.style.position = '';
                        sidebar.style.zIndex = '';
                        
                        if (isCurrentlyClosed) {
                            sidebar.classList.remove('close');
                        } else {
                            sidebar.classList.add('close');
                        }
                    }
                    
                    // Force mobile overlay styles via JavaScript
                    function forceMobileOverlayStyles() {
                        if (!isMobileDevice() || !sidebar) return;
                        
                        // NUCLEAR: Set styles directly via JavaScript
                        sidebar.style.position = 'fixed';
                        sidebar.style.left = '0';
                        sidebar.style.top = '0';
                        sidebar.style.height = '100vh';
                        sidebar.style.width = '250px';
                        sidebar.style.zIndex = '1050';
                        sidebar.style.transition = 'transform 0.3s ease';
                        sidebar.style.boxShadow = '2px 0 15px rgba(0,0,0,0.2)';
                        
                        console.log('Mobile: Forced sidebar overlay styles via JS');
                    }
                    
                    // Force main content to stay in position on mobile
                    function forceMobileMainContentPosition() {
                        if (!isMobileDevice()) return;
                        
                        const mainContent = document.querySelector('.main-content');
                        const dashboardWrapper = document.querySelector('.dashboard-wrapper');
                        
                        if (mainContent) {
                            mainContent.style.setProperty('margin-left', '0px', 'important');
                            mainContent.style.setProperty('width', '100%', 'important');
                            mainContent.style.setProperty('transform', 'none', 'important');
                            mainContent.style.setProperty('left', '0px', 'important');
                            mainContent.style.setProperty('position', 'relative', 'important');
                            console.log('Mobile: Forced main content position via JS');
                        }
                        
                        if (dashboardWrapper) {
                            dashboardWrapper.style.setProperty('margin-left', '0px', 'important');
                            dashboardWrapper.style.setProperty('width', '100%', 'important');
                            dashboardWrapper.style.setProperty('transform', 'none', 'important');
                            console.log('Mobile: Forced dashboard wrapper position via JS');
                        }
                    }
                    
                    // NUCLEAR: Continuous monitoring to prevent ANY content movement
                    let contentLockInterval;
                    function startContentLockMonitoring() {
                        if (!isMobileDevice()) return;
                        
                        // Clear any existing interval
                        if (contentLockInterval) {
                            clearInterval(contentLockInterval);
                        }
                        
                        console.log('Mobile: Starting nuclear content lock monitoring...');
                        
                        // Monitor every 50ms and force position
                        contentLockInterval = setInterval(() => {
                            const mainContent = document.querySelector('.main-content');
                            const dashboardWrapper = document.querySelector('.dashboard-wrapper');
                            
                            if (mainContent) {
                                const computedStyle = window.getComputedStyle(mainContent);
                                const marginLeft = computedStyle.marginLeft;
                                const transform = computedStyle.transform;
                                
                                // If content has been moved, force it back immediately
                                if (marginLeft !== '0px' || (transform !== 'none' && transform !== 'matrix(1, 0, 0, 1, 0, 0)')) {
                                    console.log('🚨 DETECTED CONTENT MOVEMENT - FORCING BACK!');
                                    console.log('Current marginLeft:', marginLeft, 'transform:', transform);
                                    
                                    mainContent.style.setProperty('margin-left', '0px', 'important');
                                    mainContent.style.setProperty('width', '100%', 'important');
                                    mainContent.style.setProperty('transform', 'none', 'important');
                                    mainContent.style.setProperty('left', '0px', 'important');
                                }
                            }
                            
                            if (dashboardWrapper) {
                                const wrapperStyle = window.getComputedStyle(dashboardWrapper);
                                if (wrapperStyle.marginLeft !== '0px') {
                                    console.log('🚨 DETECTED WRAPPER MOVEMENT - FORCING BACK!');
                                    dashboardWrapper.style.setProperty('margin-left', '0px', 'important');
                                    dashboardWrapper.style.setProperty('width', '100%', 'important');
                                }
                            }
                        }, 50);
                        
                        console.log('Mobile: Nuclear monitoring active - checking every 50ms');
                    }
                    
                    // Add mobile close button to sidebar
                    function addMobileCloseButton() {
                        console.log('Attempting to add mobile close button...');
                        console.log('isMobileDevice():', isMobileDevice());
                        console.log('sidebar exists:', !!sidebar);
                        
                        if (!isMobileDevice()) {
                            console.log('Not mobile device - skipping close button');
                            return;
                        }
                        
                        if (!sidebar) {
                            console.log('Sidebar not found - cannot add close button');
                            return;
                        }
                        
                        // Check if close button already exists
                        let closeButton = sidebar.querySelector('.mobile-sidebar-close');
                        console.log('Existing close button found:', !!closeButton);
                        
                        if (!closeButton) {
                            console.log('Creating new close button...');
                            
                            // Create close button
                            closeButton = document.createElement('button');
                            closeButton.className = 'mobile-sidebar-close';
                            closeButton.innerHTML = '×';
                            closeButton.setAttribute('aria-label', 'Close sidebar');
                            closeButton.style.display = 'none'; // Start hidden
                            
                            console.log('Close button created with class:', closeButton.className);
                            
                            // Add click handler
                            closeButton.addEventListener('click', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                
                                console.log('Close button clicked!');
                                
                                // Close sidebar
                                sidebar.classList.add('close');
                                sidebar.style.transform = 'translateX(-100%)';
                                removeMobileBackdrop();
                                
                                // Update toggle icon
                                const toggleIcon = sidebarToggle?.querySelector('i');
                                if (toggleIcon) {
                                    toggleIcon.className = 'bx bx-menu';
                                }
                                
                                console.log('Mobile: Sidebar closed via close button');
                            });
                            
                            // Add button to sidebar
                            sidebar.appendChild(closeButton);
                            console.log('Close button added to sidebar successfully');
                            console.log('Sidebar children count:', sidebar.children.length);
                            
                            // Verify it was added
                            const addedButton = sidebar.querySelector('.mobile-sidebar-close');
                            console.log('Verification - button found after adding:', !!addedButton);
                            
                        } else {
                            console.log('Close button already exists, skipping creation');
                        }
                    }
                    
                    // Update toggle button icon - keep simple
                    const toggleIcon = sidebarToggle.querySelector('i');
                    if (toggleIcon) {
                        if (sidebar.classList.contains('close')) {
                            toggleIcon.className = 'bx bx-menu';
                        } else {
                            toggleIcon.className = 'bx bx-x';
                        }
                    }
                    
                    console.log('New state - has close class:', sidebar.classList.contains('close'));
                }
            }
            
            // Simple mobile content helper - no desktop interference
            function ensureMobileOverlay() {
                // Only for mobile - no desktop modifications
                if (!isMobileDevice()) return;
                
                console.log('Mobile: Ensuring overlay mode');
                // Mobile-specific logic can go here if needed
            }
            
            // CLEAN: All desktop-interfering code completely removed
            
            // Add mobile backdrop
            function addMobileBackdrop() {
                if (isMobileDevice()) {
                    let backdrop = document.querySelector('.mobile-backdrop');
                    if (!backdrop) {
                        backdrop = document.createElement('div');
                        backdrop.className = 'mobile-backdrop';
                        document.body.appendChild(backdrop);
                        
                        // Click backdrop to close sidebar
                        backdrop.addEventListener('click', function() {
                            sidebar.classList.add('close');
                            removeMobileBackdrop();
                            
                            const toggleIcon = sidebarToggle?.querySelector('i');
                            if (toggleIcon) {
                                toggleIcon.className = 'bx bx-menu';
                            }
                        });
                    }
                    backdrop.classList.add('show');
                }
            }
            
            // Remove mobile backdrop
            function removeMobileBackdrop() {
                const backdrop = document.querySelector('.mobile-backdrop');
                if (backdrop) {
                    backdrop.classList.remove('show');
                }
            }
            
            // Add event listener to the toggle button
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', toggleSidebar);
                console.log('Toggle event listener added to navbar button');
            } else {
                console.error('Required elements not found:', {
                    sidebarToggle: sidebarToggle,
                    sidebar: sidebar
                });
            }
            
            // Test function - you can call this in browser console
            window.testSidebarToggle = function() {
                if (sidebar) {
                    const wasCollapsed = sidebar.classList.contains('close');
                    sidebar.classList.toggle('close');
                    console.log('Manual test - was collapsed:', wasCollapsed, 'now collapsed:', sidebar.classList.contains('close'));
                } else {
                    console.log('Sidebar element not found');
                }
            };
            
            // Mobile detection and responsive behavior
            function isMobileDevice() {
                return window.innerWidth <= 768 || /Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
            }
            
            // Force initial state - ensure sidebar starts completely hidden on mobile
            if (sidebar) {
                // Always start with sidebar closed
                sidebar.classList.add('close');
                console.log('Initial state - sidebar closed');
                
                // Update toggle button icon for initial closed state
                const toggleIcon = sidebarToggle.querySelector('i');
                if (toggleIcon) {
                    toggleIcon.className = 'bx bx-menu';
                }
                
                // On mobile, ensure proper overlay setup and force correct positioning
                if (isMobileDevice()) {
                    console.log('Mobile device detected - configuring overlay mode');
                    forceMobileContentPosition();
                    
                    // Start continuous monitoring to prevent any content movement
                    startMobileContentMonitoring();
                    
                    // Create mobile close button immediately
                    addMobileCloseButton();
                }
            }
            
            // Handle window resize to manage mobile behavior
            window.addEventListener('resize', function() {
                if (sidebar) {
                    if (isMobileDevice()) {
                        // Always close sidebar on mobile and when resizing to mobile
                        sidebar.classList.add('close');
                        console.log('Resized to mobile - sidebar closed');
                        
                        // Update toggle icon to hamburger menu
                        const toggleIcon = sidebarToggle?.querySelector('i');
                        if (toggleIcon) {
                            toggleIcon.className = 'bx bx-menu';
                        }
                    }
                }
            });
            
            // Close sidebar when clicking outside on mobile
            document.addEventListener('click', function(e) {
                if (isMobileDevice() && sidebar && !sidebar.classList.contains('close')) {
                    // Check if click is outside sidebar and not on toggle button
                    if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                        sidebar.classList.add('close');
                        console.log('Clicked outside - sidebar closed on mobile');
                        
                        // Update toggle icon
                        const toggleIcon = sidebarToggle?.querySelector('i');
                        if (toggleIcon) {
                            toggleIcon.className = 'bx bx-menu';
                        }
                    }
                }
            });
        });
    </script>
    
    <!-- Global Notification Badge Management -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize global navbar badge update functionality
        initGlobalNotificationBadge();
    });

    // Global notification badge management
    function initGlobalNotificationBadge() {
        // Update navbar badge immediately on page load
        updateGlobalNavbarBadge();
        
        // Set up interval to update badge every 30 seconds on all pages
        setInterval(updateGlobalNavbarBadge, 30000);
        
        console.log('🔔 Global navbar badge polling initialized');
    }

    function updateGlobalNavbarBadge() {
        // Only run if we're not on the notifications page (to avoid duplicate polling)
        if (window.location.pathname.includes('notifications.php')) {
            return;
        }
        
        fetch('notifications.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'action=get_new_notifications'
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const navbarBadge = document.querySelector('.nav-icon-btn .notification-badge');
                if (navbarBadge) {
                    const currentCount = parseInt(navbarBadge.textContent) || 0;
                    const newCount = data.unread_count;
                    
                    navbarBadge.textContent = newCount;
                    navbarBadge.style.display = newCount > 0 ? 'inline-block' : 'none';
                    
                    // Add subtle animation when count increases
                    if (newCount > currentCount && newCount > 0) {
                        navbarBadge.style.animation = 'pulse 0.5s ease-in-out';
                        setTimeout(() => {
                            navbarBadge.style.animation = '';
                        }, 500);
                        console.log(`📬 Notification count updated: ${currentCount} → ${newCount}`);
                    }
                }
            }
        })
        .catch(error => {
            // Silently handle errors to avoid console spam
        });
    }

    // CSS for pulse animation
    const style = document.createElement('style');
    style.textContent = `
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.2); }
            100% { transform: scale(1); }
        }
    `;
    document.head.appendChild(style);
    </script>
</head>
<body>
    <div class="dashboard-wrapper">
        <!-- Sidebar Component -->
        <?php include_once __DIR__ . '/sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Navbar Component -->
            <?php include_once __DIR__ . '/navbar.php'; ?>
            
            <!-- Page Content Container - Without container-fluid to prevent double padding -->
            <div class="page-content">
                <!-- Content will be added by including page -->
