<?php
// Include database connection
include_once "../config/db_connect.php";
include_once "../includes/functions.php";

// SQL to create videos table
$sql = "CREATE TABLE IF NOT EXISTS `videos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `file_path` varchar(255) NOT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `duration` varchar(10) DEFAULT NULL,
  `duration_seconds` int(11) DEFAULT NULL,
  `module_order` varchar(50) DEFAULT NULL,
  `teacher_id` int(11) NOT NULL,
  `upload_date` datetime NOT NULL,
  `visibility` enum('public','private') NOT NULL DEFAULT 'public',
  `course_id` int(11) DEFAULT NULL,
  `views` int(11) NOT NULL DEFAULT 0,
  `status` enum('active','inactive','processing') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `teacher_id` (`teacher_id`),
  KEY `course_id` (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;";

// Execute query
if ($conn->query($sql) === TRUE) {
    echo "Videos table created successfully";
    
    // Create uploads directories if they don't exist
    $videoDir = "../uploads/videos";
    $thumbDir = "../uploads/thumbnails";
    
    if (!is_dir($videoDir)) {
        mkdir($videoDir, 0755, true);
        echo "<br>Created videos upload directory";
    }
    
    if (!is_dir($thumbDir)) {
        mkdir($thumbDir, 0755, true);
        echo "<br>Created thumbnails upload directory";
    }
} else {
    echo "Error creating videos table: " . $conn->error;
}

$conn->close();

echo "<br><br><a href='upload-video.php'>Return to Upload Video</a>";
?>
