            <!-- Welcome Banner -->
            <div class="welcome-banner">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <h2>Welcome back, <?php echo htmlspecialchars($teacher['first_name']); ?>!</h2>
                        <p>Here's what's happening with your courses today.</p>
                        <div class="d-flex flex-wrap gap-2 mt-3">
                            <a href="create-course.php" class="btn btn-light">
                                <i class="fas fa-plus me-2"></i> Create Course
                            </a>
                            <a href="upload-video.php" class="btn btn-outline-light">
                                <i class="fas fa-video me-2"></i> Upload Video
                            </a>
                        </div>
                    </div>
                    <div class="col-md-4 d-none d-md-block text-end">
                        <!-- Decorative illustration or icon -->
                        <i class="fas fa-chalkboard-teacher fa-5x text-white opacity-50"></i>
                    </div>
                </div>
            </div>
            
            <!-- Stats Cards -->
            <div class="row g-3 mb-4">
                <!-- Students Card -->
                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="stat-card">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon">
                                <i class="fas fa-user-graduate text-primary"></i>
                            </div>
                            <div>
                                <small class="text-muted text-uppercase">Students</small>
                            </div>
                        </div>
                        <div class="stat-number"><?php echo $student_count; ?></div>
                        <div class="text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>12.5%</span>
                            <small class="text-muted ms-1">this month</small>
                        </div>
                    </div>
                </div>
                
                <!-- Courses Card -->
                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="stat-card">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon" style="background-color: rgba(40, 167, 69, 0.1);">
                                <i class="fas fa-graduation-cap text-success"></i>
                            </div>
                            <div>
                                <small class="text-muted text-uppercase">Courses</small>
                            </div>
                        </div>
                        <div class="stat-number"><?php echo $course_count; ?></div>
                        <div class="text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>8.3%</span>
                            <small class="text-muted ms-1">this month</small>
                        </div>
                    </div>
                </div>
                
                <!-- Videos Card -->
                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="stat-card">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon" style="background-color: rgba(23, 162, 184, 0.1);">
                                <i class="fas fa-video text-info"></i>
                            </div>
                            <div>
                                <small class="text-muted text-uppercase">Videos</small>
                            </div>
                        </div>
                        <div class="stat-number"><?php echo $video_count; ?></div>
                        <div class="text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>15.0%</span>
                            <small class="text-muted ms-1">this month</small>
                        </div>
                    </div>
                </div>
                
                <!-- Earnings Card -->
                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="stat-card">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon" style="background-color: rgba(255, 193, 7, 0.1);">
                                <i class="fas fa-dollar-sign text-warning"></i>
                            </div>
                            <div>
                                <small class="text-muted text-uppercase">Earnings</small>
                            </div>
                        </div>
                        <div class="stat-number">$1,254</div>
                        <div class="text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>5.2%</span>
                            <small class="text-muted ms-1">this month</small>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tables and Charts -->
            <div class="row mb-4">
                <!-- Recent Courses -->
                <div class="col-12 col-lg-6">
                    <div class="data-card h-100">
                        <div class="data-header">
                            <h5 class="data-title">Recent Courses</h5>
                            <a href="courses.php" class="btn btn-sm btn-outline-primary">View All</a>
                        </div>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Course</th>
                                        <th>Students</th>
                                        <th>Rating</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($recent_courses && $recent_courses->num_rows > 0): ?>
                                        <?php while($course = $recent_courses->fetch_assoc()): ?>
                                            <?php 
                                                // Calculate enrolled students
                                                $enrolled_count_query = "SELECT COUNT(*) as count FROM enrollments WHERE course_id = ?";
                                                $stmt = $conn->prepare($enrolled_count_query);
                                                $stmt->bind_param("i", $course['course_id']);
                                                $stmt->execute();
                                                $enrolled_result = $stmt->get_result();
                                                $enrolled_count = $enrolled_result->fetch_assoc()['count'];
                                                
                                                // Check if course is published
                                                $status_class = $course['is_published'] ? 'status-published' : 'status-draft';
                                                $status_text = $course['is_published'] ? 'Published' : 'Draft';
                                            ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <?php if(!empty($course['thumbnail'])): ?>
                                                            <img src="../uploads/courses/<?php echo htmlspecialchars($course['thumbnail']); ?>" 
                                                                 class="rounded me-2" width="40" height="40" alt="<?php echo htmlspecialchars($course['title']); ?>"
                                                                 onerror="this.src='../assets/images/course-placeholder.jpg';">
                                                        <?php else: ?>
                                                            <div class="bg-light rounded me-2 p-2">
                                                                <i class="fas fa-book text-primary"></i>
                                                            </div>
                                                        <?php endif; ?>
                                                        <div>
                                                            <div class="fw-medium"><?php echo htmlspecialchars($course['title']); ?></div>
                                                            <small class="text-muted"><?php echo date('M d, Y', strtotime($course['created_at'])); ?></small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo $enrolled_count; ?></td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <i class="fas fa-star text-warning me-1"></i>
                                                        <span><?php echo number_format($course['rating'] ?? 0, 1); ?></span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="status-badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="4" class="text-center py-4">
                                                <p class="text-muted mb-2">No courses found.</p>
                                                <a href="create-course.php" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-plus me-1"></i> Create your first course
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Videos -->
                <div class="col-12 col-lg-6 mt-4 mt-lg-0">
                    <div class="data-card h-100">
                        <div class="data-header">
                            <h5 class="data-title">Recent Videos</h5>
                            <a href="videos.php" class="btn btn-sm btn-outline-primary">View All</a>
                        </div>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Video</th>
                                        <th>Duration</th>
                                        <th>Views</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($recent_videos && $recent_videos->num_rows > 0): ?>
                                        <?php while($video = $recent_videos->fetch_assoc()): ?>
                                            <?php 
                                                // Check if video is published
                                                $status_class = $video['is_published'] ? 'status-published' : 'status-draft';
                                                $status_text = $video['is_published'] ? 'Published' : 'Draft';
                                            ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <?php if(!empty($video['thumbnail'])): ?>
                                                            <img src="../uploads/videos/<?php echo htmlspecialchars($video['thumbnail']); ?>" 
                                                                 class="rounded me-2" width="40" height="40" alt="<?php echo htmlspecialchars($video['title']); ?>"
                                                                 onerror="this.src='../assets/images/video-placeholder.jpg';">
                                                        <?php else: ?>
                                                            <div class="bg-light rounded me-2 p-2">
                                                                <i class="fas fa-video text-info"></i>
                                                            </div>
                                                        <?php endif; ?>
                                                        <div>
                                                            <div class="fw-medium"><?php echo htmlspecialchars($video['title']); ?></div>
                                                            <small class="text-muted"><?php echo date('M d, Y', strtotime($video['created_at'])); ?></small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo $video['duration'] ?? '00:00'; ?></td>
                                                <td><?php echo number_format($video['views'] ?? 0); ?></td>
                                                <td>
                                                    <span class="status-badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="4" class="text-center py-4">
                                                <p class="text-muted mb-2">No videos found.</p>
                                                <a href="upload-video.php" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-plus me-1"></i> Upload your first video
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Charts -->
            <div class="row mb-4">
                <!-- Course Engagement -->
                <div class="col-12 col-lg-8 mb-4 mb-lg-0">
                    <div class="data-card h-100">
                        <div class="data-header">
                            <h5 class="data-title">Course Engagement</h5>
                            <div class="btn-group btn-group-sm" role="group">
                                <button type="button" class="btn btn-outline-secondary active">Week</button>
                                <button type="button" class="btn btn-outline-secondary">Month</button>
                                <button type="button" class="btn btn-outline-secondary">Year</button>
                            </div>
                        </div>
                        <div class="p-3">
                            <div class="chart-container">
                                <canvas id="engagementChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Student Distribution -->
                <div class="col-12 col-lg-4">
                    <div class="data-card h-100">
                        <div class="data-header">
                            <h5 class="data-title">Student Distribution</h5>
                        </div>
                        <div class="p-3">
                            <div class="chart-container">
                                <canvas id="distributionChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript for Charts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Course Engagement Chart
            var engagementCtx = document.getElementById('engagementChart').getContext('2d');
            var engagementChart = new Chart(engagementCtx, {
                type: 'line',
                data: {
                    labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                    datasets: [{
                        label: 'Course Views',
                        data: [120, 190, 150, 240, 180, 220, 290],
                        backgroundColor: 'rgba(39, 107, 228, 0.1)',
                        borderColor: '#276BE4',
                        borderWidth: 2,
                        pointBackgroundColor: '#276BE4',
                        tension: 0.3,
                        fill: true
                    }, {
                        label: 'Student Activity',
                        data: [80, 120, 90, 160, 100, 140, 200],
                        backgroundColor: 'rgba(40, 167, 69, 0.1)',
                        borderColor: '#28a745',
                        borderWidth: 2,
                        pointBackgroundColor: '#28a745',
                        tension: 0.3,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'top'
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                borderDash: [3, 3]
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
            
            // Student Distribution Chart
            var distributionCtx = document.getElementById('distributionChart').getContext('2d');
            var distributionChart = new Chart(distributionCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Programming', 'Design', 'Marketing', 'Business', 'Other'],
                    datasets: [{
                        data: [35, 25, 20, 15, 5],
                        backgroundColor: [
                            '#276BE4',
                            '#28a745',
                            '#17a2b8',
                            '#ffc107',
                            '#6c757d'
                        ],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%',
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                boxWidth: 12
                            }
                        }
                    },
                    animation: {
                        animateScale: true
                    }
                }
            });
        });
    </script>
</body>
</html>
