<?php
// Debug script to examine assignments database structure
require_once '../config/db_connect.php';

echo "<h2>Assignment Database Analysis</h2>";

// Check if assignments table exists and show structure
echo "<h3>1. Assignments Table Structure</h3>";
try {
    $result = $conn->query("DESCRIBE assignments");
    if ($result) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
        echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>{$row['Field']}</td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "<td>{$row['Extra']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

// Show current assignments data
echo "<h3>2. Current Assignments Records</h3>";
try {
    $result = $conn->query("SELECT * FROM assignments LIMIT 5");
    if ($result && $result->num_rows > 0) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0; width: 100%;'>";
        $first = true;
        while ($row = $result->fetch_assoc()) {
            if ($first) {
                echo "<tr style='background: #f0f0f0;'>";
                foreach (array_keys($row) as $column) {
                    echo "<th>{$column}</th>";
                }
                echo "</tr>";
                $first = false;
            }
            echo "<tr>";
            foreach ($row as $value) {
                echo "<td>" . htmlspecialchars(substr($value, 0, 50)) . (strlen($value) > 50 ? "..." : "") . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No assignments found in database.</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

// Check for assignment submissions table
echo "<h3>3. Assignment Submissions Table</h3>";
try {
    $result = $conn->query("DESCRIBE assignment_submissions");
    if ($result) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
        echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>{$row['Field']}</td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "<td>{$row['Extra']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Assignment submissions table not found: " . $e->getMessage() . "</p>";
}

// List all tables related to assignments
echo "<h3>4. All Assignment-Related Tables</h3>";
try {
    $result = $conn->query("SHOW TABLES LIKE '%assignment%'");
    if ($result) {
        echo "<ul>";
        while ($row = $result->fetch_array()) {
            echo "<li>" . $row[0] . "</li>";
        }
        echo "</ul>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

echo "<h3>5. Recommendations</h3>";
echo "<ul>";
echo "<li>Remove auto-grading features</li>";
echo "<li>Add submission_type field for file types</li>";
echo "<li>Add timing fields (start_date, end_date)</li>";
echo "<li>Add submission format options</li>";
echo "<li>Create proper assignment_submissions table</li>";
echo "</ul>";
?>
