<?php
// Include database connection
require_once __DIR__ . '/../includes/db_connection.php';

// Check if user is logged in as teacher
session_start();
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'teacher') {
    die('Access denied');
}

$teacher_id = $_SESSION['user_id'];

echo "<h2>🔍 File Path Debug Tool</h2>";
echo "<style>body{font-family:Arial;padding:20px;} .file-item{background:#f5f5f5;padding:10px;margin:10px 0;border-radius:5px;} .success{color:green;} .error{color:red;}</style>";

// Get all submissions for this teacher
$stmt = $conn->prepare("SELECT id, title, file_path, thumbnail_path FROM library_submissions WHERE teacher_id = ? ORDER BY submission_date DESC");
$stmt->bind_param("i", $teacher_id);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    echo "<div class='file-item'>";
    echo "<h3>📄 " . htmlspecialchars($row['title']) . " (ID: {$row['id']})</h3>";
    
    // Check document file
    echo "<h4>Document File:</h4>";
    echo "<strong>DB Path:</strong> " . htmlspecialchars($row['file_path']) . "<br>";
    
    $full_path = __DIR__ . '/../' . $row['file_path'];
    echo "<strong>Full Server Path:</strong> " . $full_path . "<br>";
    echo "<strong>File Exists:</strong> " . (file_exists($full_path) ? "<span class='success'>✅ YES</span>" : "<span class='error'>❌ NO</span>") . "<br>";
    
    $web_path = "../" . $row['file_path'];
    echo "<strong>Web Path:</strong> <a href='{$web_path}' target='_blank'>{$web_path}</a><br>";
    
    // Check thumbnail
    if (!empty($row['thumbnail_path'])) {
        echo "<h4>Thumbnail:</h4>";
        echo "<strong>DB Path:</strong> " . htmlspecialchars($row['thumbnail_path']) . "<br>";
        
        $thumb_full_path = __DIR__ . '/../' . $row['thumbnail_path'];
        echo "<strong>Full Server Path:</strong> " . $thumb_full_path . "<br>";
        echo "<strong>File Exists:</strong> " . (file_exists($thumb_full_path) ? "<span class='success'>✅ YES</span>" : "<span class='error'>❌ NO</span>") . "<br>";
        
        $thumb_web_path = "../" . $row['thumbnail_path'];
        echo "<strong>Web Path:</strong> <a href='{$thumb_web_path}' target='_blank'>{$thumb_web_path}</a><br>";
        
        if (file_exists($thumb_full_path)) {
            echo "<strong>Preview:</strong><br>";
            echo "<img src='{$thumb_web_path}' style='max-width:100px;max-height:100px;border:1px solid #ccc;' onerror=\"this.style.display='none'; this.nextSibling.style.display='block';\">";
            echo "<span style='display:none;color:red;'>❌ Image failed to load</span><br>";
        }
    } else {
        echo "<h4>Thumbnail:</h4>";
        echo "<span class='error'>❌ No thumbnail uploaded</span><br>";
    }
    
    echo "</div>";
}

$stmt->close();

// Check upload directory
echo "<div class='file-item'>";
echo "<h3>📁 Upload Directory Status</h3>";
$upload_dir = __DIR__ . '/../uploads/library_submissions/';
echo "<strong>Upload Directory:</strong> " . $upload_dir . "<br>";
echo "<strong>Directory Exists:</strong> " . (is_dir($upload_dir) ? "<span class='success'>✅ YES</span>" : "<span class='error'>❌ NO</span>") . "<br>";
echo "<strong>Directory Writable:</strong> " . (is_writable($upload_dir) ? "<span class='success'>✅ YES</span>" : "<span class='error'>❌ NO</span>") . "<br>";

if (is_dir($upload_dir)) {
    $files = scandir($upload_dir);
    $files = array_filter($files, function($f) { return $f !== '.' && $f !== '..'; });
    echo "<strong>Files in Directory:</strong> " . count($files) . "<br>";
    
    if (count($files) > 0) {
        echo "<strong>Recent Files:</strong><br>";
        foreach (array_slice($files, -5) as $file) {
            $file_path = $upload_dir . $file;
            $size = file_exists($file_path) ? number_format(filesize($file_path) / 1024, 1) . ' KB' : 'Unknown';
            echo "• {$file} ({$size})<br>";
        }
    }
}
echo "</div>";
?>
