<?php
// Set current page for active menu highlighting
$current_page = 'debug_profile_columns.php';

// Include the centralized teacher layout
require_once __DIR__ . '/components/teacher_layout.php';

// Enable error reporting during development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>

<!-- Main Content -->
<div class="main-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h2 class="mb-0">🔧 Teacher Profile Database Analysis</h2>
                    </div>
                    <div class="card-body">

<?php
$user_id = $_SESSION['user_id'];

echo "<div class='alert alert-info'>";
echo "🎯 <strong>Current Teacher:</strong> User ID $user_id (" . ($_SESSION['first_name'] ?? 'Unknown') . " " . ($_SESSION['last_name'] ?? 'Unknown') . ")";
echo "</div>";

// ========================================
// 1. USERS TABLE ANALYSIS
// ========================================
echo "<h3>📋 1. USERS Table Structure & Data</h3>";

echo "<h4>📊 Column Structure:</h4>";
$userColumns = $conn->query("SHOW COLUMNS FROM users");
if ($userColumns) {
    echo "<div class='table-responsive mb-4'>";
    echo "<table class='table table-bordered table-sm'>";
    echo "<tr class='table-info'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    while ($col = $userColumns->fetch_assoc()) {
        echo "<tr>";
        echo "<td><strong>" . $col['Field'] . "</strong></td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?: 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table></div>";
}

echo "<h4>📋 Current User Data:</h4>";
$userQuery = "SELECT * FROM users WHERE user_id = ?";
$stmt = $conn->prepare($userQuery);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($userData = $result->fetch_assoc()) {
    echo "<div class='table-responsive mb-4'>";
    echo "<table class='table table-bordered table-sm'>";
    echo "<tr class='table-success'><th>Field</th><th>Value</th></tr>";
    foreach ($userData as $field => $value) {
        if ($field !== 'password') {
            $displayValue = $value ?: '<span class="text-muted">NULL</span>';
            echo "<tr><td><strong>$field</strong></td><td>$displayValue</td></tr>";
        }
    }
    echo "</table></div>";
}

// ========================================
// 2. TEACHERS TABLE ANALYSIS
// ========================================
echo "<h3>🎓 2. TEACHERS Table Structure & Data</h3>";

// Check if teachers table exists
$teachersTableCheck = $conn->query("SHOW TABLES LIKE 'teachers'");
if ($teachersTableCheck && $teachersTableCheck->num_rows > 0) {
    echo "<div class='alert alert-success'>✅ Teachers table EXISTS</div>";
    
    echo "<h4>📊 Column Structure:</h4>";
    $teacherColumns = $conn->query("SHOW COLUMNS FROM teachers");
    if ($teacherColumns) {
        echo "<div class='table-responsive mb-4'>";
        echo "<table class='table table-bordered table-sm'>";
        echo "<tr class='table-info'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($col = $teacherColumns->fetch_assoc()) {
            echo "<tr>";
            echo "<td><strong>" . $col['Field'] . "</strong></td>";
            echo "<td>" . $col['Type'] . "</td>";
            echo "<td>" . $col['Null'] . "</td>";
            echo "<td>" . $col['Key'] . "</td>";
            echo "<td>" . ($col['Default'] ?: 'NULL') . "</td>";
            echo "</tr>";
        }
        echo "</table></div>";
    }
    
    // Check if teacher record exists
    $teacherQuery = "SELECT * FROM teachers WHERE user_id = ?";
    $stmt2 = $conn->prepare($teacherQuery);
    $stmt2->bind_param("i", $user_id);
    $stmt2->execute();
    $result2 = $stmt2->get_result();
    
    if ($teacherData = $result2->fetch_assoc()) {
        echo "<div class='alert alert-success'>✅ Teacher record EXISTS for user $user_id</div>";
        echo "<h4>📋 Current Teacher Data:</h4>";
        echo "<div class='table-responsive mb-4'>";
        echo "<table class='table table-bordered table-sm'>";
        echo "<tr class='table-warning'><th>Field</th><th>Value</th></tr>";
        foreach ($teacherData as $field => $value) {
            $displayValue = $value ?: '<span class="text-muted">NULL</span>';
            echo "<tr><td><strong>$field</strong></td><td>$displayValue</td></tr>";
        }
        echo "</table></div>";
    } else {
        echo "<div class='alert alert-danger'>❌ NO teacher record exists for user $user_id</div>";
        echo "<div class='alert alert-warning'>⚠️ This means social links cannot be saved!</div>";
    }
} else {
    echo "<div class='alert alert-danger'>❌ Teachers table does NOT exist</div>";
}

// ========================================
// 3. TEACHER_PROFILES TABLE ANALYSIS
// ========================================
echo "<h3>📝 3. TEACHER_PROFILES Table Structure & Data</h3>";

$profilesTableCheck = $conn->query("SHOW TABLES LIKE 'teacher_profiles'");
if ($profilesTableCheck && $profilesTableCheck->num_rows > 0) {
    echo "<div class='alert alert-success'>✅ Teacher_profiles table EXISTS</div>";
    
    echo "<h4>📊 Column Structure:</h4>";
    $profileColumns = $conn->query("SHOW COLUMNS FROM teacher_profiles");
    if ($profileColumns) {
        echo "<div class='table-responsive mb-4'>";
        echo "<table class='table table-bordered table-sm'>";
        echo "<tr class='table-info'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($col = $profileColumns->fetch_assoc()) {
            echo "<tr>";
            echo "<td><strong>" . $col['Field'] . "</strong></td>";
            echo "<td>" . $col['Type'] . "</td>";
            echo "<td>" . $col['Null'] . "</td>";
            echo "<td>" . $col['Key'] . "</td>";
            echo "<td>" . ($col['Default'] ?: 'NULL') . "</td>";
            echo "</tr>";
        }
        echo "</table></div>";
    }
} else {
    echo "<div class='alert alert-warning'>⚠️ Teacher_profiles table does NOT exist</div>";
}

// ========================================
// 4. PROFILE UPDATE ANALYSIS
// ========================================
echo "<h3>🔧 4. Profile Update Requirements Analysis</h3>";

echo "<h4>📋 Form Fields vs Database Columns Mapping:</h4>";
$formFields = [
    'first_name' => ['table' => 'users', 'column' => 'first_name', 'required' => true],
    'last_name' => ['table' => 'users', 'column' => 'last_name', 'required' => true],
    'email' => ['table' => 'users', 'column' => 'email', 'required' => true],
    'bio' => ['table' => 'users', 'column' => 'bio', 'required' => false],
    'phone/cell' => ['table' => 'users', 'column' => 'cell_number', 'required' => false],
    'website' => ['table' => 'teachers', 'column' => 'website', 'required' => false],
    'social_linkedin' => ['table' => 'teachers', 'column' => 'social_linkedin', 'required' => false],
    'social_twitter' => ['table' => 'teachers', 'column' => 'social_twitter', 'required' => false],
    'profile_picture' => ['table' => 'users', 'column' => 'profile_picture', 'required' => false],
];

echo "<div class='table-responsive mb-4'>";
echo "<table class='table table-bordered'>";
echo "<tr class='table-primary'><th>Form Field</th><th>Target Table</th><th>Column Name</th><th>Status</th></tr>";

foreach ($formFields as $field => $info) {
    $table = $info['table'];
    $column = $info['column'];
    
    // Check if column exists
    $columnCheck = $conn->query("SHOW COLUMNS FROM $table LIKE '$column'");
    $exists = $columnCheck && $columnCheck->num_rows > 0;
    
    $status = $exists ? 
        "<span class='badge bg-success'>✅ EXISTS</span>" : 
        "<span class='badge bg-danger'>❌ MISSING</span>";
    
    echo "<tr>";
    echo "<td><strong>$field</strong></td>";
    echo "<td>$table</td>";
    echo "<td>$column</td>";
    echo "<td>$status</td>";
    echo "</tr>";
}
echo "</table></div>";

// ========================================
// 5. RECOMMENDATIONS
// ========================================
echo "<h3>💡 5. Recommendations & Next Steps</h3>";

echo "<div class='row'>";

// Check if teacher record exists
$teacherExists = false;
if (isset($teacherData)) {
    $teacherExists = true;
}

if (!$teacherExists) {
    echo "<div class='col-md-6'>";
    echo "<div class='alert alert-danger'>";
    echo "<h5>🚨 CRITICAL: Missing Teacher Record</h5>";
    echo "<p>Social links cannot be saved because no record exists in the 'teachers' table.</p>";
    echo "<button class='btn btn-warning' onclick='createTeacherRecord()'>🛠️ Create Teacher Record</button>";
    echo "</div>";
    echo "</div>";
}

echo "<div class='col-md-6'>";
echo "<div class='alert alert-info'>";
echo "<h5>🔧 Profile Update Strategy</h5>";
echo "<ul>";
echo "<li><strong>Basic Info:</strong> Update 'users' table (name, email, bio, cell_number)</li>";
if ($teacherExists) {
    echo "<li><strong>Social Links:</strong> Update 'teachers' table (website, linkedin, twitter)</li>";
} else {
    echo "<li><strong>Social Links:</strong> Create teacher record first, then update</li>";
}
echo "<li><strong>Profile Picture:</strong> Update 'users' table + file system</li>";
echo "</ul>";
echo "</div>";
echo "</div>";

echo "</div>";

?>

<script>
function createTeacherRecord() {
    if (confirm('This will create a teacher record in the teachers table. Continue?')) {
        fetch('create_teacher_record.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('✅ Teacher record created successfully!');
                location.reload();
            } else {
                alert('❌ Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('❌ Network error: ' + error);
        });
    }
}
</script>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Include the centralized teacher layout end (footer, scripts, etc)
require_once __DIR__ . '/components/teacher_layout_end.php';
?>
