<?php
include_once "../includes/session_start.php";
include_once "../config/db_connect.php";
include_once "../includes/functions.php";
require_once "../auth/functions.php";

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'teacher') {
    header("Location: ../login.php");
    exit;
}

$teacher_id = $_SESSION['user_id'];

// Check if course_id is provided and is numeric
if (!isset($_POST['course_id']) || !is_numeric($_POST['course_id'])) {
    $_SESSION['error_message'] = "Invalid course ID provided.";
    header("Location: courses.php");
    exit;
}

$course_id = (int)$_POST['course_id'];

// Verify this course belongs to the current teacher
$checkQuery = "SELECT course_id FROM courses WHERE course_id = ? AND teacher_id = ?";
$stmt = $conn->prepare($checkQuery);
$stmt->bind_param('ii', $course_id, $teacher_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $_SESSION['error_message'] = "You don't have permission to delete this course.";
    header("Location: courses.php");
    exit;
}

// Log deletion attempt
error_log("Attempting to delete course_id: {$course_id} by teacher_id: {$teacher_id}");

// Delete the course
$deleteQuery = "DELETE FROM courses WHERE course_id = ? AND teacher_id = ?";
$deleteStmt = $conn->prepare($deleteQuery);

if (!$deleteStmt) {
    error_log("Prepare failed for delete query: " . $conn->error);
    $_SESSION['error_message'] = "System error: Could not prepare delete statement.";
    header("Location: courses.php");
    exit;
}

$deleteStmt->bind_param('ii', $course_id, $teacher_id);

if ($deleteStmt->execute()) {
    error_log("Successfully deleted course_id: {$course_id}");
    $_SESSION['success_message'] = "Course has been successfully deleted.";
} else {
    error_log("Failed to delete course_id: {$course_id}. Error: " . $deleteStmt->error);
    $_SESSION['error_message'] = "Failed to delete the course: " . $deleteStmt->error;
}

// Redirect back to courses page
header("Location: courses.php");
exit;
?>
