<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once "../config/db_connect.php";

// Check if we already have categories
$checkResult = $conn->query("SELECT COUNT(*) as count FROM categories");
$row = $checkResult->fetch_assoc();

if ($row['count'] == 0) {
    echo "<h2>Adding default categories...</h2>";
    
    // No categories found, add some defaults
    $sql = "
        INSERT INTO `categories` (`category_name`, `description`) VALUES
        ('Programming', 'Learn to code with various programming languages'),
        ('Mathematics', 'Explore the world of numbers, patterns, and formulas'),
        ('Business', 'Develop business skills and entrepreneurship'),
        ('Science', 'Discover the wonders of the physical and natural world'),
        ('Languages', 'Learn new languages and communication skills'),
        ('Technology', 'Explore cutting-edge tech and digital skills'),
        ('Arts', 'Express yourself through various art forms')
    ";

    if ($conn->query($sql) === TRUE) {
        echo "<p style='color: green;'>Default categories created successfully!</p>";
    } else {
        echo "<p style='color: red;'>Error creating categories: " . $conn->error . "</p>";
    }
} else {
    echo "<h2>Categories already exist in the database</h2>";
}

// Show all categories
$categories = $conn->query("SELECT * FROM categories ORDER BY category_name");
echo "<h3>Current Categories:</h3>";

if ($categories->num_rows > 0) {
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>Name</th><th>Description</th></tr>";
    
    while($row = $categories->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['category_id'] . "</td>";
        echo "<td>" . $row['category_name'] . "</td>";
        echo "<td>" . ($row['description'] ?? '') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<p>You can now <a href='create-course.php'>create a course</a> using one of these categories.</p>";
} else {
    echo "<p>No categories found.</p>";
}
?>
