<?php
// Database modification script to update assignment tables
require_once '../config/db_connect.php';

echo "<h2>Modifying Assignment Database Structure</h2>";
echo "<p>Removing auto-grading features and adding practical submission options...</p>";

try {
    // Start transaction
    $conn->begin_transaction();
    
    echo "<h3>1. Modifying assignments table...</h3>";
    
    // Remove AI and auto-grading related columns from assignments table
    $ai_columns_to_remove = [
        'ai_grading_enabled',
        'pass_mark', 
        'max_attempts',
        'auto_feedback',
        'plagiarism_check',
        'memorandum_content',
        'memorandum_file_path', 
        'memorandum_key_points'
    ];
    
    foreach ($ai_columns_to_remove as $column) {
        $check_column = $conn->query("SHOW COLUMNS FROM assignments LIKE '$column'");
        if ($check_column->num_rows > 0) {
            $conn->query("ALTER TABLE assignments DROP COLUMN $column");
            echo "<p>✓ Removed column: $column</p>";
        }
    }
    
    // Add new practical columns to assignments table
    $new_columns = [
        'submission_type' => "ENUM('file_upload', 'video', 'document', 'image', 'excel', 'pdf', 'presentation', 'code', 'text_entry', 'multiple_files') DEFAULT 'file_upload'",
        'allowed_formats' => "JSON", // Store allowed file formats as JSON array
        'max_file_size' => "INT DEFAULT 50", // Max file size in MB
        'start_date' => "DATETIME NULL",
        'is_published' => "TINYINT(1) DEFAULT 0",
        'grading_rubric' => "TEXT NULL",
        'late_penalty' => "DECIMAL(5,2) DEFAULT 0.00", // Percentage penalty per day late
        'group_assignment' => "TINYINT(1) DEFAULT 0",
        'max_group_size' => "INT DEFAULT 1"
    ];
    
    foreach ($new_columns as $column => $definition) {
        $check_column = $conn->query("SHOW COLUMNS FROM assignments LIKE '$column'");
        if ($check_column->num_rows == 0) {
            $conn->query("ALTER TABLE assignments ADD COLUMN $column $definition");
            echo "<p>✓ Added column: $column</p>";
        }
    }
    
    echo "<h3>2. Modifying assignment_submissions table...</h3>";
    
    // Remove AI-related columns from assignment_submissions table
    $ai_submission_columns = [
        'ai_score',
        'ai_feedback', 
        'similarity_score',
        'plagiarism_score',
        'keyword_match_score',
        'structure_score',
        'quality_score',
        'processing_status',
        'processing_time',
        'review_needed',
        'ai_confidence',
        'extracted_text'
    ];
    
    foreach ($ai_submission_columns as $column) {
        $check_column = $conn->query("SHOW COLUMNS FROM assignment_submissions LIKE '$column'");
        if ($check_column->num_rows > 0) {
            $conn->query("ALTER TABLE assignment_submissions DROP COLUMN $column");
            echo "<p>✓ Removed column: $column from submissions</p>";
        }
    }
    
    // Add practical submission columns
    $new_submission_columns = [
        'submission_type' => "ENUM('file_upload', 'video', 'document', 'image', 'excel', 'pdf', 'presentation', 'code', 'text_entry', 'multiple_files') DEFAULT 'file_upload'",
        'file_paths' => "JSON", // Store multiple file paths as JSON array
        'original_filename' => "VARCHAR(255)",
        'file_size' => "INT", // File size in bytes  
        'is_late' => "TINYINT(1) DEFAULT 0",
        'days_late' => "INT DEFAULT 0",
        'teacher_comments' => "TEXT",
        'graded_at' => "TIMESTAMP NULL",
        'graded_by' => "INT NULL" // Teacher ID who graded
    ];
    
    foreach ($new_submission_columns as $column => $definition) {
        $check_column = $conn->query("SHOW COLUMNS FROM assignment_submissions LIKE '$column'");
        if ($check_column->num_rows == 0) {
            $conn->query("ALTER TABLE assignment_submissions ADD COLUMN $column $definition");
            echo "<p>✓ Added column: $column to submissions</p>";
        }
    }
    
    // Update existing records to set default values
    echo "<h3>3. Updating existing records...</h3>";
    
    // Set default submission_type for existing assignments
    $conn->query("UPDATE assignments SET submission_type = 'file_upload' WHERE submission_type IS NULL");
    $conn->query("UPDATE assignments SET allowed_formats = '[\"pdf\", \"doc\", \"docx\", \"txt\"]' WHERE allowed_formats IS NULL");
    $conn->query("UPDATE assignments SET max_file_size = 50 WHERE max_file_size IS NULL");
    $conn->query("UPDATE assignments SET is_published = 1 WHERE is_published IS NULL"); // Assume existing assignments are published
    
    echo "<p>✓ Updated existing assignment records with default values</p>";
    
    // Commit transaction
    $conn->commit();
    
    echo "<h3 style='color: green;'>✅ Database modification completed successfully!</h3>";
    
    echo "<h3>4. Updated assignments table structure:</h3>";
    $result = $conn->query("DESCRIBE assignments");
    if ($result) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>{$row['Field']}</td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
} catch (Exception $e) {
    // Rollback transaction on error
    $conn->rollback();
    echo "<h3 style='color: red;'>❌ Error: " . $e->getMessage() . "</h3>";
    echo "<p>Database changes have been rolled back.</p>";
}

echo "<h3>5. Next Steps:</h3>";
echo "<ul>";
echo "<li>✅ Database structure updated successfully</li>";
echo "<li>🔄 Now recreating the assignment creation page...</li>";
echo "<li>🔄 Removing all auto-grading features from UI</li>";
echo "<li>🔄 Adding practical submission type selection</li>";
echo "<li>🔄 Adding file format and timing controls</li>";
echo "</ul>";
?>

<style>
body {
    font-family: Arial, sans-serif;
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}
table {
    width: 100%;
    border-collapse: collapse;
}
th, td {
    padding: 8px;
    text-align: left;
    border: 1px solid #ddd;
}
th {
    background-color: #f0f0f0;
}
</style>
