<?php
session_start();
require_once '../includes/config.php';

// Test if we can handle the upload without all the complex validation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['base64data'])) {
    
    echo "<h2>Simple Upload Test</h2>";
    
    // Get the data
    $base64_data = $_POST['base64data'];
    $file_name = $_POST['fileName'] ?? 'test_video.mp4';
    $teacher_id = $_SESSION['user_id'] ?? 12;
    $course_id = $_POST['course_id'] ?? 15;
    $title = $_POST['title'] ?? 'Test Video';
    $description = $_POST['description'] ?? 'Test Description';
    
    echo "<p>Received base64 data: " . strlen($base64_data) . " characters</p>";
    
    // Remove data URI header if present
    if (strpos($base64_data, ',') !== false) {
        $parts = explode(',', $base64_data);
        $base64_data = $parts[1];
        echo "<p>Removed data URI header</p>";
    }
    
    // Decode
    $video_data = base64_decode($base64_data);
    if ($video_data === false) {
        echo "<p><strong>ERROR:</strong> Failed to decode base64</p>";
        exit;
    }
    
    $video_size = strlen($video_data);
    echo "<p>Decoded size: " . $video_size . " bytes (" . round($video_size / 1024 / 1024, 2) . " MB)</p>";
    
    // Create temp file
    $temp_file = tempnam(sys_get_temp_dir(), 'video_upload_');
    if (file_put_contents($temp_file, $video_data) === false) {
        echo "<p><strong>ERROR:</strong> Failed to write temp file</p>";
        exit;
    }
    
    echo "<p>Temporary file created: $temp_file</p>";
    
    // Create upload directory
    $upload_dir = "../uploads/videos/";
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0755, true);
        echo "<p>Created upload directory</p>";
    }
    
    // Move file to final location
    $video_filename = 'video_' . uniqid() . '.mp4';
    $final_path = $upload_dir . $video_filename;
    
    if (rename($temp_file, $final_path)) {
        echo "<p><strong>SUCCESS:</strong> File moved to $final_path</p>";
        
        // Try database insert
        $db_video_url = "uploads/videos/" . $video_filename;
        $duration = $_POST['duration'] ?? '0:30';
        
        $stmt = $conn->prepare("INSERT INTO videos (title, video_url, course_id, teacher_id, description, duration) VALUES (?, ?, ?, ?, ?, ?)");
        
        if ($stmt) {
            $stmt->bind_param('ssiiss', $title, $db_video_url, $course_id, $teacher_id, $description, $duration);
            
            if ($stmt->execute()) {
                $video_id = $conn->insert_id;
                echo "<p><strong>SUCCESS:</strong> Video inserted into database with ID: $video_id</p>";
                echo "<p><a href='../uploads/videos/$video_filename' target='_blank'>View uploaded video</a></p>";
            } else {
                echo "<p><strong>ERROR:</strong> Database insert failed: " . $stmt->error . "</p>";
            }
            $stmt->close();
        } else {
            echo "<p><strong>ERROR:</strong> Failed to prepare statement: " . $conn->error . "</p>";
        }
        
    } else {
        echo "<p><strong>ERROR:</strong> Failed to move file to final location</p>";
    }
    
} else {
    echo "<h2>Simple Upload Test Form</h2>";
    echo "<p>This form will submit to the same simple processing script to test the upload without complex validation.</p>";
    echo '<form action="simple-upload-test.php" method="POST">';
    echo '<input type="hidden" name="base64data" value="">';
    echo '<input type="hidden" name="fileName" value="">';
    echo '<input type="file" id="videoFile" accept="video/*" onchange="handleFile(this.files[0])">';
    echo '<input type="text" name="title" placeholder="Video Title" required>';
    echo '<input type="text" name="course_id" value="15" placeholder="Course ID">';
    echo '<textarea name="description" placeholder="Description"></textarea>';
    echo '<button type="submit">Upload</button>';
    echo '</form>';
    
    echo '<script>
    function handleFile(file) {
        if (!file) return;
        console.log("Processing file:", file.name, file.size);
        
        const reader = new FileReader();
        reader.onload = function(e) {
            document.querySelector("input[name=base64data]").value = e.target.result;
            document.querySelector("input[name=fileName]").value = file.name;
            console.log("Base64 data prepared, length:", e.target.result.length);
        };
        reader.readAsDataURL(file);
    }
    </script>';
}
?>
