<?php
/**
 * Template for all teacher role pages
 * Copy this structure for any new pages or update existing pages to follow this pattern
 */

// Include the centralized teacher layout
require_once __DIR__ . '/components/teacher_layout.php';

// Page-specific PHP code goes here
// For example: database queries, form processing, etc.

// Example: Get some data from database
$example_data = [
    ['id' => 1, 'name' => 'Example Item 1'],
    ['id' => 2, 'name' => 'Example Item 2'],
    ['id' => 3, 'name' => 'Example Item 3'],
];
?>

<!-- Page Content Starts Here -->
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h4 class="card-title">Page Title</h4>
                    <p class="card-text">This is a template page that demonstrates how to use the standardized teacher layout.</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Example Content</h5>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($example_data as $item): ?>
                                <tr>
                                    <td><?= $item['id'] ?></td>
                                    <td><?= $item['name'] ?></td>
                                    <td>
                                        <a href="#" class="btn btn-sm btn-primary"><i class="bx bx-edit"></i></a>
                                        <a href="#" class="btn btn-sm btn-danger"><i class="bx bx-trash"></i></a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Form Example</h5>
                    <form>
                        <div class="mb-3">
                            <label for="exampleInput" class="form-label">Example Input</label>
                            <input type="text" class="form-control" id="exampleInput">
                        </div>
                        <div class="mb-3">
                            <label for="exampleSelect" class="form-label">Example Select</label>
                            <select class="form-select" id="exampleSelect">
                                <option>Option 1</option>
                                <option>Option 2</option>
                                <option>Option 3</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Page Content Ends Here -->

<?php
// Include the centralized teacher layout end
require_once __DIR__ . '/components/teacher_layout_end.php';
?>

<!-- Page-specific scripts go here (after the layout_end.php include) -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('Page-specific script loaded');
    
    // Your page-specific JavaScript code goes here
});
</script>
