<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Use centralized session management instead of direct session_start
require_once "../includes/session_start.php";
require_once "../config/db_connect.php";
require_once "../auth/functions.php";

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'teacher') {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Initialize response
$response = ['success' => false, 'message' => '', 'errors' => []];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check for base64 image data
    if (isset($_POST['image_base64']) && !empty($_POST['image_base64'])) {
        try {
            // Process the base64 string
            $base64_string = $_POST['image_base64'];
            $base64_parts = explode(',', $base64_string);
            
            // If we have a proper base64 encoded image with header
            if (count($base64_parts) > 1) {
                $image_data = base64_decode($base64_parts[1]);
                
                if ($image_data === false) {
                    $response['errors'][] = "Failed to decode base64 image data";
                } else {
                    // Get file extension from mime type in base64 header
                    $file_extension = 'jpg'; // Default
                    if (preg_match('/^data:image\/(jpeg|jpg|png);base64,/', $base64_string, $matches)) {
                        $file_extension = $matches[1];
                    }
                    
                    // Generate a unique filename
                    $upload_dir = "../uploads/test/";
                    if (!file_exists($upload_dir)) {
                        mkdir($upload_dir, 0777, true);
                    }
                    
                    $file_name = 'test_' . time() . '.' . $file_extension;
                    $target_path = $upload_dir . $file_name;
                    
                    // Save the file
                    if (file_put_contents($target_path, $image_data)) {
                        $response['success'] = true;
                        $response['message'] = 'Image uploaded successfully!';
                        $response['file_path'] = $target_path;
                    } else {
                        $response['errors'][] = "Failed to save image file.";
                    }
                }
            } else {
                $response['errors'][] = "Invalid base64 data format";
            }
        } catch (Exception $e) {
            $response['errors'][] = "Error: " . $e->getMessage();
        }
    } else {
        $response['errors'][] = "No image data received";
    }
}

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
