<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quick API Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <h3><i class="fas fa-bolt me-2 text-warning"></i>Quick API Test</h3>
            <p class="text-muted">Testing the fixed video duration APIs</p>
        </div>
    </div>

    <!-- Quick Tests -->
    <div class="row">
        
        <!-- YouTube Test -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-danger text-white">
                    <i class="fab fa-youtube me-2"></i>YouTube (Fixed)
                </div>
                <div class="card-body">
                    <button class="btn btn-danger w-100" onclick="testYouTubeFix()">
                        <i class="fas fa-play me-2"></i>Test Fixed YouTube
                    </button>
                    <div id="ytResult" class="mt-2 p-2 bg-light rounded text-center">
                        Ready to test
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Vimeo Test -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <i class="fab fa-vimeo-v me-2"></i>Vimeo (Fixed)
                </div>
                <div class="card-body">
                    <button class="btn btn-info w-100" onclick="testVimeoFix()">
                        <i class="fas fa-play me-2"></i>Test Fixed Vimeo
                    </button>
                    <div id="vimeoResult" class="mt-2 p-2 bg-light rounded text-center">
                        Ready to test
                    </div>
                </div>
            </div>
        </div>
        
        <!-- TikTok Test -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-dark text-white">
                    <i class="fab fa-tiktok me-2"></i>TikTok (Fixed)
                </div>
                <div class="card-body">
                    <button class="btn btn-dark w-100" onclick="testTikTokFix()">
                        <i class="fas fa-play me-2"></i>Test Fixed TikTok
                    </button>
                    <div id="tiktokResult" class="mt-2 p-2 bg-light rounded text-center">
                        Ready to test
                    </div>
                </div>
            </div>
        </div>
        
    </div>
    
    <!-- Integration Status -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5>Integration Status</h5>
                    <div id="integrationStatus">Checking...</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Instructions -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="alert alert-info">
                <h6><i class="fas fa-info-circle me-2"></i>What's Been Fixed:</h6>
                <ul class="mb-0">
                    <li><strong>YouTube:</strong> Fixed DOM cleanup errors, now works cleanly</li>
                    <li><strong>Vimeo:</strong> Fixed CORS issues using JSONP + Player API fallback</li>
                    <li><strong>TikTok:</strong> Now provides estimated duration (30s) since API is restricted</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="../js/video-api-integration.js"></script>

<script>
// Check integration status
setTimeout(() => {
    const status = document.getElementById('integrationStatus');
    if (window.VideoAPIIntegration) {
        status.innerHTML = '<i class="fas fa-check-circle text-success me-2"></i>API Integration Loaded Successfully';
    } else {
        status.innerHTML = '<i class="fas fa-times-circle text-danger me-2"></i>API Integration Failed to Load';
    }
}, 500);

// Test YouTube with error handling fix
function testYouTubeFix() {
    const result = document.getElementById('ytResult');
    result.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Testing...';
    
    const testUrl = 'https://www.youtube.com/watch?v=vpAJ0s5S2t0';
    
    window.VideoAPIIntegration.getVideoDuration(
        testUrl,
        function(data) {
            result.innerHTML = `<div class="text-success"><i class="fas fa-check me-2"></i><strong>${data.formattedDuration}</strong><br><small>${data.method}</small></div>`;
        },
        function(error) {
            result.innerHTML = `<div class="text-danger"><i class="fas fa-times me-2"></i><strong>Failed</strong><br><small>${error}</small></div>`;
        }
    );
}

// Test Vimeo with CORS fix
function testVimeoFix() {
    const result = document.getElementById('vimeoResult');
    result.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Testing...';
    
    const testUrl = 'https://vimeo.com/76979871';
    
    window.VideoAPIIntegration.getVideoDuration(
        testUrl,
        function(data) {
            result.innerHTML = `<div class="text-success"><i class="fas fa-check me-2"></i><strong>${data.formattedDuration}</strong><br><small>${data.method}</small></div>`;
        },
        function(error) {
            result.innerHTML = `<div class="text-danger"><i class="fas fa-times me-2"></i><strong>Failed</strong><br><small>${error}</small></div>`;
        }
    );
}

// Test TikTok with estimation fix
function testTikTokFix() {
    const result = document.getElementById('tiktokResult');
    result.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Testing...';
    
    const testUrl = 'https://www.tiktok.com/@webdevtips/video/7234567890123456789';
    
    window.VideoAPIIntegration.getVideoDuration(
        testUrl,
        function(data) {
            result.innerHTML = `<div class="text-warning"><i class="fas fa-clock me-2"></i><strong>${data.formattedDuration}</strong><br><small>${data.method}</small></div>`;
        },
        function(error) {
            result.innerHTML = `<div class="text-danger"><i class="fas fa-times me-2"></i><strong>Failed</strong><br><small>${error}</small></div>`;
        }
    );
}
</script>

</body>
</html>
