<?php
session_start();

// Enable error reporting
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include config
require_once '../includes/config.php';

echo "<h2>Upload Debug Test - Enhanced</h2>";
echo "<h3>Server Info:</h3>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>Upload Max Filesize: " . ini_get('upload_max_filesize') . "</p>";
echo "<p>Post Max Size: " . ini_get('post_max_size') . "</p>";
echo "<p>Memory Limit: " . ini_get('memory_limit') . "</p>";
echo "<p>Max File Uploads: " . ini_get('max_file_uploads') . "</p>";
echo "<p>Max Input Time: " . ini_get('max_input_time') . "</p>";
echo "<p>Max Execution Time: " . ini_get('max_execution_time') . "</p>";

// Check if POST data is received
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<h3>REQUEST HEADERS:</h3>";
    echo "<pre>";
    foreach(getallheaders() as $name => $value) {
        echo "$name: $value\n";
    }
    echo "</pre>";
    
    echo "<h3>SERVER Variables:</h3>";
    echo "<p>REQUEST_METHOD: " . $_SERVER['REQUEST_METHOD'] . "</p>";
    echo "<p>CONTENT_TYPE: " . (isset($_SERVER['CONTENT_TYPE']) ? $_SERVER['CONTENT_TYPE'] : 'not set') . "</p>";
    echo "<p>CONTENT_LENGTH: " . (isset($_SERVER['CONTENT_LENGTH']) ? $_SERVER['CONTENT_LENGTH'] : 'not set') . "</p>";
    
    echo "<h3>POST Data Keys:</h3>";
    echo "<pre>";
    print_r(array_keys($_POST));
    echo "</pre>";
    
    echo "<h3>POST Data (excluding base64):</h3>";
    echo "<pre>";
    $post_copy = $_POST;
    if (isset($post_copy['base64data'])) {
        $post_copy['base64data'] = '[BASE64 DATA - ' . strlen($_POST['base64data']) . ' characters]';
    }
    print_r($post_copy);
    echo "</pre>";
    
    echo "<h3>FILES Data:</h3>";
    echo "<pre>";
    print_r($_FILES);
    echo "</pre>";
    
    // Check if base64 data is present
    if (isset($_POST['base64data']) && !empty($_POST['base64data'])) {
        $base64_data = $_POST['base64data'];
        $base64_length = strlen($base64_data);
        echo "<h3>Base64 Data Analysis:</h3>";
        echo "<p><strong>Base64 data length:</strong> $base64_length characters</p>";
        
        // Check if it has data URI header
        if (strpos($base64_data, ',') !== false) {
            $parts = explode(',', $base64_data);
            echo "<p><strong>Data URI header:</strong> " . htmlspecialchars($parts[0]) . "</p>";
            echo "<p><strong>Base64 content length:</strong> " . strlen($parts[1]) . " characters</p>";
            $base64_data = $parts[1];
        }
        
        // Test decode
        $decoded = base64_decode($base64_data, true);
        if ($decoded !== false) {
            $decoded_size = strlen($decoded);
            echo "<p><strong>Base64 decode successful:</strong> $decoded_size bytes</p>";
            echo "<p><strong>File size in MB:</strong> " . round($decoded_size / 1024 / 1024, 2) . " MB</p>";
            
            // Check file signature
            $signature = substr($decoded, 0, 20);
            echo "<p><strong>File signature (hex):</strong> " . bin2hex($signature) . "</p>";
            
            // Try to determine file type
            $finfo = new finfo(FILEINFO_MIME_TYPE);
            $mime_type = $finfo->buffer($decoded);
            echo "<p><strong>Detected MIME type:</strong> " . $mime_type . "</p>";
            
        } else {
            echo "<p><strong>Base64 decode failed!</strong></p>";
        }
    } else {
        echo "<p><strong>No base64 data found!</strong></p>";
    }
    
    echo "<h3>Session Data:</h3>";
    echo "<pre>";
    print_r($_SESSION);
    echo "</pre>";
    
} else {
    echo "<p>No POST data received. This page shows debug info when form is submitted.</p>";
}

// Check database connection and table structure
echo "<h3>Database Check:</h3>";
try {
    $sql = "DESCRIBE videos";
    $result = $conn->query($sql);
    
    if ($result) {
        echo "<p><strong>Videos table structure:</strong></p>";
        echo "<table border='1'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            foreach ($row as $value) {
                echo "<td>" . htmlspecialchars($value) . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p><strong>Error:</strong> " . $conn->error . "</p>";
    }
    
    // Check if user is logged in
    if (isset($_SESSION['user_id'])) {
        echo "<p><strong>User logged in:</strong> ID " . $_SESSION['user_id'] . ", Role: " . ($_SESSION['user_role'] ?? 'not set') . "</p>";
        
        // Check courses for this teacher
        $teacher_id = $_SESSION['user_id'];
        $course_sql = "SELECT course_id, title FROM courses WHERE teacher_id = ?";
        $stmt = $conn->prepare($course_sql);
        if ($stmt) {
            $stmt->bind_param("i", $teacher_id);
            $stmt->execute();
            $course_result = $stmt->get_result();
            
            echo "<p><strong>Available courses for this teacher:</strong></p>";
            if ($course_result->num_rows > 0) {
                echo "<ul>";
                while ($course = $course_result->fetch_assoc()) {
                    echo "<li>ID: " . $course['course_id'] . " - " . htmlspecialchars($course['title']) . "</li>";
                }
                echo "</ul>";
            } else {
                echo "<p>No courses found for this teacher.</p>";
            }
        }
    } else {
        echo "<p><strong>User not logged in!</strong></p>";
    }
    
} catch (Exception $e) {
    echo "<p><strong>Database error:</strong> " . $e->getMessage() . "</p>";
}
?>
