<?php
/**
 * Test Script for Image Viewing
 * Direct test of the download_teacher_feedback.php script
 */

// Include authentication
require_once __DIR__ . '/components/teacher_layout.php';

echo "<h1>🖼️ Image View Test</h1>";

// Test the exact URL that would be generated by JavaScript
$submission_id = 286;  // From your debug info
$file_path = "teacher_feedback_41_15_1761671196_0.jpeg";  // From your debug info

// Construct the exact URL
$download_url = "download_teacher_feedback.php?file=" . urlencode($file_path) . "&submission=" . $submission_id . "&inline=1";

echo "<h3>🔗 Testing Download URL:</h3>";
echo "<p><strong>URL:</strong> <code>$download_url</code></p>";

echo "<h3>📸 Direct Image Test:</h3>";
echo "<p>This should display your WhatsApp image:</p>";
echo "<img src='$download_url' style='max-width: 400px; border: 2px solid #007bff; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);' 
           onerror=\"this.parentElement.innerHTML='<div style=\\'color: red; border: 1px solid red; padding: 10px; border-radius: 5px;\\'>❌ Image failed to load. URL: $download_url</div>'\">";

echo "<h3>🔍 Debug Links:</h3>";
echo "<p><a href='$download_url' target='_blank'>📄 Open image in new tab</a></p>";
echo "<p><a href='download_teacher_feedback.php?file=" . urlencode($file_path) . "&submission=" . $submission_id . "' target='_blank'>💾 Download image (no inline)</a></p>";

echo "<h3>🧪 Test Different URLs:</h3>";

// Test without inline parameter
$url_no_inline = "download_teacher_feedback.php?file=" . urlencode($file_path) . "&submission=" . $submission_id;
echo "<p><strong>Without inline parameter:</strong></p>";
echo "<img src='$url_no_inline' style='max-width: 200px; border: 1px solid gray;' 
           onerror=\"this.parentElement.innerHTML='<span style=\\'color: red;\\'>❌ Failed without inline</span>'\">";

// Test with different inline values
$url_inline_true = "download_teacher_feedback.php?file=" . urlencode($file_path) . "&submission=" . $submission_id . "&inline=true";
echo "<p><strong>With inline=true:</strong></p>";
echo "<img src='$url_inline_true' style='max-width: 200px; border: 1px solid green;' 
           onerror=\"this.parentElement.innerHTML='<span style=\\'color: red;\\'>❌ Failed with inline=true</span>'\">";

echo "<h3>🔧 JavaScript Console Test:</h3>";
echo "<p>Open browser console and run this command:</p>";
echo "<code>console.log('Testing image URL: $download_url');</code>";

echo "<script>
// Test the URL in console
console.log('=== Image View Debug ===');
console.log('Download URL: $download_url');
console.log('Testing image load...');

var testImg = new Image();
testImg.onload = function() {
    console.log('✅ Image loaded successfully!');
    console.log('Width: ' + this.width + 'px, Height: ' + this.height + 'px');
};
testImg.onerror = function() {
    console.log('❌ Image failed to load');
    console.log('URL: $download_url');
    
    // Test without inline parameter
    var testImg2 = new Image();
    testImg2.onload = function() {
        console.log('✅ Image loads WITHOUT inline parameter');
    };
    testImg2.onerror = function() {
        console.log('❌ Image fails even without inline parameter');
    };
    testImg2.src = '$url_no_inline';
};
testImg.src = '$download_url';
</script>";

$conn->close();
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
h1, h3 { color: #333; }
code { background-color: #f4f4f4; padding: 2px 5px; border-radius: 3px; }
img { margin: 10px 0; }
</style>
