<?php
session_start();
require_once 'includes/db_connection.php';

// Include SEO headers with favicon for teaching requirements page
$seo_title = 'Teaching Requirements - Panadite Academy | Instructor Qualification Standards';
$seo_description = 'Discover the requirements to become a Panadite Academy instructor. Learn about qualifications, experience standards, and application process.';
require_once __DIR__ . '/includes/seo_header.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teaching Requirements - Panadite Academy</title>
    <meta name="description" content="Learn about the requirements to become an instructor at Panadite Academy and start your teaching journey.">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #276BE4;
            --primary-amber: #FFA915;
            --dark-text: #2d3748;
            --light-text: #718096;
            --bg-light: #f8fafc;
            --border-color: #e2e8f0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-text);
            background-color: var(--bg-light);
        }
        
        .hero-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: var(--dark-text);
            padding: 4rem 0 3rem;
            margin-bottom: 3rem;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(39, 107, 228, 0.03) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 169, 21, 0.03) 0%, transparent 50%);
            animation: backgroundPulse 8s ease-in-out infinite alternate;
        }
        
        @keyframes backgroundPulse {
            0% { opacity: 0.3; }
            100% { opacity: 0.8; }
        }
        
        .floating-element {
            position: absolute;
            pointer-events: none;
            opacity: 0.1;
        }
        
        .floating-element:nth-child(1) {
            top: 10%;
            left: 10%;
            animation: float1 6s ease-in-out infinite;
        }
        
        .floating-element:nth-child(2) {
            top: 70%;
            right: 15%;
            animation: float2 8s ease-in-out infinite reverse;
        }
        
        .floating-element:nth-child(3) {
            bottom: 20%;
            left: 70%;
            animation: float3 7s ease-in-out infinite;
        }
        
        @keyframes float1 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(30px, -20px) rotate(180deg); }
        }
        
        @keyframes float2 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(-25px, -30px) rotate(-180deg); }
        }
        
        @keyframes float3 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(20px, 25px) rotate(360deg); }
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
        }
        
        .hero-content h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            line-height: 1.2;
            color: var(--dark-text);
            animation: fadeInUp 1s ease-out 0.2s both;
        }
        
        .hero-content p {
            font-size: 1.1rem;
            color: var(--light-text);
            margin-bottom: 2rem;
            max-width: 600px;
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 0.4s both;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .content-section {
            background: white;
            border-radius: 16px;
            padding: 3rem 0;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
        }
        
        .section-card {
            background: white;
            border-radius: 16px;
            padding: 3rem 2.5rem;
            margin-bottom: 3rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
            transition: all 0.3s ease;
            opacity: 0;
            transform: translateY(30px);
            animation: slideInUp 0.6s ease-out forwards;
        }
        
        .section-card:nth-child(1) { animation-delay: 0.1s; }
        .section-card:nth-child(2) { animation-delay: 0.2s; }
        .section-card:nth-child(3) { animation-delay: 0.3s; }
        .section-card:nth-child(4) { animation-delay: 0.4s; }
        
        @keyframes slideInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .section-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--dark-text);
            margin-bottom: 2rem;
            margin-top: 0.5rem;
            display: flex;
            align-items: center;
            padding-left: 0.5rem;
        }
        
        .section-title i {
            background: var(--primary-blue);
            color: white;
            width: 55px;
            height: 55px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1.25rem;
            font-size: 1.4rem;
        }
        
        .requirement-item {
            background: var(--bg-light);
            border-radius: 14px;
            padding: 2rem;
            margin-bottom: 2rem;
            border-left: 4px solid var(--primary-blue);
            transition: all 0.3s ease;
        }
        
        .requirement-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(39, 107, 228, 0.15);
        }
        
        .requirement-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: var(--dark-text);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
        }
        
        .requirement-title i {
            color: var(--primary-blue);
            margin-right: 0.75rem;
            font-size: 1.1rem;
        }
        
        .requirement-description {
            color: var(--light-text);
            font-size: 1rem;
            line-height: 1.6;
        }
        
        .checklist {
            list-style: none;
            padding: 0;
        }
        
        .checklist li {
            padding: 1rem 0;
            display: flex;
            align-items: flex-start;
        }
        
        .checklist li i {
            color: #10b981;
            margin-right: 1rem;
            margin-top: 0.3rem;
            font-size: 1.1rem;
        }
        
        .cta-section {
            background: linear-gradient(135deg, var(--primary-blue), #1e5bcc);
            color: white;
            border-radius: 16px;
            padding: 3rem;
            text-align: center;
            margin-top: 3rem;
        }
        
        .cta-section h2 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        
        .cta-section p {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-bottom: 2rem;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .btn-get-started {
            background: white;
            color: var(--primary-blue);
            padding: 1rem 2rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            font-size: 1.1rem;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-get-started:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            color: var(--primary-blue);
        }
        
        .btn-get-started i {
            margin-left: 0.5rem;
        }
        
        .back-btn {
            background: white;
            color: var(--primary-blue);
            border: 1px solid var(--border-color);
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            margin-bottom: 2rem;
        }
        
        .back-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }
        
        .back-btn i {
            margin-right: 0.5rem;
        }
    </style>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <!-- Hero Section -->
    <section class="hero-section">
        <!-- Floating animated elements -->
        <div class="floating-element">
            <i class="fas fa-graduation-cap" style="font-size: 60px; color: var(--primary-blue);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-book" style="font-size: 45px; color: var(--primary-amber);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-star" style="font-size: 35px; color: #10b981;"></i>
        </div>
        
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1>Teaching Requirements</h1>
                        <p>Learn about the qualifications and requirements needed to become a successful instructor at Panadite Academy and start sharing your expertise with students worldwide.</p>
                    </div>
                </div>
                <div class="col-lg-4 text-center">
                    <div style="background: white; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08); border: 1px solid var(--border-color);">
                        <i class="fas fa-chalkboard-teacher" style="font-size: 3rem; margin-bottom: 1rem; color: var(--primary-blue);"></i>
                        <h4 style="margin: 0; font-weight: 700; color: var(--dark-text);">Start Teaching</h4>
                        <p style="margin: 0.5rem 0 0; color: var(--light-text); font-size: 0.95rem;">Join Our Community</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <div class="container">
        <a href="index.php" class="back-btn">
            <i class="fas fa-arrow-left"></i>
            Back to Home
        </a>
        
        <!-- Basic Requirements -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-user-check"></i>
                Basic Requirements
            </h2>
            <div class="row">
                <div class="col-md-6">
                    <div class="requirement-item">
                        <div class="requirement-title">
                            <i class="fas fa-graduation-cap"></i>
                            Education & Expertise
                        </div>
                        <div class="requirement-description">
                            <ul class="checklist">
                                <li><i class="fas fa-check-circle"></i>Relevant degree, certification, or proven professional experience</li>
                                <li><i class="fas fa-check-circle"></i>At least 2 years of experience in your subject area</li>
                                <li><i class="fas fa-check-circle"></i>Ability to demonstrate deep knowledge in your field</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="requirement-item">
                        <div class="requirement-title">
                            <i class="fas fa-language"></i>
                            Communication Skills
                        </div>
                        <div class="requirement-description">
                            <ul class="checklist">
                                <li><i class="fas fa-check-circle"></i>Fluent in English (written and spoken)</li>
                                <li><i class="fas fa-check-circle"></i>Clear and engaging communication style</li>
                                <li><i class="fas fa-check-circle"></i>Ability to explain complex concepts simply</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Technical Requirements -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-laptop"></i>
                Technical Requirements
            </h2>
            <div class="row">
                <div class="col-md-4">
                    <div class="requirement-item">
                        <div class="requirement-title">
                            <i class="fas fa-video"></i>
                            Equipment
                        </div>
                        <div class="requirement-description">
                            <ul class="checklist">
                                <li><i class="fas fa-check-circle"></i>HD camera or webcam (720p minimum)</li>
                                <li><i class="fas fa-check-circle"></i>Quality microphone for clear audio</li>
                                <li><i class="fas fa-check-circle"></i>Reliable internet connection (10+ Mbps)</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="requirement-item">
                        <div class="requirement-title">
                            <i class="fas fa-desktop"></i>
                            Software
                        </div>
                        <div class="requirement-description">
                            <ul class="checklist">
                                <li><i class="fas fa-check-circle"></i>Video recording/editing software</li>
                                <li><i class="fas fa-check-circle"></i>Screen recording capabilities</li>
                                <li><i class="fas fa-check-circle"></i>Presentation software knowledge</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="requirement-item">
                        <div class="requirement-title">
                            <i class="fas fa-clock"></i>
                            Time Commitment
                        </div>
                        <div class="requirement-description">
                            <ul class="checklist">
                                <li><i class="fas fa-check-circle"></i>Minimum 5 hours per week</li>
                                <li><i class="fas fa-check-circle"></i>Respond to student questions within 48 hours</li>
                                <li><i class="fas fa-check-circle"></i>Regular course content updates</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Course Standards -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-star"></i>
                Course Quality Standards
            </h2>
            <div class="row">
                <div class="col-md-6">
                    <div class="requirement-item">
                        <div class="requirement-title">
                            <i class="fas fa-play-circle"></i>
                            Content Quality
                        </div>
                        <div class="requirement-description">
                            <ul class="checklist">
                                <li><i class="fas fa-check-circle"></i>Minimum 30 minutes of total video content</li>
                                <li><i class="fas fa-check-circle"></i>Well-structured learning objectives</li>
                                <li><i class="fas fa-check-circle"></i>Practical exercises and assessments</li>
                                <li><i class="fas fa-check-circle"></i>Downloadable resources and materials</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="requirement-item">
                        <div class="requirement-title">
                            <i class="fas fa-users"></i>
                            Student Support
                        </div>
                        <div class="requirement-description">
                            <ul class="checklist">
                                <li><i class="fas fa-check-circle"></i>Active participation in Q&A sections</li>
                                <li><i class="fas fa-check-circle"></i>Timely responses to student inquiries</li>
                                <li><i class="fas fa-check-circle"></i>Regular course announcements</li>
                                <li><i class="fas fa-check-circle"></i>Continuous course improvement</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Call to Action -->
        <div class="cta-section">
            <h2>Ready to Start Teaching?</h2>
            <p>If you meet these requirements and are passionate about sharing your knowledge, we'd love to have you join our instructor community.</p>
            <a href="auth/register.php" class="btn-get-started">
                Get Started as Instructor
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
