<?php
// Force proper session configuration for production Linux server
ini_set('session.save_handler', 'files');
ini_set('session.save_path', '/tmp');
ini_set('session.use_cookies', 1);
ini_set('session.cookie_lifetime', 0);
ini_set('session.cookie_path', '/');
ini_set('session.cookie_domain', '');
ini_set('session.cookie_secure', 0);
ini_set('session.cookie_httponly', 1);

session_start();
require_once 'config/db_connect.php';

// CMS Integration
$cms_enabled = true;
if (file_exists('cms/functions/cms_functions.php')) {
    require_once 'cms/functions/cms_functions.php';
} else {
    $cms_enabled = false;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms of Use - Panadite Academy</title>
    <meta name="description" content="Read Panadite Academy's Terms of Use to understand your rights and responsibilities when using our educational platform and services.">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #276BE4;
            --primary-amber: #FFA915;
            --dark-text: #2d3748;
            --light-text: #718096;
            --bg-light: #f8f9fa;
            --border-color: #e2e8f0;
            --success-green: #10b981;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: #ffffff;
            color: var(--dark-text);
            line-height: 1.6;
        }
        
        .hero-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: var(--dark-text);
            padding: 4rem 0 3rem;
            margin-bottom: 3rem;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 25% 75%, rgba(39, 107, 228, 0.03) 0%, transparent 50%),
                radial-gradient(circle at 75% 25%, rgba(255, 169, 21, 0.03) 0%, transparent 50%);
            animation: backgroundPulse 8s ease-in-out infinite alternate;
        }
        
        @keyframes backgroundPulse {
            0% { opacity: 0.3; }
            100% { opacity: 0.8; }
        }
        
        .floating-element {
            position: absolute;
            pointer-events: none;
            opacity: 0.1;
        }
        
        .floating-element:nth-child(1) {
            top: 12%;
            left: 8%;
            animation: float1 8s ease-in-out infinite;
        }
        
        .floating-element:nth-child(2) {
            top: 65%;
            right: 12%;
            animation: float2 7s ease-in-out infinite reverse;
        }
        
        .floating-element:nth-child(3) {
            bottom: 20%;
            left: 72%;
            animation: float3 9s ease-in-out infinite;
        }
        
        @keyframes float1 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(20px, -25px) rotate(180deg); }
        }
        
        @keyframes float2 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(-35px, -20px) rotate(-180deg); }
        }
        
        @keyframes float3 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(25px, 30px) rotate(360deg); }
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
        }
        
        .hero-content h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            line-height: 1.2;
            color: var(--dark-text);
            animation: fadeInUp 1s ease-out 0.2s both;
        }
        
        .hero-content p {
            font-size: 1.1rem;
            color: var(--light-text);
            margin-bottom: 2rem;
            max-width: 600px;
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 0.4s both;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .content-section {
            padding: 2rem 0;
        }
        
        .terms-card {
            background: white;
            border-radius: 16px;
            padding: 3rem 2.5rem;
            margin-bottom: 3rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
            transition: all 0.3s ease;
            opacity: 0;
            transform: translateY(30px);
            animation: slideInUp 0.6s ease-out forwards;
        }
        
        .terms-card:nth-child(1) { animation-delay: 0.1s; }
        .terms-card:nth-child(2) { animation-delay: 0.2s; }
        .terms-card:nth-child(3) { animation-delay: 0.3s; }
        .terms-card:nth-child(4) { animation-delay: 0.4s; }
        .terms-card:nth-child(5) { animation-delay: 0.5s; }
        .terms-card:nth-child(6) { animation-delay: 0.6s; }
        
        @keyframes slideInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .terms-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 40px rgba(39, 107, 228, 0.15);
            border-color: rgba(39, 107, 228, 0.2);
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--dark-text);
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            padding-left: 0.5rem;
        }
        
        .section-title i {
            background: var(--primary-blue);
            color: white;
            width: 45px;
            height: 45px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            font-size: 1.1rem;
        }
        
        .terms-content {
            color: var(--dark-text);
            line-height: 1.7;
        }
        
        .terms-content h3 {
            color: var(--primary-blue);
            font-size: 1.2rem;
            font-weight: 600;
            margin: 1.5rem 0 1rem;
        }
        
        .terms-content ul {
            padding-left: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        .terms-content li {
            margin-bottom: 0.5rem;
            color: var(--light-text);
        }
        
        .terms-content strong {
            color: var(--dark-text);
        }
        
        .back-btn {
            background: white;
            color: var(--primary-blue);
            border: 1px solid var(--border-color);
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            margin-bottom: 2rem;
        }
        
        .back-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }
        
        .back-btn i {
            margin-right: 0.5rem;
        }
        
        .last-updated {
            background: var(--bg-light);
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 2rem;
            border-left: 4px solid var(--primary-blue);
        }
        
        .last-updated strong {
            color: var(--primary-blue);
        }
        
        .highlight-box {
            background: rgba(39, 107, 228, 0.05);
            border-left: 4px solid var(--primary-blue);
            padding: 1.5rem;
            margin: 1.5rem 0;
            border-radius: 8px;
        }
        
        .warning-box {
            background: rgba(255, 193, 7, 0.1);
            border-left: 4px solid #ffc107;
            padding: 1.5rem;
            margin: 1.5rem 0;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <?php if ($cms_enabled && isAdminLoggedIn()): ?>
    <!-- CMS Inline Editor for Admins -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="cms/assets/css/inline-editor.css">
    <script src="cms/assets/js/inline-editor.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🔧 CMS Debug: DOM loaded, checking InlineEditor...');
            setTimeout(function() {
                if (typeof PanaditeInlineEditor !== 'undefined') {
                    console.log('🔧 CMS Debug: InlineEditor found, initializing...');
                    try {
                        InlineEditor.init();
                        console.log('🔧 CMS Debug: InlineEditor initialized successfully!');
                    } catch (e) {
                        console.error('🔧 CMS Debug: InlineEditor init failed:', e);
                    }
                } else {
                    console.error('🔧 CMS Debug: InlineEditor not found!');
                }
            }, 500);
        });
    </script>
    <?php endif; ?>
    
    <?php include 'includes/navbar.php'; ?>
    
    <!-- Hero Section -->
    <section class="hero-section">
        <!-- Floating animated elements -->
        <div class="floating-element">
            <i class="fas fa-gavel" style="font-size: 48px; color: var(--primary-blue);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-balance-scale" style="font-size: 44px; color: var(--primary-amber);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-handshake" style="font-size: 40px; color: var(--success-green);"></i>
        </div>
        
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1><?php echo cms('terms_page', 'hero_title', 'Terms of Use'); ?></h1>
                        <p><?php echo cms('terms_page', 'hero_description', 'These terms govern your use of Panadite Academy\'s educational platform and services. By using our platform, you agree to these terms and conditions.'); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="hero-visual">
                        <i class="fas fa-gavel" style="font-size: 5rem; color: var(--primary-blue);"></i>
                        <h3 style="margin: 1rem 0 0.5rem; color: var(--dark-text);"><?php echo cms('terms_page', 'hero_visual_title', 'Legal Agreement'); ?></h3>
                        <p style="margin: 0.5rem 0 0; color: var(--light-text); font-size: 0.95rem;"><?php echo cms('terms_page', 'hero_visual_subtitle', 'Fair and Transparent Terms'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Main Content -->
    <div class="container">
        <a href="index.php" class="back-btn">
            <i class="fas fa-arrow-left"></i>
            Back to Home
        </a>
        
        <div class="content-section">
            <!-- Acceptance of Terms -->
            <div class="terms-card">
                <div class="section-title">
                    <i class="fas fa-check-circle"></i>
                    <?php echo cms('terms_page', 'acceptance_title', 'Acceptance of Terms'); ?>
                </div>
                <div class="terms-content">
                    <p><?php echo cms('terms_page', 'acceptance_description', 'By accessing and using Panadite Academy ("the Platform", "our Service"), you accept and agree to be bound by the terms and provision of this agreement.'); ?></p>
                    
                    <div class="highlight-box">
                        <strong>Important:</strong> <?php echo cms('terms_page', 'acceptance_important', 'If you do not agree to abide by the above, please do not use this service. Your continued use of the Platform constitutes acceptance of these terms.'); ?>
                    </div>
                    
                    <h3><?php echo cms('terms_page', 'agreement_updates_title', 'Agreement Updates'); ?></h3>
                    <ul>
                        <li><?php echo cms('terms_page', 'update_point_1', 'We reserve the right to modify these terms at any time'); ?></li>
                        <li><?php echo cms('terms_page', 'update_point_2', 'Material changes will be communicated via email or platform notifications'); ?></li>
                        <li><?php echo cms('terms_page', 'update_point_3', 'Continued use after changes indicates acceptance of new terms'); ?></li>
                        <li><?php echo cms('terms_page', 'update_point_4', 'You are responsible for regularly reviewing these terms'); ?></li>
                    </ul>
                </div>
            </div>
            
            <!-- Platform Usage -->
            <div class="terms-card">
                <div class="section-title">
                    <i class="fas fa-laptop-code"></i>
                    <?php echo cms('terms_page', 'platform_usage_title', 'Platform Usage and Account Responsibilities'); ?>
                </div>
                <div class="terms-content">
                    <h3><?php echo cms('terms_page', 'account_registration_title', 'Account Registration'); ?></h3>
                    <ul>
                        <li><strong>Accurate Information:</strong> <?php echo cms('terms_page', 'accurate_info_desc', 'Provide truthful and accurate registration information'); ?></li>
                        <li><strong>Account Security:</strong> <?php echo cms('terms_page', 'account_security_desc', 'Maintain the confidentiality of your login credentials'); ?></li>
                        <li><strong>Age Requirement:</strong> <?php echo cms('terms_page', 'age_requirement_desc', 'Users must be at least 13 years old (or age of digital consent in your jurisdiction)'); ?></li>
                        <li><strong>Single Account:</strong> <?php echo cms('terms_page', 'single_account_desc', 'Maintain only one account per person'); ?></li>
                    </ul>
                    
                    <h3><?php echo cms('terms_page', 'acceptable_use_title', 'Acceptable Use'); ?></h3>
                    <p><?php echo cms('terms_page', 'acceptable_use_intro', 'You agree to use the Platform only for lawful purposes and in accordance with these terms. Prohibited activities include:'); ?></p>
                    <ul>
                        <li><?php echo cms('terms_page', 'prohibited_1', 'Sharing account credentials with others'); ?></li>
                        <li><?php echo cms('terms_page', 'prohibited_2', 'Attempting to gain unauthorized access to the Platform or other accounts'); ?></li>
                        <li><?php echo cms('terms_page', 'prohibited_3', 'Uploading malicious software or harmful content'); ?></li>
                        <li><?php echo cms('terms_page', 'prohibited_4', 'Engaging in harassment, discrimination, or abusive behavior'); ?></li>
                        <li><?php echo cms('terms_page', 'prohibited_5', 'Violating intellectual property rights'); ?></li>
                        <li><?php echo cms('terms_page', 'prohibited_6', 'Using automated tools to scrape or download content'); ?></li>
                    </ul>
                    
                    <div class="warning-box">
                        <strong>Violation Consequences:</strong> <?php echo cms('terms_page', 'violation_consequences', 'Violations may result in account suspension, content removal, or permanent termination of access to the Platform.'); ?>
                    </div>
                </div>
            </div>
            
            <!-- Course Content and Intellectual Property -->
            <div class="terms-card">
                <div class="section-title">
                    <i class="fas fa-copyright"></i>
                    <?php echo cms('terms_page', 'content_ip_title', 'Course Content and Intellectual Property'); ?>
                </div>
                <div class="terms-content">
                    <h3><?php echo cms('terms_page', 'content_ownership_title', 'Content Ownership'); ?></h3>
                    <ul>
                        <li><strong>Platform Content:</strong> <?php echo cms('terms_page', 'platform_content_desc', 'All courses, videos, materials, and platform features are owned by Panadite Academy or licensed content providers'); ?></li>
                        <li><strong>User-Generated Content:</strong> <?php echo cms('terms_page', 'user_content_desc', 'You retain ownership of content you create, but grant us license to use it on the Platform'); ?></li>
                        <li><strong>Instructor Content:</strong> <?php echo cms('terms_page', 'instructor_content_desc', 'Instructors retain ownership while granting Platform usage rights'); ?></li>
                    </ul>
                    
                    <h3><?php echo cms('terms_page', 'usage_rights_title', 'Usage Rights'); ?></h3>
                    <ul>
                        <li><strong>Personal Use Only:</strong> <?php echo cms('terms_page', 'personal_use_desc', 'Course content is for your personal educational use'); ?></li>
                        <li><strong>No Redistribution:</strong> <?php echo cms('terms_page', 'no_redistribution_desc', 'You may not share, copy, or redistribute course materials'); ?></li>
                        <li><strong>No Commercial Use:</strong> <?php echo cms('terms_page', 'no_commercial_desc', 'Course content cannot be used for commercial purposes'); ?></li>
                        <li><strong>Access Duration:</strong> <?php echo cms('terms_page', 'access_duration_desc', 'Access to purchased courses is typically lifetime unless otherwise specified'); ?></li>
                    </ul>
                    
                    <h3><?php echo cms('terms_page', 'copyright_protection_title', 'Copyright Protection'); ?></h3>
                    <p><?php echo cms('terms_page', 'copyright_intro', 'We respect intellectual property rights and expect users to do the same. If you believe content infringes your copyright, please contact us with:'); ?></p>
                    <ul>
                        <li><?php echo cms('terms_page', 'copyright_req_1', 'Description of the copyrighted work'); ?></li>
                        <li><?php echo cms('terms_page', 'copyright_req_2', 'Location of the infringing content'); ?></li>
                        <li><?php echo cms('terms_page', 'copyright_req_3', 'Your contact information'); ?></li>
                        <li><?php echo cms('terms_page', 'copyright_req_4', 'Statement of good faith belief'); ?></li>
                        <li><?php echo cms('terms_page', 'copyright_req_5', 'Statement of accuracy under penalty of perjury'); ?></li>
                    </ul>
                </div>
            </div>
            
            <!-- Payments and Refunds -->
            <div class="terms-card">
                <div class="section-title">
                    <i class="fas fa-credit-card"></i>
                    <?php echo cms('terms_page', 'payments_title', 'Payments, Subscriptions, and Refunds'); ?>
                </div>
                <div class="terms-content">
                    <h3><?php echo cms('terms_page', 'payment_terms_title', 'Payment Terms'); ?></h3>
                    <ul>
                        <li><strong>Currency:</strong> <?php echo cms('terms_page', 'currency_desc', 'All prices are displayed in the applicable local currency'); ?></li>
                        <li><strong>Payment Processing:</strong> <?php echo cms('terms_page', 'payment_processing_desc', 'Payments are processed securely through third-party providers'); ?></li>
                        <li><strong>Taxes:</strong> <?php echo cms('terms_page', 'taxes_desc', 'You are responsible for applicable taxes in your jurisdiction'); ?></li>
                        <li><strong>Price Changes:</strong> <?php echo cms('terms_page', 'price_changes_desc', 'We reserve the right to modify pricing with notice'); ?></li>
                    </ul>
                    
                    <h3><?php echo cms('terms_page', 'subscription_services_title', 'Subscription Services'); ?></h3>
                    <ul>
                        <li><strong>Auto-Renewal:</strong> <?php echo cms('terms_page', 'auto_renewal_desc', 'Subscriptions automatically renew unless cancelled'); ?></li>
                        <li><strong>Cancellation:</strong> <?php echo cms('terms_page', 'cancellation_desc', 'Cancel anytime through your account settings'); ?></li>
                        <li><strong>Access Period:</strong> <?php echo cms('terms_page', 'access_period_desc', 'Access continues until the end of the current billing period after cancellation'); ?></li>
                    </ul>
                    
                    <h3><?php echo cms('terms_page', 'refund_policy_title', 'Refund Policy'); ?></h3>
                    <div class="highlight-box">
                        <strong>30-Day Money-Back Guarantee:</strong> <?php echo cms('terms_page', 'money_back_guarantee', 'Request a full refund within 30 days of purchase if you\'re not satisfied with a course.'); ?>
                    </div>
                    
                    <p><?php echo cms('terms_page', 'refund_conditions_intro', 'Refund conditions:'); ?></p>
                    <ul>
                        <li><?php echo cms('terms_page', 'refund_condition_1', 'Must be requested within 30 days of purchase'); ?></li>
                        <li><?php echo cms('terms_page', 'refund_condition_2', 'Limited to courses with less than 30% completion'); ?></li>
                        <li><?php echo cms('terms_page', 'refund_condition_3', 'Refunds processed to original payment method within 5-10 business days'); ?></li>
                        <li><?php echo cms('terms_page', 'refund_condition_4', 'Subscription refunds are prorated for unused time'); ?></li>
                    </ul>
                </div>
            </div>
            
            <!-- User Conduct and Community Guidelines -->
            <div class="terms-card">
                <div class="section-title">
                    <i class="fas fa-users"></i>
                    <?php echo cms('terms_page', 'user_conduct_title', 'User Conduct and Community Guidelines'); ?>
                </div>
                <div class="terms-content">
                    <h3><?php echo cms('terms_page', 'community_standards_title', 'Community Standards'); ?></h3>
                    <p><?php echo cms('terms_page', 'community_standards_intro', 'Panadite Academy fosters a respectful learning environment. We expect all users to:'); ?></p>
                    <ul>
                        <li><strong>Be Respectful:</strong> <?php echo cms('terms_page', 'be_respectful_desc', 'Treat instructors and fellow learners with courtesy'); ?></li>
                        <li><strong>Stay on Topic:</strong> <?php echo cms('terms_page', 'stay_on_topic_desc', 'Keep discussions relevant to course content'); ?></li>
                        <li><strong>Use Appropriate Language:</strong> <?php echo cms('terms_page', 'appropriate_language_desc', 'Avoid profanity, hate speech, or offensive content'); ?></li>
                        <li><strong>Respect Privacy:</strong> <?php echo cms('terms_page', 'respect_privacy_desc', 'Don\'t share personal information of others'); ?></li>
                        <li><strong>Be Constructive:</strong> <?php echo cms('terms_page', 'be_constructive_desc', 'Provide helpful feedback and ask meaningful questions'); ?></li>
                    </ul>
                    
                    <h3><?php echo cms('terms_page', 'prohibited_content_title', 'Prohibited Content'); ?></h3>
                    <p><?php echo cms('terms_page', 'prohibited_content_intro', 'The following content is strictly prohibited:'); ?></p>
                    <ul>
                        <li><?php echo cms('terms_page', 'prohibited_content_1', 'Spam, promotional, or commercial content'); ?></li>
                        <li><?php echo cms('terms_page', 'prohibited_content_2', 'Discriminatory, hateful, or harassing material'); ?></li>
                        <li><?php echo cms('terms_page', 'prohibited_content_3', 'Illegal, fraudulent, or harmful content'); ?></li>
                        <li>Personal attacks or threats</li>
                        <li>Copyright-infringing material</li>
                        <li>False or misleading information</li>
                    </ul>
                    
                    <h3>Enforcement</h3>
                    <p>Violations may result in:</p>
                    <ul>
                        <li>Content removal or editing</li>
                        <li>Temporary account suspension</li>
                        <li>Permanent account termination</li>
                        <li>Legal action for severe violations</li>
                    </ul>
                </div>
            </div>
            
            <!-- Platform Availability and Disclaimers -->
            <div class="terms-card">
                <div class="section-title">
                    <i class="fas fa-exclamation-triangle"></i>
                    Platform Availability and Disclaimers
                </div>
                <div class="terms-content">
                    <h3>Service Availability</h3>
                    <ul>
                        <li><strong>Uptime Goal:</strong> We strive for 99.9% uptime but cannot guarantee uninterrupted service</li>
                        <li><strong>Maintenance:</strong> Scheduled maintenance will be announced in advance when possible</li>
                        <li><strong>Technical Issues:</strong> We work quickly to resolve technical problems as they arise</li>
                    </ul>
                    
                    <h3>Content Disclaimers</h3>
                    <div class="warning-box">
                        <strong>Educational Purpose:</strong> Courses are for educational purposes only and do not guarantee specific outcomes, certifications, or job placements.
                    </div>
                    
                    <ul>
                        <li><strong>Accuracy:</strong> While we strive for accuracy, content may become outdated</li>
                        <li><strong>Professional Advice:</strong> Course content does not constitute professional advice</li>
                        <li><strong>Results:</strong> Individual learning outcomes may vary</li>
                        <li><strong>External Links:</strong> We are not responsible for third-party content or websites</li>
                    </ul>
                    
                    <h3>Limitation of Liability</h3>
                    <p>To the maximum extent permitted by law, Panadite Academy shall not be liable for:</p>
                    <ul>
                        <li>Indirect, incidental, or consequential damages</li>
                        <li>Loss of profits, data, or business opportunities</li>
                        <li>Service interruptions or technical failures</li>
                        <li>Actions of third-party instructors or users</li>
                    </ul>
                </div>
            </div>
            
            <!-- Termination and Contact Information -->
            <div class="terms-card">
                <div class="section-title">
                    <i class="fas fa-envelope"></i>
                    <?php echo cms('terms_page', 'termination_title', 'Termination and Contact Information'); ?>
                </div>
                <div class="terms-content">
                    <h3><?php echo cms('terms_page', 'account_termination_title', 'Account Termination'); ?></h3>
                    <ul>
                        <li><strong>By You:</strong> <?php echo cms('terms_page', 'termination_by_you', 'You may delete your account at any time through account settings'); ?></li>
                        <li><strong>By Us:</strong> <?php echo cms('terms_page', 'termination_by_us', 'We may terminate accounts for violations of these terms'); ?></li>
                        <li><strong>Effect:</strong> <?php echo cms('terms_page', 'termination_effect', 'Termination results in loss of access to courses and content'); ?></li>
                        <li><strong>Data Retention:</strong> <?php echo cms('terms_page', 'data_retention', 'Account data may be retained for legal and business purposes'); ?></li>
                    </ul>
                    
                    <h3><?php echo cms('terms_page', 'governing_law_title', 'Governing Law'); ?></h3>
                    <p><?php echo cms('terms_page', 'governing_law_desc', 'These terms are governed by the laws of the jurisdiction where Panadite Academy is incorporated, without regard to conflict of law principles.'); ?></p>
                    
                    <h3><?php echo cms('terms_page', 'contact_info_title', 'Contact Information'); ?></h3>
                    <p><?php echo cms('terms_page', 'contact_intro', 'For questions about these terms or to report violations:'); ?></p>
                    <ul>
                        <li><strong>Legal Issues:</strong> <?php echo cms('terms_page', 'legal_email', 'legal@panaditeacademy.com'); ?></li>
                        <li><strong>General Support:</strong> <?php echo cms('terms_page', 'support_email', 'support@panaditeacademy.com'); ?></li>
                        <li><strong>Response Time:</strong> <?php echo cms('terms_page', 'response_time', 'We respond to legal inquiries within 72 hours'); ?></li>
                    </ul>
                    
                    <div class="highlight-box">
                        <strong>Severability:</strong> <?php echo cms('terms_page', 'severability', 'If any provision of these terms is found unenforceable, the remaining provisions will continue in full force.'); ?>
                    </div>
                </div>
            </div>
            
            <!-- Last Updated -->
            <div class="last-updated">
                <p><strong>Last Updated:</strong> <?php echo date('F j, Y'); ?></p>
                <p><?php echo cms('terms_page', 'last_updated_note', 'These terms may be updated periodically. Continued use of the Platform after changes constitutes acceptance of the new terms. We recommend reviewing these terms regularly.'); ?></p>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
