<?php
// SEO-optimized 403 error page
http_response_code(403);

// Set SEO variables for this page
$seo_title = 'Access Forbidden - Panadite Academy | Professional Online Learning Platform';
$seo_description = 'Access to this page is restricted. Join Panadite Academy to unlock professional courses, certifications, and expert-led training.';
$seo_keywords = 'access forbidden, login required, courses, online learning, Panadite Academy, professional training';

// Include comprehensive SEO headers
require_once __DIR__ . '/includes/seo_header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- SEO headers are already included above -->
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    
    <style>
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
        }
        
        .error-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .error-card {
            background: white;
            border-radius: 20px;
            padding: 60px 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.1);
            text-align: center;
            max-width: 600px;
            margin: 0 20px;
        }
        
        .error-number {
            font-size: 120px;
            font-weight: 900;
            color: #dc3545;
            line-height: 1;
            margin-bottom: 20px;
        }
        
        .error-title {
            font-size: 32px;
            font-weight: 700;
            color: #1a202c;
            margin-bottom: 16px;
        }
        
        .error-description {
            font-size: 18px;
            color: #64748b;
            margin-bottom: 40px;
            line-height: 1.6;
        }
        
        .btn-primary {
            background: #276BE4;
            border: none;
            border-radius: 12px;
            padding: 16px 32px;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: #1e5bcc;
            transform: translateY(-2px);
        }
        
        .btn-outline-primary {
            border: 2px solid #276BE4;
            color: #276BE4;
            border-radius: 12px;
            padding: 16px 32px;
            font-weight: 600;
            font-size: 16px;
            background: transparent;
            transition: all 0.3s ease;
        }
        
        .btn-outline-primary:hover {
            background: #276BE4;
            color: white;
            transform: translateY(-2px);
        }
    </style>
</head>

<body>
    <div class="error-container">
        <div class="error-card">
            <!-- Logo -->
            <div class="mb-4">
                <img src="/logo.jpeg" alt="Panadite Academy" style="height: 60px; width: auto;">
            </div>
            
            <!-- Error Number -->
            <div class="error-number">403</div>
            
            <!-- Error Title -->
            <h1 class="error-title">Access Forbidden</h1>
            
            <!-- Error Description -->
            <p class="error-description">
                You don't have permission to access this page. 
                Please log in or contact support if you believe this is an error.
            </p>
            
            <!-- Action Buttons -->
            <div class="d-flex flex-column flex-md-row gap-3 justify-content-center mb-4">
                <a href="/auth/login.php" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt me-2"></i>Login
                </a>
                <a href="/" class="btn btn-outline-primary">
                    <i class="fas fa-home me-2"></i>Back to Home
                </a>
            </div>
            
            <!-- Help Section -->
            <div style="margin-top: 40px; padding-top: 30px; border-top: 1px solid #e2e8f0;">
                <p style="color: #64748b; margin-bottom: 16px;">Need help accessing this content?</p>
                <a href="/contact.php" style="color: #276BE4; text-decoration: none; font-weight: 600;">
                    <i class="fas fa-life-ring me-2"></i>Contact Support
                </a>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
