<?php
// SEO-optimized 404 error page
http_response_code(404);

// Set SEO variables for this page
$seo_title = 'Page Not Found - Panadite Academy | Professional Online Learning Platform';
$seo_description = 'The page you\'re looking for doesn\'t exist. Explore our professional courses, certifications, and expert-led training at Panadite Academy.';
$seo_keywords = 'page not found, courses, online learning, Panadite Academy, professional training, certifications';

// Include comprehensive SEO headers
require_once __DIR__ . '/includes/seo_header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- SEO headers are already included above -->
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    
    <style>
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
        }
        
        .error-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .error-card {
            background: white;
            border-radius: 20px;
            padding: 60px 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.1);
            text-align: center;
            max-width: 600px;
            margin: 0 20px;
        }
        
        .error-number {
            font-size: 120px;
            font-weight: 900;
            color: #276BE4;
            line-height: 1;
            margin-bottom: 20px;
        }
        
        .error-title {
            font-size: 32px;
            font-weight: 700;
            color: #1a202c;
            margin-bottom: 16px;
        }
        
        .error-description {
            font-size: 18px;
            color: #64748b;
            margin-bottom: 40px;
            line-height: 1.6;
        }
        
        .search-section {
            background: #f8fafc;
            border-radius: 12px;
            padding: 30px;
            margin: 30px 0;
        }
        
        .search-input {
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 16px 20px;
            font-size: 16px;
            width: 100%;
            margin-bottom: 16px;
            transition: all 0.3s ease;
        }
        
        .search-input:focus {
            border-color: #276BE4;
            box-shadow: 0 0 0 3px rgba(39, 107, 228, 0.1);
            outline: none;
        }
        
        .btn-primary {
            background: #276BE4;
            border: none;
            border-radius: 12px;
            padding: 16px 32px;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: #1e5bcc;
            transform: translateY(-2px);
        }
        
        .btn-outline-primary {
            border: 2px solid #276BE4;
            color: #276BE4;
            border-radius: 12px;
            padding: 16px 32px;
            font-weight: 600;
            font-size: 16px;
            background: transparent;
            transition: all 0.3s ease;
        }
        
        .btn-outline-primary:hover {
            background: #276BE4;
            color: white;
            transform: translateY(-2px);
        }
        
        .popular-links {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 16px;
            margin-top: 30px;
        }
        
        .popular-link {
            background: white;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            text-decoration: none;
            color: #1a202c;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .popular-link:hover {
            border-color: #276BE4;
            color: #276BE4;
            transform: translateY(-2px);
        }
        
        .popular-link i {
            font-size: 24px;
            color: #276BE4;
        }
    </style>
</head>

<body>
    <div class="error-container">
        <div class="error-card">
            <!-- Logo -->
            <div class="mb-4">
                <img src="/logo.jpeg" alt="Panadite Academy" style="height: 60px; width: auto;">
            </div>
            
            <!-- Error Number -->
            <div class="error-number">404</div>
            
            <!-- Error Title -->
            <h1 class="error-title">Oops! Page Not Found</h1>
            
            <!-- Error Description -->
            <p class="error-description">
                The page you're looking for doesn't exist or has been moved. 
                But don't worry, there's plenty to explore at Panadite Academy!
            </p>
            
            <!-- Search Section -->
            <div class="search-section">
                <h3 style="color: #1a202c; margin-bottom: 20px; font-size: 20px; font-weight: 600;">
                    <i class="fas fa-search me-2"></i>Search Our Courses
                </h3>
                <form action="/search.php" method="GET">
                    <input type="text" name="q" class="search-input" placeholder="Search for courses, topics, or skills...">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search me-2"></i>Search Courses
                    </button>
                </form>
            </div>
            
            <!-- Action Buttons -->
            <div class="d-flex flex-column flex-md-row gap-3 justify-content-center mb-4">
                <a href="/" class="btn btn-primary">
                    <i class="fas fa-home me-2"></i>Back to Home
                </a>
                <a href="/courses.php" class="btn btn-outline-primary">
                    <i class="fas fa-graduation-cap me-2"></i>Browse Courses
                </a>
            </div>
            
            <!-- Popular Links -->
            <div class="popular-links">
                <a href="/courses.php" class="popular-link">
                    <i class="fas fa-graduation-cap"></i>
                    <div>
                        <div style="font-weight: 600;">All Courses</div>
                        <small style="color: #64748b;">Browse our catalog</small>
                    </div>
                </a>
                
                <a href="/about.php" class="popular-link">
                    <i class="fas fa-info-circle"></i>
                    <div>
                        <div style="font-weight: 600;">About Us</div>
                        <small style="color: #64748b;">Learn about Panadite</small>
                    </div>
                </a>
                
                <a href="/teacher/apply.php" class="popular-link">
                    <i class="fas fa-chalkboard-teacher"></i>
                    <div>
                        <div style="font-weight: 600;">Teach</div>
                        <small style="color: #64748b;">Join as instructor</small>
                    </div>
                </a>
                
                <a href="/contact.php" class="popular-link">
                    <i class="fas fa-envelope"></i>
                    <div>
                        <div style="font-weight: 600;">Contact</div>
                        <small style="color: #64748b;">Get in touch</small>
                    </div>
                </a>
            </div>
            
            <!-- Help Section -->
            <div style="margin-top: 40px; padding-top: 30px; border-top: 1px solid #e2e8f0;">
                <p style="color: #64748b; margin-bottom: 16px;">Still need help?</p>
                <a href="/contact.php" style="color: #276BE4; text-decoration: none; font-weight: 600;">
                    <i class="fas fa-life-ring me-2"></i>Contact Support
                </a>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- SEO Analytics Tracking -->
    <script>
        // Track 404 errors for SEO analysis
        if (typeof gtag !== 'undefined') {
            gtag('event', 'page_not_found', {
                'page_url': window.location.href,
                'referrer': document.referrer
            });
        }
        
        // Auto-focus search input
        document.querySelector('.search-input').focus();
    </script>
</body>
</html>
