<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include SEO headers with favicon for about page
$seo_title = 'About Us - Panadite Academy | Our Mission & Expert Team';
$seo_description = 'Learn about Panadite Academy\'s mission to provide world-class online education. Meet our expert instructors and discover our commitment to student success.';
require_once __DIR__ . '/includes/seo_header.php';

// Fix session handling for live server
if (session_status() == PHP_SESSION_NONE) {
    // Force correct session path for Linux server
    ini_set('session.save_path', '/tmp');
    
    // Alternative fallback paths for different server configurations
    if (!is_writable('/tmp')) {
        $temp_paths = ['/var/tmp', sys_get_temp_dir()];
        foreach ($temp_paths as $path) {
            if (is_dir($path) && is_writable($path)) {
                ini_set('session.save_path', $path);
                break;
            }
        }
    }
    
    session_start();
}

// Include database connection if exists
if (file_exists('includes/db.php')) {
    require_once 'includes/db.php';
}

// Include CMS functions only if file exists (for production compatibility)
$cms_enabled = false;
if (file_exists('cms/functions/cms_functions.php')) {
    require_once 'cms/functions/cms_functions.php';
    require_once 'cms/functions/cms_image_helper.php';
    $cms_enabled = true;
} else {
    // Fallback cms function when CMS is not available
    function cms($page_name, $section_key, $default_content = '') {
        return $default_content;
    }
    function cms_editable_image($image_key, $default_src = '', $alt_text = '', $attributes = []) {
        $attr_string = '';
        foreach ($attributes as $key => $value) {
            $attr_string .= ' ' . htmlspecialchars($key) . '="' . htmlspecialchars($value) . '"';
        }
        return '<img src="' . htmlspecialchars($default_src) . '" alt="' . htmlspecialchars($alt_text) . '"' . $attr_string . '>';
    }
    function include_cms_image_assets() { return ''; }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - Panadite Academy</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    
    <?php
    // Include CMS image editing assets if admin is logged in
    if ($cms_enabled) {
        echo include_cms_image_assets();
    }
    ?>
    
    <style>
        :root {
            --primary-color: #276BE4;
            --secondary-color: #1e5bcc;
            --accent-color: #FFA915;
            --light-color: whitesmoke;
            --white: #ffffff;
            --text-dark: #2d3436;
            --text-muted: #636e72;
            --border-radius: 12px;
        }
        /* Modern styling with whitesmoke background */
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background-color: whitesmoke;
        }
        
        /* Hero section with whitesmoke background */
        .hero-section {
            background: whitesmoke;
            color: var(--text-dark);
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="20" cy="20" r="2" fill="rgba(39,107,228,0.1)"/><circle cx="80" cy="40" r="1" fill="rgba(255,169,21,0.15)"/><circle cx="40" cy="80" r="1.5" fill="rgba(39,107,228,0.1)"/></svg>');
            animation: float 20s ease-in-out infinite;
        }
        
        /* Hero text styling for whitesmoke background */
        .hero-section h1 {
            color: var(--text-dark);
            font-weight: 700;
            margin-bottom: 1.5rem;
        }
        
        .hero-section p.lead {
            color: var(--text-muted);
            font-size: 1.2rem;
            margin-bottom: 2rem;
        }
        
        .hero-section .badge {
            background: var(--primary-color);
            color: white;
        }
        
        /* Animations */
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(180deg); }
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-40px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(40px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        /* Animation classes */
        .animate-fade-in {
            animation: fadeIn 1s ease-out forwards;
        }
        
        .animate-slide-left {
            animation: slideInLeft 1s ease-out forwards;
        }
        
        .animate-slide-right {
            animation: slideInRight 1s ease-out forwards;
        }
        
        .animate-delay-1 { animation-delay: 0.3s; }
        .animate-delay-2 { animation-delay: 0.6s; }
        .animate-delay-3 { animation-delay: 0.9s; }
        
        /* Card styling for whitesmoke background */
        .modern-card {
            background: var(--white);
            border-radius: var(--border-radius);
            box-shadow: 0 4px 15px rgba(39, 107, 228, 0.1);
            border: 1px solid rgba(39, 107, 228, 0.05);
            transition: all 0.3s ease;
            overflow: hidden;
        }
        
        .modern-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 30px rgba(39, 107, 228, 0.2);
            border-color: rgba(39, 107, 228, 0.1);
        }
        
        /* Stats cards */
        .stat-card {
            text-align: center;
            padding: 2rem;
            background: var(--white);
            border-radius: var(--border-radius);
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary-color);
            display: block;
        }
        
        /* Team card */
        .team-card {
            text-align: center;
            padding: 2rem;
            background: var(--white);
            border-radius: var(--border-radius);
            box-shadow: 0 4px 15px rgba(39, 107, 228, 0.08);
            transition: all 0.3s ease;
        }
        
        .team-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(39, 107, 228, 0.15);
        }
        
        .team-avatar {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            margin: 0 auto 1rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
        }
        
        /* Ensure uploaded images match the original avatar size */
        .team-avatar-image {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            margin: 0 auto 1rem;
            display: block;
            overflow: hidden;
            position: relative;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
        }
        
        /* Section styling for whitesmoke background */
        .section-title {
            text-align: center;
            margin-bottom: 3rem;
        }
        
        .section-title h2 {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--text-dark);
            margin-bottom: 1rem;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: var(--text-muted);
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Feature list */
        .feature-list {
            list-style: none;
            padding: 0;
        }
        
        .feature-list li {
            padding: 0.75rem 0;
            display: flex;
            align-items: center;
            color: var(--text-dark);
        }
        
        .feature-list li i {
            color: var(--primary-color);
            margin-right: 1rem;
            width: 20px;
        }
        
        /* Button styling with Panadite colors */
        .btn-primary {
            background: var(--primary-color);
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            color: white;
        }
        
        .btn-primary:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(39, 107, 228, 0.3);
            color: white;
        }
        
        /* Accent button */
        .btn-accent {
            background: var(--accent-color);
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            color: var(--text-dark);
        }
        
        .btn-accent:hover {
            background: #e8950f;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(255, 169, 21, 0.3);
            color: var(--text-dark);
        }
        
        /* Additional styling for consistent whitesmoke background */
        .bg-light, section {
            background-color: whitesmoke !important;
        }
        
        .accent-bar {
            background: linear-gradient(90deg, var(--primary-color), var(--accent-color)) !important;
        }
        
        .text-muted {
            color: var(--text-muted) !important;
        }
        
        /* Ensure all headings and text have proper contrast */
        h1, h2, h3, h4, h5, h6 {
            color: var(--text-dark) !important;
        }
        
        p, .lead {
            color: var(--text-muted) !important;
        }
        
        /* Special styling for text that should be darker */
        .fw-bold {
            color: var(--text-dark) !important;
        }
        
        /* Hero button hover effects for whitesmoke background */
        .btn[style*="background: #276BE4"]:hover {
            background: #1e5bcc !important;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(39, 107, 228, 0.3);
        }
        
        .btn[style*="background: transparent"]:hover {
            background: #276BE4 !important;
            color: white !important;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(39, 107, 228, 0.3);
        }
        
        /* Call-to-action button hover effects */
        .btn[style*="background: #FFA915"]:hover {
            background: #e8950f !important;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(255, 169, 21, 0.3);
        }
        
        /* Floating shapes */
        .floating-shape {
            position: absolute;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 16px;
            opacity: 0.15;
            z-index: 1;
        }
        
        /* Hover effects for social links and other interactive elements */
        .hover-primary:hover {
            color: var(--primary-color) !important;
            transition: all 0.3s ease;
        }
        
        /* Category cards styling */
        .category-card {
            background: var(--white);
            border-radius: var(--border-radius);
            box-shadow: 0 4px 15px rgba(39, 107, 228, 0.08);
            transition: all 0.3s ease;
            border: 1px solid rgba(39, 107, 228, 0.05);
        }
        
        .category-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(39, 107, 228, 0.15);
            border-color: rgba(39, 107, 228, 0.1);
        }
        
        .category-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: white;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
        }
        
        .floating-shape-1 {
            width: 60px;
            height: 60px;
            background-color: #276BE4;
            top: 30%;
            left: 10%;
            transform: rotate(15deg);
            animation: float-pulse 8s ease-in-out infinite alternate;
        }
        
        .floating-shape-2 {
            width: 50px;
            height: 50px;
            background-color: #FFA915;
            bottom: 20%;
            right: 5%;
            transform: rotate(-15deg);
            animation: float-scale 10s ease-in-out infinite alternate;
        }
        
        @keyframes float-up-down {
            0% { transform: translateY(0); }
            100% { transform: translateY(30px); }
        }
        
        @keyframes float-left-right {
            0% { transform: translateX(0); }
            100% { transform: translateX(40px); }
        }
        
        @keyframes float-rotate {
            0% { transform: rotate(0); }
            100% { transform: rotate(360deg); }
        }
        
        @keyframes float-pulse {
            0% { transform: scale(1) rotate(15deg); }
            50% { transform: scale(1.1) rotate(10deg); }
            100% { transform: scale(1) rotate(15deg); }
        }
        
        @keyframes float-scale {
            0% { transform: scale(1) rotate(-15deg); }
            50% { transform: scale(1.15) rotate(-10deg); }
            100% { transform: scale(1) rotate(-15deg); }
        }
        
        /* About Page Specific Styles */
        .team-member-card {
            border-radius: 16px;
            overflow: hidden;
            border: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .team-member-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        
        .team-member-image {
            height: 280px;
            background-position: center;
            background-size: cover;
        }
        
        .social-links {
            display: flex;
            gap: 10px;
        }
        
        .social-link {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background-color: rgba(39,107,228,0.1);
            color: #276BE4;
            transition: all 0.3s ease;
        }
        
        .social-link:hover {
            background-color: #276BE4;
            color: white;
        }
        
        /* Team avatar image styles */
        .team-avatar-image {
            position: relative;
            display: inline-block;
        }
        
        .team-avatar-image .team-icon-img {
            width: 100% !important;
            height: 100% !important;
            border-radius: 50% !important;
            object-fit: cover !important;
            position: absolute !important;
            top: 0 !important;
            left: 0 !important;
            transition: all 0.3s ease;
            border: none !important;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        
        .team-avatar-image:hover .team-icon-img {
            transform: scale(1.05);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }
        
        /* CMS admin editing overlay for team images */
        .cms-admin .team-avatar-image::after {
            content: '📷';
            position: absolute;
            top: -5px;
            right: -5px;
            background: #276BE4;
            color: white;
            border-radius: 50%;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            opacity: 0;
            transition: opacity 0.3s ease;
            cursor: pointer;
        }
        
        /* Vision Image Styling */
        .vision-image-container {
            position: relative;
            display: block;
            width: 100%;
        }
        
        .vision-hero-image {
            transition: all 0.3s ease !important;
        }
        
        .vision-hero-image:hover {
            transform: translateY(-5px) scale(1.02);
            box-shadow: 0 12px 35px rgba(39, 107, 228, 0.25) !important;
        }
        
        /* CMS admin editing overlay for vision image */
        .cms-admin .vision-image-container::after {
            content: '📷';
            position: absolute;
            top: 10px;
            right: 10px;
            background: #276BE4;
            color: white;
            border-radius: 50%;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            opacity: 0;
            transition: opacity 0.3s ease;
            cursor: pointer;
            z-index: 10;
        }
        
        .cms-admin .vision-image-container:hover::after {
            opacity: 1;
        }
        
        .cms-admin .team-avatar-image:hover::after {
            opacity: 1;
        }
        
        .value-card {
            border-radius: 16px;
            border: none;
            padding: 25px;
            background-color: white;
            height: 100%;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s ease;
        }
        
        .value-card:hover {
            transform: translateY(-5px);
        }
        
        .value-icon {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 12px;
            font-size: 24px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body<?php if ($cms_enabled && isAdminLoggedIn()): ?> class="cms-admin"<?php endif; ?>>

    <!-- Include the modern navbar -->    
    <?php include 'includes/navbar.php'; ?>

    <!-- Modern Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 mx-auto text-center">
                    <div class="animate-fade-in">
                        <span class="badge bg-light text-primary px-3 py-2 mb-3" style="font-size: 0.9rem; border-radius: 25px;">
                            <i class="fas fa-graduation-cap me-2"></i><?= cms('about', 'hero_badge', 'About Panadite Academy') ?>
                        </span>
                    </div>
                    
                    <h1 class="display-4 fw-bold mb-4 animate-slide-left animate-delay-1">
                        <?= cms('about', 'hero_title', 'Transforming Education for the <span style="color: #ffd700;">Digital Future</span>') ?>
                    </h1>
                    
                    <p class="lead mb-4 animate-slide-left animate-delay-2" style="max-width: 600px; margin: 0 auto;">
                        <?= cms('about', 'hero_description', 'We empower individuals and organizations with cutting-edge skills, preparing them for success in an ever-evolving technological landscape.') ?>
                    </p>
                    
                    <div class="d-flex gap-3 justify-content-center animate-slide-left animate-delay-3">
                        <a href="/courses.php" class="btn btn-lg px-4 py-3" style="background: #276BE4; color: white; border: none; border-radius: 10px; font-weight: 600; transition: all 0.3s ease;">
                            <i class="fas fa-play me-2"></i>Explore Courses
                        </a>
                        <a href="#mission" class="btn btn-lg px-4 py-3" style="background: transparent; color: #276BE4; border: 2px solid #276BE4; border-radius: 10px; font-weight: 600; transition: all 0.3s ease;">
                            <i class="fas fa-info-circle me-2"></i>Learn More
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Mission & Vision Section -->
    <section id="mission" class="py-5" style="background: whitesmoke;">
        <div class="container">
            <div class="row align-items-center mb-5">
                <div class="col-lg-6 animate-slide-left">
                    <div class="section-title text-start">
                        <h2 style="color: #2d3436;"><?= cms('about', 'mission_title', 'Our Mission') ?></h2>
                        <p class="section-subtitle text-start" style="color: #636e72;">
                            <?= cms('about', 'mission_description', 'Deliver cutting-edge technological education that aligns with emerging industry demands, empowering individuals and organizations with future-ready skills.') ?>
                        </p>
                    </div>
                    
                    <ul class="feature-list mt-4">
                        <li><i class="fas fa-check-circle"></i> <?= cms('about', 'mission_point_1', 'Comprehensive training in high-demand skills') ?></li>
                        <li><i class="fas fa-check-circle"></i> <?= cms('about', 'mission_point_2', 'Industry-aligned curriculum and certifications') ?></li>
                        <li><i class="fas fa-check-circle"></i> <?= cms('about', 'mission_point_3', 'Corporate training solutions') ?></li>
                        <li><i class="fas fa-check-circle"></i> <?= cms('about', 'mission_point_4', 'Continuous learning support') ?></li>
                    </ul>
                </div>
                
                <div class="col-lg-6 animate-slide-right">
                    <!-- Vision Image - Editable via CMS -->
                    <div class="vision-image-container mb-4">
                        <?= cms_editable_image(
                            'about_vision_image',
                            'landing_images/laptop-3087585.jpg',
                            'Vision Image - Technology Education Future',
                            [
                                'class' => 'vision-hero-image',
                                'style' => 'width: 100%; height: 400px; border-radius: 12px; object-fit: cover; box-shadow: 0 8px 25px rgba(39, 107, 228, 0.15); transition: transform 0.3s ease; display: block;'
                            ]
                        ) ?>
                    </div>
                    
                    <div class="modern-card p-4">
                        <div class="text-center">
                            <i class="fas fa-target text-primary mb-3" style="font-size: 3rem;"></i>
                            <h4 class="fw-bold mb-3"><?= cms('about', 'vision_title', 'Our Vision') ?></h4>
                            <p class="text-muted">
                                <?= cms('about', 'vision_description', 'To be the leading platform for technology education, creating a skilled workforce ready to tackle the challenges of tomorrow\'s digital economy.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Course Categories Section -->
    <section class="py-5" style="background: white;">
        <div class="container">
            <div class="section-title animate-fade-in">
                <h2><?= cms('about', 'what_we_teach_title', 'What We Teach') ?></h2>
                <p class="section-subtitle">
                    <?= cms('about', 'what_we_teach_subtitle', 'From foundational skills to advanced technologies, we cover the entire spectrum of digital competencies.') ?>
                </p>
            </div>
            
            <div class="row g-4">
                <div class="col-md-4 animate-slide-left animate-delay-1">
                    <div class="modern-card p-4 h-100">
                        <div class="text-center">
                            <i class="fas fa-code text-primary mb-3" style="font-size: 2.5rem;"></i>
                            <h5 class="fw-bold mb-3"><?= cms('about', 'category_programming_title', 'Programming & Development') ?></h5>
                            <p class="text-muted"><?= cms('about', 'category_programming_desc', 'Python, Web Development, AI/ML, and more cutting-edge technologies.') ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4 animate-slide-left animate-delay-2">
                    <div class="modern-card p-4 h-100">
                        <div class="text-center">
                            <i class="fas fa-chart-bar text-primary mb-3" style="font-size: 2.5rem;"></i>
                            <h5 class="fw-bold mb-3"><?= cms('about', 'category_data_science_title', 'Data Science & Analytics') ?></h5>
                            <p class="text-muted"><?= cms('about', 'category_data_science_desc', 'Data analysis, visualization, and business intelligence solutions.') ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4 animate-slide-left animate-delay-3">
                    <div class="modern-card p-4 h-100">
                        <div class="text-center">
                            <i class="fas fa-shield-alt text-primary mb-3" style="font-size: 2.5rem;"></i>
                            <h5 class="fw-bold mb-3"><?= cms('about', 'category_cybersecurity_title', 'Cybersecurity') ?></h5>
                            <p class="text-muted"><?= cms('about', 'category_cybersecurity_desc', 'Protect digital assets with comprehensive security training.') ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Team Section -->
    <section class="py-5" style="background: whitesmoke;">
        <div class="container">
            <div class="section-title animate-fade-in">
                <h2 style="color: #2d3436;"><?= cms('about', 'team_title', 'Meet Our Team') ?></h2>
                <p class="section-subtitle" style="color: #636e72;">
                    <?= cms('about', 'team_subtitle', 'Experienced professionals committed to your success') ?>
                </p>
            </div>
            
            <div class="row g-4 justify-content-center">
                <div class="col-md-4 animate-slide-left animate-delay-1">
                    <div class="modern-card team-card">
                        <div class="team-avatar team-avatar-image">
                            <?= cms_editable_image(
                                'team_expert_instructors_icon',
                                'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iODAiIGhlaWdodD0iODAiIHZpZXdCb3g9IjAgMCA4MCA4MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNDAiIGN5PSI0MCIgcj0iNDAiIGZpbGw9IiM0MzYxZWUiLz4KPHN2ZyB4PSIyMCIgeT0iMjAiIHdpZHRoPSI0MCIgaGVpZ2h0PSI0MCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJ3aGl0ZSI+CjxwYXRoIGQ9Ik0xMiAyQzEzLjEgMiAxNCAyLjkgMTQgNEMxNCA1LjEgMTMuMSA2IDEyIDZDMTAuOSA2IDEwIDUuMSAxMCA0QzEwIDIuOSAxMC45IDIgMTIgMlpNMjEgOUgyMUwyMSA3SDE5VjlDMTkgMTAuMSAxOC4xIDExIDE3IDExSDE1VjEzSDZMMTcgMTNDMTguMSAxMyAxOSAxMy45IDE5IDE1VjE3SDIxVjE1SDIxVjlaTTUuNSA3VjloMi41Vjc5VjFIMi41VjRINVY3SDE1LjVaIiBmaWxsPSIjZmZmIi8+Cjwvc3ZnPgo8L3N2Zz4K',
                                'Expert Instructors Team Icon',
                                ['class' => 'team-icon-img', 'style' => 'width: 120px; height: 120px; border-radius: 50%; object-fit: cover; background: linear-gradient(45deg, #4361ee, #3f37c9);']
                            ) ?>
                        </div>
                        <h5 class="fw-bold"><?= cms('about', 'team_instructors_title', 'Expert Instructors') ?></h5>
                        <p class="text-muted"><?= cms('about', 'team_instructors_desc', 'Industry professionals with years of practical experience') ?></p>
                    </div>
                </div>
                
                <div class="col-md-4 animate-slide-left animate-delay-2">
                    <div class="modern-card team-card">
                        <div class="team-avatar team-avatar-image">
                            <?= cms_editable_image(
                                'team_support_team_icon',
                                'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iODAiIGhlaWdodD0iODAiIHZpZXdCb3g9IjAgMCA4MCA4MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNDAiIGN5PSI0MCIgcj0iNDAiIGZpbGw9IiM0MzYxZWUiLz4KPHN2ZyB4PSIyMCIgeT0iMjAiIHdpZHRoPSI0MCIgaGVpZ2h0PSI0MCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJ3aGl0ZSI+CjxwYXRoIGQ9Ik0xMiAxM0M5Ljc5IDEzIDggMTQuNzkgOCAxN1YyMEgxNlYxN0MxNiAxNC43OSAxNC4yMSAxMyAxMiAxM1pNMTIgMUM5Ljc5IDEgOCAyLjc5IDggNUM4IDcuMjEgOS43OSA5IDEyIDlTMTYgNy4yMSAxNiA1QzE2IDIuNzkgMTQuMjEgMSAxMiAxWiIgZmlsbD0iI2ZmZiIvPgo8L3N2Zz4KPC9zdmc+',
                                'Support Team Icon',
                                ['class' => 'team-icon-img', 'style' => 'width: 120px; height: 120px; border-radius: 50%; object-fit: cover; background: linear-gradient(45deg, #059669, #047857);']
                            ) ?>
                        </div>
                        <h5 class="fw-bold"><?= cms('about', 'team_support_title', 'Support Team') ?></h5>
                        <p class="text-muted"><?= cms('about', 'team_support_desc', 'Dedicated support staff to help you throughout your learning journey') ?></p>
                    </div>
                </div>
                
                <div class="col-md-4 animate-slide-left animate-delay-3">
                    <div class="modern-card team-card">
                        <div class="team-avatar team-avatar-image">
                            <?= cms_editable_image(
                                'team_tech_team_icon',
                                'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iODAiIGhlaWdodD0iODAiIHZpZXdCb3g9IjAgMCA4MCA4MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNDAiIGN5PSI0MCIgcj0iNDAiIGZpbGw9IiM0MzYxZWUiLz4KPHN2ZyB4PSIyMCIgeT0iMjAiIHdpZHRoPSI0MCIgaGVpZ2h0PSI0MCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJ3aGl0ZSI+CjxwYXRoIGQ9Ik05IDRINVY2SDlWNFpNOSAxMkg1VjEwSDlWMTJaTTkgMTZINVYxNEg5VjE2Wk0xMSAxNkgxOVYxNEgxMVYxNlpNMTEgMTJIMTlWMTBIMTFWMTJaTTExIDhIMTlWNkgxMVY4WiIgZmlsbD0iI2ZmZiIvPgo8L3N2Zz4KPC9zdmc+',
                                'Tech Team Icon',
                                ['class' => 'team-icon-img', 'style' => 'width: 120px; height: 120px; border-radius: 50%; object-fit: cover; background: linear-gradient(45deg, #dc2626, #b91c1c);']
                            ) ?>
                        </div>
                        <h5 class="fw-bold"><?= cms('about', 'team_tech_title', 'Tech Team') ?></h5>
                        <p class="text-muted"><?= cms('about', 'team_tech_desc', 'Innovative developers ensuring the best learning platform experience') ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Call to Action Section -->
    <section class="py-5" style="background: whitesmoke;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 mx-auto text-center animate-fade-in">
                    <h2 class="display-5 fw-bold mb-4" style="color: #2d3436;"><?= cms('about', 'cta_title', 'Ready to Start Your Journey?') ?></h2>
                    <p class="lead mb-4" style="max-width: 600px; margin: 0 auto; color: #636e72;">
                        <?= cms('about', 'cta_description', 'Join thousands of students who have transformed their careers with Panadite Academy\'s comprehensive training programs.') ?>
                    </p>
                    <div class="d-flex gap-3 justify-content-center">
                        <a href="/courses.php" class="btn btn-lg px-4 py-3" style="background: #276BE4; color: white; border: none; border-radius: 10px; font-weight: 600; transition: all 0.3s ease;">
                            <i class="fas fa-rocket me-2"></i>Browse Courses
                        </a>
                        <a href="/contact.php" class="btn btn-lg px-4 py-3" style="background: #FFA915; color: #2d3436; border: none; border-radius: 10px; font-weight: 600; transition: all 0.3s ease;">
                            <i class="fas fa-envelope me-2"></i>Contact Us
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Include consistent footer -->
    <?php include 'includes/footer.php'; ?>

    <!-- Bootstrap JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Animation JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Simple animation trigger for elements in viewport
            setTimeout(() => {
                const animatedElements = document.querySelectorAll('[class*="animate-"]');
                animatedElements.forEach((el) => {
                    el.style.opacity = '1';
                    el.style.transform = 'translateX(0) translateY(0)';
                });
            }, 100);
        });
    </script>

    <?php if ($cms_enabled && isAdminLoggedIn()): ?>
        <!-- Include inline editor styles and scripts for CMS admin -->
        <script src="cms/assets/js/inline-editor.js"></script>
        <script src="cms/functions/inline-image-editor.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Initialize inline editor for text content
                if (typeof InlineEditor !== 'undefined') {
                    InlineEditor.init();
                }
                
                // Wait for the InlineImageEditor to initialize, then add click handlers
                setTimeout(function() {
                    // Add click handlers for team avatar images
                    document.querySelectorAll('.team-avatar-image').forEach(function(avatar) {
                        avatar.addEventListener('click', function(e) {
                            e.preventDefault();
                            const img = avatar.querySelector('.team-icon-img');
                            if (img && window.cmsImageEditor) {
                                // Use the global instance that was created automatically
                                window.cmsImageEditor.openImageEditor(img);
                            }
                        });
                    });
                    
                    // Add click handler for vision image
                    document.querySelectorAll('.vision-image-container').forEach(function(container) {
                        container.addEventListener('click', function(e) {
                            e.preventDefault();
                            const img = container.querySelector('.vision-hero-image');
                            if (img && window.cmsImageEditor) {
                                // Use the global instance that was created automatically
                                window.cmsImageEditor.openImageEditor(img);
                            }
                        });
                    });
                }, 100);
            });
        </script>
    <?php endif; ?>
</body>
</html>
