<?php
require_once '../auth/functions.php';
require_once '../includes/config.php';
require_once '../includes/db_connection.php';

// Ensure user is logged in as an admin
requireRole('admin');

$userId = $_SESSION['user_id'];
$user = getCurrentUser();

// Get the requested URL
$requestedUrl = isset($_SERVER['REQUEST_URI']) ? htmlspecialchars($_SERVER['REQUEST_URI']) : 'Unknown URL';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page Not Found | Panadite Admin</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Boxicons CSS -->
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="/assets/css/admin-dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Modern color variables */
        :root {
            --primary-color: #4e73df;
            --success-color: #1cc88a;
            --info-color: #36b9cc;
            --warning-color: #f6c23e;
            --danger-color: #e74a3b;
            --secondary-color: #858796;
            --light-color: #f8f9fc;
            --dark-color: #5a5c69;
        }
        
        .not-found-container {
            min-height: 70vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .not-found-content {
            text-align: center;
            max-width: 600px;
        }
        
        .error-code {
            font-size: 8rem;
            font-weight: 700;
            color: var(--primary-color);
            line-height: 1;
            margin-bottom: 1rem;
            background: linear-gradient(45deg, #4e73df, #36b9cc);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            opacity: 0.8;
        }
        
        .error-divider {
            width: 80px;
            height: 5px;
            background: linear-gradient(45deg, #4e73df, #36b9cc);
            margin: 1.5rem auto;
            border-radius: 5px;
        }
        
        .error-icon {
            font-size: 5rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
            opacity: 0.7;
        }
        
        .error-url {
            display: inline-block;
            padding: 0.5rem 1rem;
            background-color: rgba(0,0,0,0.05);
            border-radius: 0.5rem;
            margin-top: 1rem;
            font-family: monospace;
            word-break: break-all;
        }
        
        .action-buttons {
            margin-top: 2rem;
        }
        
        .action-buttons .btn {
            margin: 0 0.5rem;
            border-radius: 50px;
            padding: 0.5rem 1.5rem;
            box-shadow: 0 3px 6px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        
        .action-buttons .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.15);
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <?php include 'components/sidebar.php'; ?>
    
    <!-- Main Content -->
    <section class="main-content">
        <!-- Navbar -->
        <?php include 'components/navbar.php'; ?>
        
        <!-- Dashboard Content -->
        <div class="dashboard-content">
            <div class="container-fluid p-4">
                <!-- Page Header -->
                <div class="d-sm-flex justify-content-between align-items-center mb-4">
                    <div class="page-header-wrapper">
                        <h2 class="mb-0 fw-bold">
                            <div class="d-flex align-items-center">
                                <div class="icon-wrapper bg-danger-subtle rounded-circle p-3 me-3" style="width: 48px; height: 48px; display: flex; align-items: center; justify-content: center;">
                                    <i class="bx bx-error-circle fs-3 text-danger"></i>
                                </div>
                                Page Not Found
                            </div>
                        </h2>
                        <p class="text-muted mt-2">The requested resource could not be found on the server</p>
                    </div>
                </div>
                
                <div class="not-found-container">
                    <div class="not-found-content">
                        <div class="error-icon">
                            <i class="bx bx-search-alt"></i>
                        </div>
                        <h1 class="error-code">404</h1>
                        <div class="error-divider"></div>
                        <h3 class="mb-4">Oops! We couldn't find that page.</h3>
                        <p class="text-muted mb-1">The page you're looking for doesn't exist or might have been moved.</p>
                        <p class="text-muted mb-4">Please check the URL or navigate back to the dashboard.</p>
                        
                        <div class="error-url">
                            <?php echo $requestedUrl; ?>
                        </div>
                        
                        <div class="action-buttons">
                            <a href="javascript:history.back()" class="btn btn-outline-secondary">
                                <i class="bx bx-arrow-back me-2"></i>Go Back
                            </a>
                            <a href="index.php" class="btn btn-primary">
                                <i class="bx bx-home me-2"></i>Dashboard
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle functionality
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        const sidebarToggleMobile = document.querySelector('.sidebar-toggle-mobile');
        const sidebar = document.querySelector('.sidebar');
        
        if (sidebarToggle) {
            sidebarToggle.addEventListener('click', () => {
                sidebar.classList.toggle('close');
            });
        }
        
        if (sidebarToggleMobile) {
            sidebarToggleMobile.addEventListener('click', () => {
                sidebar.classList.toggle('show');
            });
        }
        
        // Responsive sidebar behavior
        function checkScreenSize() {
            if (window.innerWidth < 768) {
                sidebar.classList.remove('close');
                sidebar.classList.remove('show');
            } else if (window.innerWidth < 992) {
                sidebar.classList.add('close');
                sidebar.classList.remove('show');
            }
        }
        
        // Initial check and listen for window resize
        checkScreenSize();
        window.addEventListener('resize', checkScreenSize);
    });
    </script>
</body>
</html>
