<?php
// Display all errors for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set content type to HTML
header('Content-Type: text/html');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Teacher-Student Assignments Table</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .success {
            color: green;
            padding: 10px;
            border: 1px solid green;
            background-color: #f0fff0;
            margin: 10px 0;
        }
        .error {
            color: red;
            padding: 10px;
            border: 1px solid red;
            background-color: #fff0f0;
            margin: 10px 0;
        }
        pre {
            background-color: #f5f5f5;
            padding: 10px;
            border: 1px solid #ddd;
            overflow: auto;
        }
    </style>
</head>
<body>
    <h1>Create Teacher-Student Assignments Table</h1>
    
    <?php
    // Database configuration - update these with your actual database settings
    $host = 'localhost';
    $db_name = 'panadite_academy';
    $username = 'root';
    $password = '';
    $charset = 'utf8mb4';
    
    try {
        // Create database connection
        $dsn = "mysql:host=$host;dbname=$db_name;charset=$charset";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        
        echo "<p>Attempting to connect to database...</p>";
        
        $pdo = new PDO($dsn, $username, $password, $options);
        
        echo "<p class='success'>Database connection successful!</p>";
        
        // SQL to create teacher_student_assignments table
        $sql = "CREATE TABLE IF NOT EXISTS teacher_student_assignments (
            assignment_id INT AUTO_INCREMENT PRIMARY KEY,
            teacher_id INT NOT NULL,
            student_id INT NOT NULL,
            assigned_by INT NOT NULL COMMENT 'Admin ID who made the assignment',
            assigned_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            status ENUM('active', 'inactive') DEFAULT 'active',
            notes TEXT,
            FOREIGN KEY (teacher_id) REFERENCES users(user_id) ON DELETE CASCADE,
            FOREIGN KEY (student_id) REFERENCES users(user_id) ON DELETE CASCADE,
            FOREIGN KEY (assigned_by) REFERENCES users(user_id) ON DELETE CASCADE,
            UNIQUE KEY (teacher_id, student_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        
        echo "<p>Executing SQL query to create table...</p>";
        echo "<pre>" . htmlspecialchars($sql) . "</pre>";
        
        // Execute query
        $pdo->exec($sql);
        
        echo "<p class='success'>Teacher-student assignments table created successfully!</p>";
        
        // Optional: Check that the table exists
        $checkSql = "SHOW TABLES LIKE 'teacher_student_assignments'";
        $result = $pdo->query($checkSql);
        
        if ($result->rowCount() > 0) {
            echo "<p class='success'>Verified: Table exists in the database.</p>";
            
            // Show table structure
            $structureSql = "DESCRIBE teacher_student_assignments";
            $stmt = $pdo->query($structureSql);
            $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo "<h3>Table Structure</h3>";
            echo "<pre>";
            print_r($columns);
            echo "</pre>";
        } else {
            echo "<p class='error'>Verification failed: Table was not found after creation.</p>";
        }
        
    } catch (PDOException $e) {
        echo "<p class='error'>Database error: " . $e->getMessage() . "</p>";
    }
    ?>
    
    <p><a href="assign-students.php">Go to Student Assignment Page</a></p>
</body>
</html>
