<?php
require_once __DIR__ . '/../auth/functions.php';
requireRole('admin');

echo "<h2>🔍 API Debug Test</h2>";

// Test the API endpoint directly
$request_id = 6; // Testing with request ID 6 from the admin panel

echo "<h3>Testing API: api/get_accreditation_request.php?request_id=$request_id</h3>";

$api_url = "http://" . $_SERVER['HTTP_HOST'] . "/admin/api/get_accreditation_request.php?request_id=$request_id";
echo "<p><strong>API URL:</strong> $api_url</p>";

// Use cURL to test the API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id()); // Pass session cookie
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
    'Accept: application/json'
));

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

echo "<h3>📊 API Response:</h3>";
echo "<p><strong>HTTP Code:</strong> $http_code</p>";

if ($curl_error) {
    echo "<p><strong>cURL Error:</strong> <span style='color:red;'>$curl_error</span></p>";
}

echo "<h4>Raw Response:</h4>";
echo "<pre style='background:#f5f5f5; padding:10px; border-radius:5px; max-height:300px; overflow-y:scroll;'>";
echo htmlspecialchars($response);
echo "</pre>";

// Try to decode JSON
$json_data = json_decode($response, true);
if ($json_data !== null) {
    echo "<h4>Parsed JSON:</h4>";
    echo "<pre style='background:#e8f5e8; padding:10px; border-radius:5px;'>";
    print_r($json_data);
    echo "</pre>";
} else {
    echo "<p><strong>JSON Parse Error:</strong> <span style='color:red;'>Invalid JSON response</span></p>";
    echo "<p><strong>JSON Error:</strong> " . json_last_error_msg() . "</p>";
}

// Alternative test: Include the API file directly
echo "<hr><h3>🔄 Direct Include Test:</h3>";
echo "<p>Testing API by including it directly...</p>";

ob_start();
try {
    $_GET['request_id'] = $request_id;
    include __DIR__ . '/api/get_accreditation_request.php';
    $direct_response = ob_get_contents();
} catch (Exception $e) {
    $direct_response = "Exception: " . $e->getMessage();
}
ob_end_clean();

echo "<h4>Direct Include Response:</h4>";
echo "<pre style='background:#f0f0f0; padding:10px; border-radius:5px;'>";
echo htmlspecialchars($direct_response);
echo "</pre>";

// Test database connection
echo "<hr><h3>🗄️ Database Connection Test:</h3>";
require_once __DIR__ . '/../config/db_connect.php';

if ($conn->connect_error) {
    echo "<p style='color:red;'>❌ Database connection failed: " . $conn->connect_error . "</p>";
} else {
    echo "<p style='color:green;'>✅ Database connected successfully</p>";
    
    // Test if accreditation_requests table exists and has data
    $result = $conn->query("SELECT COUNT(*) as count FROM accreditation_requests");
    if ($result) {
        $row = $result->fetch_assoc();
        echo "<p>📊 Total accreditation requests in database: <strong>" . $row['count'] . "</strong></p>";
    } else {
        echo "<p style='color:red;'>❌ Error querying accreditation_requests table: " . $conn->error . "</p>";
    }
    
    // Test specific request
    $stmt = $conn->prepare("SELECT request_id, student_id, status, payment_status FROM accreditation_requests WHERE request_id = ?");
    $stmt->bind_param("i", $request_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo "<p>✅ Found request $request_id:</p>";
        echo "<ul>";
        echo "<li>Request ID: " . $row['request_id'] . "</li>";
        echo "<li>Student ID: " . $row['student_id'] . "</li>";
        echo "<li>Status: " . $row['status'] . "</li>";
        echo "<li>Payment Status: " . $row['payment_status'] . "</li>";
        echo "</ul>";
    } else {
        echo "<p style='color:red;'>❌ No request found with ID $request_id</p>";
    }
}

echo "<hr><h3>🔐 Authentication Test:</h3>";
echo "<p>Current user ID: " . ($_SESSION['user_id'] ?? 'Not set') . "</p>";
echo "<p>Current user role: " . ($_SESSION['role'] ?? 'Not set') . "</p>";
echo "<p>Is logged in: " . (isLoggedIn() ? 'Yes' : 'No') . "</p>";
echo "<p>Has admin role: " . (hasRole('admin') ? 'Yes' : 'No') . "</p>";

?>
